/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.util.Date;
import org.babyfish.jimmer.sql.ast.ComparableExpression;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.SqlTimeUnit;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.jetbrains.annotations.NotNull;

public interface DateExpression<T extends Date>
extends ComparableExpression<T> {
    public DateExpression<T> plus(Expression<Long> var1, SqlTimeUnit var2);

    default public DateExpression<T> plus(long value, SqlTimeUnit timeUnit) {
        return this.plus(Expression.value(value), timeUnit);
    }

    default public DateExpression<T> minus(Expression<Long> value, SqlTimeUnit timeUnit) {
        if (value instanceof NumericExpression) {
            return this.plus(((NumericExpression)value).unaryMinus(), timeUnit);
        }
        return this.plus(Expression.numeric().sql(Long.class, "-%e", value), timeUnit);
    }

    default public DateExpression<T> minus(long value, SqlTimeUnit timeUnit) {
        return this.plus(-value, timeUnit);
    }

    public NumericExpression<Float> diff(DateExpression<T> var1, SqlTimeUnit var2);

    default public NumericExpression<Float> diff(T other, SqlTimeUnit timeUnit) {
        return this.diff((T)Expression.value(other), timeUnit);
    }

    @Override
    @NotNull
    public DateExpression<T> coalesce(T var1);

    @Override
    @NotNull
    public DateExpression<T> coalesce(Expression<T> var1);

    @Override
    @NotNull
    public CoalesceBuilder.Dt<T> coalesceBuilder();
}

