/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.CoalesceBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ComparableExpression<T extends Comparable<?>>
extends Expression<T> {
    @NotNull
    public Predicate lt(@NotNull Expression<T> var1);

    @NotNull
    public Predicate lt(@NotNull T var1);

    @Nullable
    default public Predicate ltIf(boolean condition, @Nullable T other) {
        return condition && other != null && !"".equals(other) ? this.lt(other) : null;
    }

    @Nullable
    default public Predicate ltIf(@Nullable T other) {
        return this.ltIf(true, other);
    }

    @NotNull
    public Predicate le(@NotNull Expression<T> var1);

    @NotNull
    public Predicate le(T var1);

    @Nullable
    default public Predicate leIf(boolean condition, @Nullable T other) {
        return condition && other != null && !"".equals(other) ? this.le(other) : null;
    }

    @Nullable
    default public Predicate leIf(@Nullable T other) {
        return this.leIf(true, other);
    }

    @NotNull
    public Predicate gt(Expression<T> var1);

    @NotNull
    public Predicate gt(T var1);

    @Nullable
    default public Predicate gtIf(boolean condition, @Nullable T other) {
        return condition && other != null && !"".equals(other) ? this.gt(other) : null;
    }

    @Nullable
    default public Predicate gtIf(@Nullable T other) {
        return this.gtIf(true, other);
    }

    @NotNull
    public Predicate ge(Expression<T> var1);

    @NotNull
    public Predicate ge(T var1);

    @Nullable
    default public Predicate geIf(boolean condition, @Nullable T other) {
        return condition && other != null && !"".equals(other) ? this.ge(other) : null;
    }

    @Nullable
    default public Predicate geIf(@Nullable T other) {
        return this.geIf(true, other);
    }

    @NotNull
    public Predicate between(Expression<T> var1, Expression<T> var2);

    @NotNull
    public Predicate between(T var1, T var2);

    @Nullable
    default public Predicate betweenIf(boolean condition, @Nullable T min, @Nullable T max) {
        boolean noMax;
        if (!condition) {
            return null;
        }
        boolean noMin = min == null || "".equals(min);
        boolean bl = noMax = max == null || "".equals(max);
        if (noMin && noMax) {
            return null;
        }
        if (noMin) {
            return this.le(max);
        }
        if (noMax) {
            return this.ge(min);
        }
        return this.between(min, max);
    }

    @Nullable
    default public Predicate betweenIf(@Nullable T min, @Nullable T max) {
        return this.betweenIf(true, min, max);
    }

    @NotNull
    public Predicate notBetween(Expression<T> var1, Expression<T> var2);

    @NotNull
    public Predicate notBetween(T var1, T var2);

    @Nullable
    default public Predicate notBetweenIf(boolean condition, @Nullable T min, @Nullable T max) {
        boolean noMax;
        if (!condition) {
            return null;
        }
        boolean noMin = min == null || "".equals(min);
        boolean bl = noMax = max == null || "".equals(max);
        if (noMin && noMax) {
            return null;
        }
        if (noMin) {
            return this.gt(max);
        }
        if (noMax) {
            return this.lt(min);
        }
        return this.notBetween(min, max);
    }

    @Nullable
    default public Predicate notBetweenIf(@Nullable T min, @Nullable T max) {
        return this.notBetweenIf(true, min, max);
    }

    @NotNull
    public ComparableExpression<T> min();

    @NotNull
    public ComparableExpression<T> max();

    @Override
    @NotNull
    public ComparableExpression<T> coalesce(T var1);

    @Override
    @NotNull
    public ComparableExpression<T> coalesce(Expression<T> var1);

    @Override
    @NotNull
    public @NotNull @NotNull CoalesceBuilder.Cmp<T> coalesceBuilder();
}

