/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.kt.ast.expression.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.render.AbstractSqlBuilder;
import org.babyfish.jimmer.sql.kt.ast.expression.KExpression;
import org.babyfish.jimmer.sql.kt.ast.expression.KNonNullExpression;
import org.babyfish.jimmer.sql.kt.ast.expression.impl.AbstractKExpression;
import org.babyfish.jimmer.sql.kt.ast.expression.impl.AbstractKPredicate;
import org.babyfish.jimmer.sql.kt.ast.expression.impl.LiteralExpression;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u0000*\f\b\u0000\u0010\u0001*\u0006\u0012\u0002\b\u00030\u00022\u00020\u0003B9\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\r\u001a\u00020\u0003H\u0096\u0002J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0014\u0010\u0014\u001a\u00020\u00112\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0014J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/babyfish/jimmer/sql/kt/ast/expression/impl/BetweenPredicate;", "T", "", "Lorg/babyfish/jimmer/sql/kt/ast/expression/impl/AbstractKPredicate;", "negative", "", "expression", "Lorg/babyfish/jimmer/sql/kt/ast/expression/KExpression;", "min", "Lorg/babyfish/jimmer/sql/kt/ast/expression/KNonNullExpression;", "max", "<init>", "(ZLorg/babyfish/jimmer/sql/kt/ast/expression/KExpression;Lorg/babyfish/jimmer/sql/kt/ast/expression/KNonNullExpression;Lorg/babyfish/jimmer/sql/kt/ast/expression/KNonNullExpression;)V", "not", "precedence", "", "accept", "", "visitor", "Lorg/babyfish/jimmer/sql/ast/impl/AstVisitor;", "renderTo", "builder", "Lorg/babyfish/jimmer/sql/ast/impl/render/AbstractSqlBuilder;", "determineHasVirtualPredicate", "onResolveVirtualPredicate", "Lorg/babyfish/jimmer/sql/ast/impl/Ast;", "ctx", "Lorg/babyfish/jimmer/sql/ast/impl/AstContext;", "jimmer-sql-kotlin"})
public final class BetweenPredicate<T extends Comparable<?>>
extends AbstractKPredicate {
    private final boolean negative;
    @NotNull
    private KExpression<T> expression;
    @NotNull
    private KNonNullExpression<T> min;
    @NotNull
    private KNonNullExpression<T> max;

    public BetweenPredicate(boolean negative, @NotNull KExpression<T> expression, @NotNull KNonNullExpression<T> min, @NotNull KNonNullExpression<T> max) {
        Intrinsics.checkNotNullParameter(expression, (String)"expression");
        Intrinsics.checkNotNullParameter(min, (String)"min");
        Intrinsics.checkNotNullParameter(max, (String)"max");
        this.negative = negative;
        this.expression = expression;
        this.min = min;
        this.max = max;
        LiteralExpression.Companion.bind((KExpression)this.min, this.expression);
        LiteralExpression.Companion.bind((KExpression)this.max, this.expression);
    }

    @NotNull
    public AbstractKPredicate not() {
        return new BetweenPredicate<T>(!this.negative, this.expression, this.min, this.max);
    }

    public int precedence() {
        return 7;
    }

    public void accept(@NotNull AstVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        KExpression<T> kExpression = this.expression;
        Intrinsics.checkNotNull(kExpression, (String)"null cannot be cast to non-null type org.babyfish.jimmer.sql.ast.impl.Ast");
        ((Ast)kExpression).accept(visitor);
        KNonNullExpression<T> kNonNullExpression = this.min;
        Intrinsics.checkNotNull(kNonNullExpression, (String)"null cannot be cast to non-null type org.babyfish.jimmer.sql.ast.impl.Ast");
        ((Ast)kNonNullExpression).accept(visitor);
        KNonNullExpression<T> kNonNullExpression2 = this.max;
        Intrinsics.checkNotNull(kNonNullExpression2, (String)"null cannot be cast to non-null type org.babyfish.jimmer.sql.ast.impl.Ast");
        ((Ast)kNonNullExpression2).accept(visitor);
    }

    public void renderTo(@NotNull AbstractSqlBuilder<?> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        KExpression<T> kExpression = this.expression;
        Intrinsics.checkNotNull(kExpression, (String)"null cannot be cast to non-null type org.babyfish.jimmer.sql.ast.impl.Ast");
        this.renderChild((Ast)kExpression, builder);
        builder.sql(this.negative ? " not between " : " between ");
        KNonNullExpression<T> kNonNullExpression = this.min;
        Intrinsics.checkNotNull(kNonNullExpression, (String)"null cannot be cast to non-null type org.babyfish.jimmer.sql.ast.impl.Ast");
        this.renderChild((Ast)kNonNullExpression, builder);
        builder.sql(" and ");
        KNonNullExpression<T> kNonNullExpression2 = this.max;
        Intrinsics.checkNotNull(kNonNullExpression2, (String)"null cannot be cast to non-null type org.babyfish.jimmer.sql.ast.impl.Ast");
        this.renderChild((Ast)kNonNullExpression2, builder);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean determineHasVirtualPredicate() {
        if (AbstractKExpression.hasVirtualPredicate(this.expression)) return true;
        if (AbstractKExpression.hasVirtualPredicate(this.min)) return true;
        if (!AbstractKExpression.hasVirtualPredicate(this.max)) return false;
        return true;
    }

    @Override
    @NotNull
    protected Ast onResolveVirtualPredicate(@NotNull AstContext ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = ctx.resolveVirtualPredicate(this.expression);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"resolveVirtualPredicate(...)");
        this.expression = (KExpression)object;
        Object object2 = ctx.resolveVirtualPredicate(this.min);
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"resolveVirtualPredicate(...)");
        this.min = (KNonNullExpression)object2;
        Object object3 = ctx.resolveVirtualPredicate(this.max);
        Intrinsics.checkNotNullExpressionValue((Object)object3, (String)"resolveVirtualPredicate(...)");
        this.max = (KNonNullExpression)object3;
        return this;
    }
}

