/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.tuple;

import java.util.ArrayList;
import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.MetaException;
import org.babyfish.jimmer.apt.tuple.TypedTupleGenerator;
import org.babyfish.jimmer.sql.TypedTuple;
import org.jetbrains.annotations.Nullable;

public class TypedTupleProcessor {
    private final Context context;
    @Nullable
    private final Set<String> delayedTupleTypeNames;

    public TypedTupleProcessor(Context context, @Nullable Set<String> delayedTupleTypeNames) {
        this.context = context;
        this.delayedTupleTypeNames = delayedTupleTypeNames;
    }

    public void process(RoundEnvironment roundEnv) {
        TypeElement typeElement;
        ArrayList<TypeElement> typeElements = new ArrayList<TypeElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(TypedTuple.class)) {
            typeElement = (TypeElement)element;
            if (this.delayedTupleTypeNames != null && this.delayedTupleTypeNames.contains(typeElement.getQualifiedName().toString())) continue;
            typeElements.add(typeElement);
        }
        if (this.delayedTupleTypeNames != null) {
            for (String string : this.delayedTupleTypeNames) {
                typeElement = this.context.getElements().getTypeElement(string);
                typeElements.add(typeElement);
            }
        }
        for (TypeElement typeElement2 : typeElements) {
            this.validate(typeElement2);
        }
        for (TypeElement typeElement3 : typeElements) {
            this.generateTuple(typeElement3);
        }
    }

    private void validate(TypeElement typeElement) {
        if (typeElement.getKind() != ElementKind.CLASS) {
            throw new MetaException(typeElement, "The type decorated by \"@" + TypedTuple.class.getName() + "\" must be class");
        }
        if (!(typeElement.getEnclosingElement() instanceof PackageElement)) {
            throw new MetaException(typeElement, "The type decorated by \"@" + TypedTuple.class.getName() + "\" must be top-level class");
        }
        if (!typeElement.getSuperclass().toString().equals("java.lang.Object")) {
            throw new MetaException(typeElement, "The type decorated by \"@" + TypedTuple.class.getName() + "\" cannot inherit other class");
        }
        if (!typeElement.getTypeParameters().isEmpty()) {
            throw new MetaException(typeElement, "The type decorated by \"@" + TypedTuple.class.getName() + "\" cannot be generic type");
        }
    }

    private void generateTuple(TypeElement typeElement) {
        new TypedTupleGenerator(this.context, typeElement).generate();
    }
}

