/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.entry;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.apt.GeneratorException;
import org.babyfish.jimmer.apt.entry.PackageCollector;

public abstract class IndexFileGenerator {
    protected final Context context;
    private final Map<String, TypeElement> elementMap;
    private final File listFile;

    public IndexFileGenerator(Context context, Collection<TypeElement> typeElements, PackageCollector packageCollector) {
        TreeMap<String, TypeElement> elementMap;
        block17: {
            FileObject fileObject;
            this.context = context;
            String listFilePath = this.getListFilePath();
            elementMap = new TreeMap<String, TypeElement>();
            for (TypeElement typeElement : typeElements) {
                if (typeElement.getKind() != ElementKind.INTERFACE) continue;
                if (this.isManaged(typeElement, true)) {
                    elementMap.put(typeElement.getQualifiedName().toString(), typeElement);
                }
                if (!this.isManaged(typeElement, false)) continue;
                packageCollector.accept(typeElement);
            }
            try {
                fileObject = context.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", listFilePath);
            }
            catch (IOException ex) {
                throw new GeneratorException("Cannot get file object \"" + listFilePath + "\"", ex);
            }
            this.listFile = new File(fileObject.getName());
            if (this.listFile.exists()) {
                try (BufferedReader reader = new BufferedReader(new FileReader(this.listFile));){
                    while (true) {
                        TypeElement typeElement;
                        String line;
                        if ((line = reader.readLine()) == null) {
                            break block17;
                        }
                        if ((line = line.trim()).isEmpty() || (typeElement = context.getElements().getTypeElement(line)) == null) continue;
                        if (this.isManaged(typeElement, true)) {
                            elementMap.put(typeElement.getQualifiedName().toString(), typeElement);
                        }
                        if (!this.isManaged(typeElement, false)) continue;
                        packageCollector.accept(typeElement);
                    }
                }
                catch (IOException ex) {
                    throw new GeneratorException("Cannot read content of \"" + this.listFile + "\"", ex);
                }
            }
            for (TypeElement typeElement : typeElements) {
                if (typeElement == null) continue;
                if (this.isManaged(typeElement, true)) {
                    elementMap.put(typeElement.getQualifiedName().toString(), typeElement);
                }
                if (!this.isManaged(typeElement, false)) continue;
                packageCollector.accept(typeElement);
            }
        }
        this.elementMap = elementMap;
    }

    public void generate() {
        if (this.context.isBuddyIgnoreResourceGeneration()) {
            return;
        }
        this.listFile.getParentFile().mkdirs();
        try (FileWriter writer = new FileWriter(this.listFile);){
            for (String qualifiedName : this.elementMap.keySet()) {
                writer.write(qualifiedName);
                ((Writer)writer).write(10);
            }
        }
        catch (IOException ex) {
            throw new GeneratorException("Cannot write \"" + this.listFile + "\"", ex);
        }
    }

    public Map<String, TypeElement> getElementMap() {
        return Collections.unmodifiableMap(this.elementMap);
    }

    protected abstract String getListFilePath();

    protected abstract boolean isManaged(TypeElement var1, boolean var2);
}

