/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.apt.client;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.babyfish.jimmer.apt.Context;
import org.babyfish.jimmer.client.Description;
import org.babyfish.jimmer.client.meta.Doc;
import org.babyfish.jimmer.impl.util.StringUtil;

public class DocMetadata {
    private final Context ctx;
    private final Map<Element, String> docMap = new HashMap<Element, String>();

    public DocMetadata(Context ctx) {
        this.ctx = ctx;
    }

    public Doc getDoc(Element element) {
        String docString = this.getString(element);
        if (docString != null) {
            return Doc.parse((String)docString);
        }
        return null;
    }

    public String getString(Element element) {
        String docString = this.getStringImpl(element);
        if (docString.isEmpty()) {
            return null;
        }
        return docString;
    }

    private String getStringImpl(Element element) {
        String value;
        Map<String, String> map;
        String value2;
        String docString = this.docMap.get(element);
        if (docString != null) {
            return docString;
        }
        docString = this.ctx.getElements().getDocComment(element);
        if (docString != null && !docString.isEmpty()) {
            this.docMap.put(element, docString);
            return docString;
        }
        Description description = element.getAnnotation(Description.class);
        if (description != null && !(value2 = description.value()).isEmpty()) {
            this.docMap.put(element, value2);
            return value2;
        }
        TypeElement typeElement = element instanceof ExecutableElement ? (TypeElement)element.getEnclosingElement() : (element instanceof TypeElement ? (TypeElement)element : null);
        if (typeElement != null && !(map = this.implDocStringMap(typeElement)).isEmpty()) {
            this.docMap.put(typeElement, map.get(""));
            this.addPropDocs(typeElement, map);
        }
        if ((value = this.docMap.get(element)) == null) {
            this.docMap.put(element, "");
            return "";
        }
        return value;
    }

    private void addPropDocs(TypeElement typeElement, Map<String, String> map) {
        for (Element element : typeElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || (executableElement = (ExecutableElement)element).getReturnType().getKind() == TypeKind.VOID || !executableElement.getTypeParameters().isEmpty() || !executableElement.getParameters().isEmpty()) continue;
            this.docMap.put(element, map.getOrDefault(executableElement.getSimpleName().toString(), ""));
        }
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            TypeElement superElement = (TypeElement)this.ctx.getTypes().asElement(typeMirror);
            this.addPropDocs(superElement, map);
        }
    }

    private Map<String, String> implDocStringMap(TypeElement typeElement) {
        TypeElement implElement = this.ctx.getElements().getTypeElement(typeElement.getQualifiedName() + "Draft");
        if (implElement == null) {
            return Collections.emptyMap();
        }
        if ((implElement = (TypeElement)implElement.getEnclosedElements().stream().filter(it -> it instanceof TypeElement && "Producer".equals(it.getSimpleName().toString())).findFirst().orElse(null)) == null) {
            return Collections.emptyMap();
        }
        if ((implElement = (TypeElement)implElement.getEnclosedElements().stream().filter(it -> it instanceof TypeElement && "Impl".equals(it.getSimpleName().toString())).findFirst().orElse(null)) == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        Description description = implElement.getAnnotation(Description.class);
        if (description != null && !description.value().isEmpty()) {
            map.put("", description.value());
        }
        for (Element element : implElement.getEnclosedElements()) {
            ExecutableElement executableElement;
            if (!(element instanceof ExecutableElement) || (executableElement = (ExecutableElement)element).getReturnType().getKind() == TypeKind.VOID || !executableElement.getParameters().isEmpty() || !executableElement.getTypeParameters().isEmpty() || (description = executableElement.getAnnotation(Description.class)) == null || description.value().isEmpty()) continue;
            String propName = StringUtil.propName((String)executableElement.getSimpleName().toString(), (executableElement.getReturnType().getKind() == TypeKind.BOOLEAN ? 1 : 0) != 0);
            if (propName == null) {
                propName = executableElement.getSimpleName().toString();
            }
            map.put(propName, description.value());
        }
        return map;
    }
}

