/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.virtualhost.derby;

import java.util.Collection;
import java.util.Map;
import org.apache.qpid.server.model.Connection;
import org.apache.qpid.server.model.Content;
import org.apache.qpid.server.model.ManageableMessage;
import org.apache.qpid.server.model.VirtualHostNode;
import org.apache.qpid.server.security.access.Operation;
import org.apache.qpid.server.util.FixedKeyMapCreator;
import org.apache.qpid.server.virtualhost.derby.DerbyVirtualHostImpl;

final class DerbyVirtualHostImplWithAccessChecking
extends DerbyVirtualHostImpl {
    private static final FixedKeyMapCreator GET_CONNECTION_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"name"});
    private static final FixedKeyMapCreator PUBLISH_MESSAGE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"message"});
    private static final FixedKeyMapCreator EXTRACT_CONFIG_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"includeSecureAttributes"});
    private static final FixedKeyMapCreator IMPORT_MESSAGE_STORE_MAP_CREATOR = new FixedKeyMapCreator(new String[]{"source"});

    DerbyVirtualHostImplWithAccessChecking(Map<String, Object> attributes, VirtualHostNode<?> virtualhostnode) {
        super(attributes, virtualhostnode);
    }

    public Collection<? extends Connection<?>> getConnections() {
        this.authorise(Operation.METHOD((String)"getConnections"));
        return super.getConnections();
    }

    public Connection<?> getConnection(String name) {
        this.authorise(Operation.METHOD((String)"getConnection"), GET_CONNECTION_MAP_CREATOR.createMap(new Object[]{name}));
        return super.getConnection(name);
    }

    public int publishMessage(ManageableMessage message) {
        this.authorise(Operation.METHOD((String)"publishMessage"), PUBLISH_MESSAGE_MAP_CREATOR.createMap(new Object[]{message}));
        return super.publishMessage(message);
    }

    public Map<String, Object> extractConfig(boolean includeSecureAttributes) {
        this.authorise(Operation.METHOD((String)"extractConfig"), EXTRACT_CONFIG_MAP_CREATOR.createMap(new Object[]{includeSecureAttributes}));
        return super.extractConfig(includeSecureAttributes);
    }

    public Content exportMessageStore() {
        this.authorise(Operation.METHOD((String)"exportMessageStore"));
        return super.exportMessageStore();
    }

    public void importMessageStore(String source) {
        this.authorise(Operation.METHOD((String)"importMessageStore"), IMPORT_MESSAGE_STORE_MAP_CREATOR.createMap(new Object[]{source}));
        super.importMessageStore(source);
    }

    @Override
    public void resetStatistics() {
        this.authorise(Operation.METHOD((String)"resetStatistics"));
        super.resetStatistics();
    }
}

