/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.transfer.dependencies.collect.internal;

import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.shared.transfer.dependencies.DependableCoordinate;
import org.apache.maven.shared.transfer.dependencies.collect.CollectorResult;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollector;
import org.apache.maven.shared.transfer.dependencies.collect.DependencyCollectorException;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.context.Context;
import org.codehaus.plexus.context.ContextException;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;

@Component(role=DependencyCollector.class, hint="default")
class DefaultDependencyCollector
implements DependencyCollector,
Contextualizable {
    private PlexusContainer container;

    DefaultDependencyCollector() {
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Dependency root) throws DependencyCollectorException {
        this.validateParameters(buildingRequest, root);
        try {
            String hint = DefaultDependencyCollector.isMaven31() ? "maven31" : "maven3";
            DependencyCollector effectiveDependencyCollector = (DependencyCollector)this.container.lookup(DependencyCollector.class, hint);
            return effectiveDependencyCollector.collectDependencies(buildingRequest, root);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, DependableCoordinate root) throws DependencyCollectorException {
        this.validateParameters(buildingRequest, root);
        try {
            String hint = DefaultDependencyCollector.isMaven31() ? "maven31" : "maven3";
            DependencyCollector effectiveDependencyCollector = (DependencyCollector)this.container.lookup(DependencyCollector.class, hint);
            return effectiveDependencyCollector.collectDependencies(buildingRequest, root);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    @Override
    public CollectorResult collectDependencies(ProjectBuildingRequest buildingRequest, Model root) throws DependencyCollectorException {
        this.validateParameters(buildingRequest, root);
        try {
            String hint = DefaultDependencyCollector.isMaven31() ? "maven31" : "maven3";
            DependencyCollector effectiveDependencyCollector = (DependencyCollector)this.container.lookup(DependencyCollector.class, hint);
            return effectiveDependencyCollector.collectDependencies(buildingRequest, root);
        }
        catch (ComponentLookupException e) {
            throw new DependencyCollectorException(e.getMessage(), e);
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, DependableCoordinate root) {
        this.validateBuildingRequest(buildingRequest);
        if (root == null) {
            throw new IllegalArgumentException("The parameter root is not allowed to be null.");
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Dependency root) {
        this.validateBuildingRequest(buildingRequest);
        if (root == null) {
            throw new IllegalArgumentException("The parameter root is not allowed to be null.");
        }
    }

    private void validateParameters(ProjectBuildingRequest buildingRequest, Model root) {
        this.validateBuildingRequest(buildingRequest);
        if (root == null) {
            throw new IllegalArgumentException("The parameter root is not allowed to be null.");
        }
    }

    private void validateBuildingRequest(ProjectBuildingRequest buildingRequest) {
        if (buildingRequest == null) {
            throw new IllegalArgumentException("The parameter buildingRequest is not allowed to be null.");
        }
    }

    protected static boolean isMaven31() {
        return DefaultDependencyCollector.canFindCoreClass("org.eclipse.aether.artifact.Artifact");
    }

    private static boolean canFindCoreClass(String className) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.container = (PlexusContainer)context.get((Object)"plexus");
    }
}

