/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals.graph;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.streams.kstream.internals.graph.BaseRepartitionNode;
import org.apache.kafka.streams.kstream.internals.graph.ProcessorParameters;
import org.apache.kafka.streams.processor.FailOnInvalidTimestamp;
import org.apache.kafka.streams.processor.StreamPartitioner;
import org.apache.kafka.streams.processor.TimestampExtractor;
import org.apache.kafka.streams.processor.internals.InternalTopologyBuilder;

public class OptimizableRepartitionNode<K, V>
extends BaseRepartitionNode<K, V> {
    OptimizableRepartitionNode(String nodeName, String sourceName, ProcessorParameters processorParameters, Serde<K> keySerde, Serde<V> valueSerde, String sinkName, String repartitionTopic, StreamPartitioner<K, V> partitioner) {
        super(nodeName, sourceName, processorParameters, keySerde, valueSerde, sinkName, repartitionTopic, partitioner);
    }

    public Serde<K> keySerde() {
        return this.keySerde;
    }

    public Serde<V> valueSerde() {
        return this.valueSerde;
    }

    public String repartitionTopic() {
        return this.repartitionTopic;
    }

    @Override
    Serializer<V> getValueSerializer() {
        return this.valueSerde != null ? this.valueSerde.serializer() : null;
    }

    @Override
    Deserializer<V> getValueDeserializer() {
        return this.valueSerde != null ? this.valueSerde.deserializer() : null;
    }

    @Override
    public String toString() {
        return "OptimizableRepartitionNode{ " + super.toString() + " }";
    }

    @Override
    public void writeToTopology(InternalTopologyBuilder topologyBuilder) {
        Serializer keySerializer = this.keySerde != null ? this.keySerde.serializer() : null;
        Deserializer keyDeserializer = this.keySerde != null ? this.keySerde.deserializer() : null;
        topologyBuilder.addInternalTopic(this.repartitionTopic);
        topologyBuilder.addProcessor(this.processorParameters.processorName(), this.processorParameters.processorSupplier(), this.parentNodeNames());
        topologyBuilder.addSink(this.sinkName, this.repartitionTopic, keySerializer, this.getValueSerializer(), this.partitioner, this.processorParameters.processorName());
        topologyBuilder.addSource(null, this.sourceName, (TimestampExtractor)new FailOnInvalidTimestamp(), keyDeserializer, this.getValueDeserializer(), this.repartitionTopic);
    }

    public static <K, V> OptimizableRepartitionNodeBuilder<K, V> optimizableRepartitionNodeBuilder() {
        return new OptimizableRepartitionNodeBuilder();
    }

    public static final class OptimizableRepartitionNodeBuilder<K, V> {
        private String nodeName;
        private ProcessorParameters processorParameters;
        private Serde<K> keySerde;
        private Serde<V> valueSerde;
        private String sinkName;
        private String sourceName;
        private String repartitionTopic;
        private StreamPartitioner<K, V> partitioner;

        private OptimizableRepartitionNodeBuilder() {
        }

        public OptimizableRepartitionNodeBuilder<K, V> withProcessorParameters(ProcessorParameters processorParameters) {
            this.processorParameters = processorParameters;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withKeySerde(Serde<K> keySerde) {
            this.keySerde = keySerde;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withValueSerde(Serde<V> valueSerde) {
            this.valueSerde = valueSerde;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withSinkName(String sinkName) {
            this.sinkName = sinkName;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withSourceName(String sourceName) {
            this.sourceName = sourceName;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withRepartitionTopic(String repartitionTopic) {
            this.repartitionTopic = repartitionTopic;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withNodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        public OptimizableRepartitionNodeBuilder<K, V> withPartitioner(StreamPartitioner<K, V> partitioner) {
            this.partitioner = partitioner;
            return this;
        }

        public OptimizableRepartitionNode<K, V> build() {
            return new OptimizableRepartitionNode<K, V>(this.nodeName, this.sourceName, this.processorParameters, this.keySerde, this.valueSerde, this.sinkName, this.repartitionTopic, this.partitioner);
        }
    }
}

