/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics;

import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.stats.TokenBucket;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TokenBucketTest {
    Time time;

    @Before
    public void setup() {
        this.time = new MockTime(0L, System.currentTimeMillis(), System.nanoTime());
    }

    @Test
    public void testRecord() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = new TokenBucket();
        Assert.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, 60.0, this.time.milliseconds());
        Assert.assertEquals((double)40.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, 5.0, this.time.milliseconds());
        Assert.assertEquals((double)45.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, 60.0, this.time.milliseconds());
        Assert.assertEquals((double)-5.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }

    @Test
    public void testUnrecord() {
        MetricConfig config = new MetricConfig().quota(Quota.upperBound((double)5.0)).timeWindow(2L, TimeUnit.SECONDS).samples(10);
        TokenBucket tk = new TokenBucket();
        Assert.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        tk.record(config, -60.0, this.time.milliseconds());
        Assert.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, 60.0, this.time.milliseconds());
        Assert.assertEquals((double)40.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
        this.time.sleep(2000L);
        tk.record(config, -60.0, this.time.milliseconds());
        Assert.assertEquals((double)100.0, (double)tk.measure(config, this.time.milliseconds()), (double)0.1);
    }
}

