/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.feature;

import java.util.Map;
import org.apache.kafka.common.feature.FinalizedVersionRange;
import org.apache.kafka.common.feature.SupportedVersionRange;
import org.apache.kafka.common.utils.Utils;
import org.junit.Assert;
import org.junit.Test;

public class FinalizedVersionRangeTest {
    @Test
    public void testFromToMap() {
        FinalizedVersionRange versionRange = new FinalizedVersionRange(1, 2);
        Assert.assertEquals((long)1L, (long)versionRange.min());
        Assert.assertEquals((long)2L, (long)versionRange.max());
        Map versionRangeMap = versionRange.toMap();
        Assert.assertEquals((Object)Utils.mkMap((Map.Entry[])new Map.Entry[]{Utils.mkEntry((Object)"min_version_level", (Object)versionRange.min()), Utils.mkEntry((Object)"max_version_level", (Object)versionRange.max())}), (Object)versionRangeMap);
        FinalizedVersionRange newVersionRange = FinalizedVersionRange.fromMap((Map)versionRangeMap);
        Assert.assertEquals((long)1L, (long)newVersionRange.min());
        Assert.assertEquals((long)2L, (long)newVersionRange.max());
        Assert.assertEquals((Object)versionRange, (Object)newVersionRange);
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)"FinalizedVersionRange[min_version_level:1, max_version_level:1]", (Object)new FinalizedVersionRange(1, 1).toString());
        Assert.assertEquals((Object)"FinalizedVersionRange[min_version_level:1, max_version_level:2]", (Object)new FinalizedVersionRange(1, 2).toString());
    }

    @Test
    public void testIsCompatibleWith() {
        Assert.assertFalse((boolean)new FinalizedVersionRange(1, 1).isIncompatibleWith(new SupportedVersionRange(1, 1)));
        Assert.assertFalse((boolean)new FinalizedVersionRange(2, 3).isIncompatibleWith(new SupportedVersionRange(1, 4)));
        Assert.assertFalse((boolean)new FinalizedVersionRange(1, 4).isIncompatibleWith(new SupportedVersionRange(1, 4)));
        Assert.assertTrue((boolean)new FinalizedVersionRange(1, 4).isIncompatibleWith(new SupportedVersionRange(2, 3)));
        Assert.assertTrue((boolean)new FinalizedVersionRange(1, 4).isIncompatibleWith(new SupportedVersionRange(2, 4)));
        Assert.assertTrue((boolean)new FinalizedVersionRange(2, 4).isIncompatibleWith(new SupportedVersionRange(2, 3)));
    }

    @Test
    public void testMinMax() {
        FinalizedVersionRange versionRange = new FinalizedVersionRange(1, 2);
        Assert.assertEquals((long)1L, (long)versionRange.min());
        Assert.assertEquals((long)2L, (long)versionRange.max());
    }
}

