/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.thread;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.tio.utils.thread.pool.DefaultThreadFactory;
import org.tio.utils.thread.pool.SynThreadPoolExecutor;
import org.tio.utils.thread.pool.TioCallerRunsPolicy;

public class ThreadUtils {
    public static final int AVAILABLE_PROCESSORS;
    public static final int CORE_POOL_SIZE;
    public static final int MAX_POOL_SIZE_FOR_TIO;
    public static final int MAX_POOL_SIZE_FOR_GROUP;
    public static final long KEEP_ALIVE_TIME = 0L;

    private ThreadUtils() {
    }

    public static ExecutorService getGroupExecutor() {
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        DefaultThreadFactory threadFactory = DefaultThreadFactory.getInstance("tio-group", 10);
        TioCallerRunsPolicy callerRunsPolicy = new TioCallerRunsPolicy();
        ThreadPoolExecutor groupExecutor = new ThreadPoolExecutor(MAX_POOL_SIZE_FOR_GROUP, MAX_POOL_SIZE_FOR_GROUP, 0L, TimeUnit.SECONDS, runnableQueue, threadFactory, callerRunsPolicy);
        groupExecutor.prestartCoreThread();
        return groupExecutor;
    }

    public static SynThreadPoolExecutor getTioExecutor() {
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance("tio-worker", 10);
        TioCallerRunsPolicy callerRunsPolicy = new TioCallerRunsPolicy();
        SynThreadPoolExecutor tioExecutor = new SynThreadPoolExecutor(MAX_POOL_SIZE_FOR_TIO, MAX_POOL_SIZE_FOR_TIO, 0L, runnableQueue, defaultThreadFactory, (RejectedExecutionHandler)callerRunsPolicy);
        tioExecutor.prestartCoreThread();
        return tioExecutor;
    }

    public static boolean sleep(long millis) {
        if (millis > 0L) {
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
        return true;
    }

    public static ExecutorService getGroupExecutor(int groupPoolSize) {
        DefaultThreadFactory threadFactory = DefaultThreadFactory.getInstance("tio-group", 10);
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        ThreadPoolExecutor groupExecutor = new ThreadPoolExecutor(groupPoolSize, groupPoolSize, 0L, TimeUnit.SECONDS, runnableQueue, threadFactory, new TioCallerRunsPolicy());
        groupExecutor.prestartCoreThread();
        return groupExecutor;
    }

    public static SynThreadPoolExecutor getTioExecutor(int tioPoolSize) {
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance("tio-worker", 10);
        SynThreadPoolExecutor tioExecutor = new SynThreadPoolExecutor(tioPoolSize, tioPoolSize, 0L, runnableQueue, defaultThreadFactory, (RejectedExecutionHandler)new TioCallerRunsPolicy());
        tioExecutor.prestartCoreThread();
        return tioExecutor;
    }

    public static ExecutorService getBizExecutor(int poolSize) {
        LinkedBlockingQueue<Runnable> runnableQueue = new LinkedBlockingQueue<Runnable>();
        DefaultThreadFactory defaultThreadFactory = DefaultThreadFactory.getInstance("biz-worker", 10);
        ThreadPoolExecutor tioExecutor = new ThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.SECONDS, runnableQueue, defaultThreadFactory, new TioCallerRunsPolicy());
        tioExecutor.prestartCoreThread();
        return tioExecutor;
    }

    public static String stackTrace() {
        StackTraceElement[] elements = Thread.currentThread().getStackTrace();
        StringBuilder buf = new StringBuilder();
        for (StackTraceElement element : elements) {
            buf.append("\r\n\t").append(element.getClassName()).append('.').append(element.getMethodName()).append('(').append(element.getFileName()).append(':').append(element.getLineNumber()).append(')');
        }
        return buf.toString();
    }

    static {
        CORE_POOL_SIZE = AVAILABLE_PROCESSORS = Runtime.getRuntime().availableProcessors();
        MAX_POOL_SIZE_FOR_TIO = Integer.getInteger("TIO_MAX_POOL_SIZE_FOR_TIO", Math.max(CORE_POOL_SIZE * 2, 8));
        MAX_POOL_SIZE_FOR_GROUP = Integer.getInteger("TIO_MAX_POOL_SIZE_FOR_GROUP", Math.max(CORE_POOL_SIZE * 4, 16));
    }
}

