/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.hutool;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public class FastByteBuffer {
    private final int minChunkLen;
    private byte[][] buffers = new byte[16][];
    private int buffersCount;
    private int currentBufferIndex = -1;
    private byte[] currentBuffer;
    private int offset;
    private int size;

    public FastByteBuffer() {
        this.minChunkLen = 1024;
    }

    public FastByteBuffer(int size) {
        this.minChunkLen = Math.abs(size);
    }

    private void needNewBuffer(int newSize) {
        int delta = newSize - this.size;
        int newBufferSize = Math.max(this.minChunkLen, delta);
        ++this.currentBufferIndex;
        this.currentBuffer = new byte[newBufferSize];
        this.offset = 0;
        if (this.currentBufferIndex >= this.buffers.length) {
            int newLen = this.buffers.length << 1;
            byte[][] newBuffers = new byte[newLen][];
            System.arraycopy(this.buffers, 0, newBuffers, 0, this.buffers.length);
            this.buffers = newBuffers;
        }
        this.buffers[this.currentBufferIndex] = this.currentBuffer;
        ++this.buffersCount;
    }

    public FastByteBuffer append(byte[] array, int off, int len) {
        int part;
        int end = off + len;
        if (off < 0 || len < 0 || end > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return this;
        }
        int newSize = this.size + len;
        int remaining = len;
        if (this.currentBuffer != null) {
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            remaining -= part;
            this.offset += part;
            this.size += part;
        }
        if (remaining > 0) {
            this.needNewBuffer(newSize);
            part = Math.min(remaining, this.currentBuffer.length - this.offset);
            System.arraycopy(array, end - remaining, this.currentBuffer, this.offset, part);
            this.offset += part;
            this.size += part;
        }
        return this;
    }

    public FastByteBuffer append(ByteBuffer buffer) {
        return this.append(buffer.array());
    }

    public FastByteBuffer append(byte[] array) {
        return this.append(array, 0, array.length);
    }

    public FastByteBuffer append(byte element) {
        if (this.currentBuffer == null || this.offset == this.currentBuffer.length) {
            this.needNewBuffer(this.size + 1);
        }
        this.currentBuffer[this.offset] = element;
        ++this.offset;
        ++this.size;
        return this;
    }

    public FastByteBuffer append(FastByteBuffer buff) {
        if (buff.size == 0) {
            return this;
        }
        for (int i = 0; i < buff.currentBufferIndex; ++i) {
            this.append(buff.buffers[i]);
        }
        this.append(buff.currentBuffer, 0, buff.offset);
        return this;
    }

    public FastByteBuffer writeBoolean(boolean value) {
        return this.writeByte(value ? 1 : 0);
    }

    public FastByteBuffer writeByte(int value) {
        return this.append((byte)value);
    }

    public FastByteBuffer writeShortBE(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 8), (byte)value};
        return this.append(bytes, 0, 2);
    }

    public FastByteBuffer writeShortLE(int value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8)};
        return this.append(bytes, 0, 2);
    }

    public FastByteBuffer writeMediumBE(int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return this.append(bytes, 0, 3);
    }

    public FastByteBuffer writeMediumLE(int value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16)};
        return this.append(bytes, 0, 3);
    }

    public FastByteBuffer writeIntBE(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return this.append(bytes, 0, 4);
    }

    public FastByteBuffer writeIntLE(long value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)};
        return this.append(bytes, 0, 4);
    }

    public FastByteBuffer writeLongBE(long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return this.append(bytes, 0, 8);
    }

    public FastByteBuffer writeLongLE(long value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56)};
        return this.append(bytes, 0, 8);
    }

    public FastByteBuffer writeFloatBE(float value) {
        return this.writeIntBE(Float.floatToRawIntBits(value));
    }

    public FastByteBuffer writeFloatLE(float value) {
        return this.writeIntLE(Float.floatToRawIntBits(value));
    }

    public FastByteBuffer writeDoubleBE(double value) {
        return this.writeLongBE(Double.doubleToRawLongBits(value));
    }

    public FastByteBuffer writeDoubleLE(double value) {
        return this.writeLongLE(Double.doubleToRawLongBits(value));
    }

    public FastByteBuffer writeBytes(byte[] bytes) {
        return this.append(bytes, 0, bytes.length);
    }

    public FastByteBuffer writeBytes(byte[] bytes, int off, int len) {
        return this.append(bytes, off, len);
    }

    public FastByteBuffer writeVarLengthInt(int num) {
        do {
            int digit = num % 128;
            if ((num /= 128) > 0) {
                digit |= 0x80;
            }
            this.append((byte)digit);
        } while (num > 0);
        return this;
    }

    public void writeString(String text) {
        this.writeString(text, StandardCharsets.UTF_8);
    }

    public void writeString(String text, String charset) {
        this.writeString(text, Charset.forName(charset));
    }

    public void writeString(String text, Charset charset) {
        this.append(Objects.requireNonNull(text).getBytes(charset));
    }

    public FastByteBuffer setByte(int index, int value) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        while (true) {
            byte[] b;
            if (index < (b = this.buffers[ndx]).length) {
                b[index] = (byte)value;
                return this;
            }
            ++ndx;
            index -= b.length;
        }
    }

    public FastByteBuffer setBoolean(int index, boolean value) {
        return this.setByte(index, value ? 1 : 0);
    }

    public FastByteBuffer setShortBE(int index, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 8), (byte)value};
        return this.setBytes(index, bytes, 0, 2);
    }

    public FastByteBuffer setShortLE(int index, int value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8)};
        return this.setBytes(index, bytes, 0, 2);
    }

    public FastByteBuffer setMediumBE(int index, int value) {
        byte[] bytes = new byte[]{(byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return this.setBytes(index, bytes, 0, 3);
    }

    public FastByteBuffer setMediumLE(int index, int value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16)};
        return this.setBytes(index, bytes, 0, 3);
    }

    public FastByteBuffer setIntBE(int index, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return this.setBytes(index, bytes, 0, 4);
    }

    public FastByteBuffer setIntLE(int index, long value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24)};
        return this.setBytes(index, bytes, 0, 4);
    }

    public FastByteBuffer setLongBE(int index, long value) {
        byte[] bytes = new byte[]{(byte)(value >>> 56), (byte)(value >>> 48), (byte)(value >>> 40), (byte)(value >>> 32), (byte)(value >>> 24), (byte)(value >>> 16), (byte)(value >>> 8), (byte)value};
        return this.setBytes(index, bytes, 0, 8);
    }

    public FastByteBuffer setLongLE(int index, long value) {
        byte[] bytes = new byte[]{(byte)value, (byte)(value >>> 8), (byte)(value >>> 16), (byte)(value >>> 24), (byte)(value >>> 32), (byte)(value >>> 40), (byte)(value >>> 48), (byte)(value >>> 56)};
        return this.setBytes(index, bytes, 0, 8);
    }

    public FastByteBuffer setFloatBE(int index, float value) {
        return this.setIntBE(index, Float.floatToRawIntBits(value));
    }

    public FastByteBuffer setFloatLE(int index, float value) {
        return this.setIntLE(index, Float.floatToRawIntBits(value));
    }

    public FastByteBuffer setDoubleBE(int index, double value) {
        return this.setLongBE(index, Double.doubleToRawLongBits(value));
    }

    public FastByteBuffer setDoubleLE(int index, double value) {
        return this.setLongLE(index, Double.doubleToRawLongBits(value));
    }

    public FastByteBuffer setBytes(int index, byte[] src) {
        return this.setBytes(index, src, 0, src.length);
    }

    public FastByteBuffer setBytes(int index, byte[] src, int srcIndex, int length) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        while (true) {
            byte[] buffer = this.buffers[ndx];
            int bufferLength = buffer.length;
            if ((index = Math.max(index, 0)) < bufferLength) {
                if (index + length < bufferLength) {
                    System.arraycopy(src, srcIndex, buffer, index, length);
                    return this;
                }
                System.arraycopy(src, srcIndex, buffer, index, bufferLength - index);
                length = index + length - bufferLength;
            }
            ++ndx;
            index -= bufferLength;
        }
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int index() {
        return this.currentBufferIndex;
    }

    public int offset() {
        return this.offset;
    }

    public byte[] array(int index) {
        return this.buffers[index];
    }

    public FastByteBuffer reset() {
        this.size = 0;
        this.offset = 0;
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
        this.buffersCount = 0;
        return this;
    }

    public byte[] toArray() {
        int pos = 0;
        byte[] array = new byte[this.size];
        if (this.currentBufferIndex == -1) {
            return array;
        }
        for (int i = 0; i < this.currentBufferIndex; ++i) {
            int len = this.buffers[i].length;
            System.arraycopy(this.buffers[i], 0, array, pos, len);
            pos += len;
        }
        System.arraycopy(this.buffers[this.currentBufferIndex], 0, array, pos, this.offset);
        return array;
    }

    public byte[] toArray(int start, int len) {
        int remaining = len;
        int pos = 0;
        byte[] array = new byte[len];
        if (len == 0) {
            return array;
        }
        int i = 0;
        while (start >= this.buffers[i].length) {
            start -= this.buffers[i].length;
            ++i;
        }
        while (i < this.buffersCount) {
            byte[] buf = this.buffers[i];
            int c = Math.min(buf.length - start, remaining);
            System.arraycopy(buf, start, array, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
            start = 0;
            ++i;
        }
        return array;
    }

    public ByteBuffer toBuffer() {
        return ByteBuffer.wrap(this.toArray());
    }

    public byte get(int index) {
        if (index >= this.size || index < 0) {
            throw new IndexOutOfBoundsException();
        }
        int ndx = 0;
        byte[] b;
        while (index >= (b = this.buffers[ndx]).length) {
            ++ndx;
            index -= b.length;
        }
        return b[index];
    }
}

