/*
 * Decompiled with CFR 0.152.
 */
package org.tio.utils.cache;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.LongAdder;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;
import org.tio.utils.cache.Cache;
import org.tio.utils.cache.CacheListener;
import org.tio.utils.cache.CacheObj;
import org.tio.utils.hutool.CollUtil;
import org.tio.utils.mica.ExceptionUtils;

public abstract class AbstractCache<K extends Serializable, V extends Serializable>
implements Cache<K, V> {
    private static final long serialVersionUID = 1L;
    private final Map<K, CacheObj<K, V>> cacheMap;
    private final int capacity;
    private final long timeout;
    protected final ConcurrentHashMap<K, Lock> keyLockMap = new ConcurrentHashMap();
    protected boolean existCustomTimeout;
    protected LongAdder hitCount = new LongAdder();
    protected LongAdder missCount = new LongAdder();
    protected transient CacheListener<K, V> listener;

    AbstractCache(Map<K, CacheObj<K, V>> cacheMap, int capacity, long timeout) {
        this.cacheMap = cacheMap;
        this.capacity = capacity;
        this.timeout = timeout;
    }

    @Override
    public void put(K key, V object) {
        this.put(key, object, this.timeout);
    }

    protected void putWithoutLock(K key, V object, long timeout) {
        CacheObj<K, V> co = new CacheObj<K, V>(key, object, timeout);
        if (timeout != 0L) {
            this.existCustomTimeout = true;
        }
        if (this.isFull()) {
            this.pruneCache();
        }
        this.cacheMap.put(key, co);
    }

    public long getHitCount() {
        return this.hitCount.sum();
    }

    public long getMissCount() {
        return this.missCount.sum();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(K key, boolean isUpdateLastAccess, Supplier<V> supplier) {
        Object v;
        block7: {
            v = this.get(key, isUpdateLastAccess);
            if (null == v && null != supplier) {
                Lock keyLock = CollUtil.computeIfAbsent(this.keyLockMap, key, k -> new ReentrantLock());
                keyLock.lock();
                try {
                    CacheObj<K, V> co = this.getWithoutLock(key);
                    if (null == co || co.isExpired()) {
                        try {
                            v = (Serializable)supplier.get();
                        }
                        catch (Exception e) {
                            throw ExceptionUtils.unchecked(e);
                        }
                        this.put(key, v, this.timeout);
                        break block7;
                    }
                    v = co.get(isUpdateLastAccess);
                }
                finally {
                    keyLock.unlock();
                    this.keyLockMap.remove(key);
                }
            }
        }
        return v;
    }

    protected CacheObj<K, V> getWithoutLock(K key) {
        return this.cacheMap.get(key);
    }

    protected abstract int pruneCache();

    @Override
    public int capacity() {
        return this.capacity;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    protected boolean isPruneExpiredActive() {
        return this.timeout != 0L || this.existCustomTimeout;
    }

    @Override
    public boolean isFull() {
        return this.capacity > 0 && this.cacheMap.size() >= this.capacity;
    }

    @Override
    public void clear() {
        this.cacheMap.clear();
    }

    @Override
    public int size() {
        return this.cacheMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.cacheMap.isEmpty();
    }

    public String toString() {
        return this.cacheMap.toString();
    }

    @Override
    public AbstractCache<K, V> setListener(CacheListener<K, V> listener) {
        this.listener = listener;
        return this;
    }

    public Set<K> keySet() {
        return new HashSet<K>(this.cacheMap.keySet());
    }

    protected void onRemove(K key, V cachedObject) {
        if (null != this.listener) {
            this.listener.onRemove(key, cachedObject);
        }
    }

    protected CacheObj<K, V> removeWithoutLock(K key, boolean withMissCount) {
        CacheObj<K, V> co = this.cacheMap.remove(key);
        if (withMissCount) {
            this.missCount.increment();
        }
        return co;
    }

    protected Iterator<CacheObj<K, V>> cacheObjIter() {
        return this.cacheMap.values().iterator();
    }
}

