/*
 * Decompiled with CFR 0.152.
 */
package com.zaxxer.hikari.metrics.micrometer;

import com.zaxxer.hikari.metrics.IMetricsTracker;
import com.zaxxer.hikari.metrics.PoolStats;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.stats.hist.CumulativeBucketFunction;
import io.micrometer.core.instrument.stats.hist.CumulativeHistogram;
import io.micrometer.core.instrument.stats.hist.Histogram;
import io.micrometer.core.instrument.stats.quantile.Quantiles;
import io.micrometer.core.instrument.stats.quantile.WindowSketchQuantiles;
import java.util.concurrent.TimeUnit;

public class MicrometerMetricsTracker
implements IMetricsTracker {
    private static final String METRIC_CATEGORY = "pool";
    private static final String METRIC_NAME_WAIT = "Wait";
    private static final String METRIC_NAME_USAGE = "Usage";
    private static final String METRIC_NAME_CONNECT = "ConnectionCreation";
    private static final String METRIC_NAME_TIMEOUT_RATE = "ConnectionTimeoutRate";
    private static final String METRIC_NAME_TOTAL_CONNECTIONS = "TotalConnections";
    private static final String METRIC_NAME_IDLE_CONNECTIONS = "IdleConnections";
    private static final String METRIC_NAME_ACTIVE_CONNECTIONS = "ActiveConnections";
    private static final String METRIC_NAME_PENDING_CONNECTIONS = "PendingConnections";
    private final Timer connectionObtainTimer;
    private final DistributionSummary connectionTimeoutMeter;
    private final DistributionSummary connectionUsage;
    private final DistributionSummary connectionCreation;
    private final Gauge totalConnectionGauge;
    private final Gauge idleConnectionGauge;
    private final Gauge activeConnectionGauge;
    private final Gauge pendingConnectionGauge;

    MicrometerMetricsTracker(String poolName, PoolStats poolStats, MeterRegistry meterRegistry) {
        this.connectionObtainTimer = meterRegistry.timerBuilder(METRIC_NAME_WAIT).tags(new String[]{METRIC_CATEGORY, poolName}).create();
        this.connectionCreation = meterRegistry.summaryBuilder(METRIC_NAME_CONNECT).tags(new String[]{METRIC_CATEGORY, poolName}).quantiles((Quantiles)WindowSketchQuantiles.quantiles((double[])new double[]{0.5, 0.95}).create()).histogram((Histogram)CumulativeHistogram.buckets((CumulativeBucketFunction)CumulativeHistogram.linear((double)0.0, (double)10.0, (int)20), (TimeUnit)TimeUnit.MILLISECONDS)).create();
        this.connectionUsage = meterRegistry.summaryBuilder(METRIC_NAME_USAGE).tags(new String[]{METRIC_CATEGORY, poolName}).quantiles((Quantiles)WindowSketchQuantiles.quantiles((double[])new double[]{0.5, 0.95}).create()).histogram((Histogram)CumulativeHistogram.buckets((CumulativeBucketFunction)CumulativeHistogram.linear((double)0.0, (double)10.0, (int)20), (TimeUnit)TimeUnit.MILLISECONDS)).create();
        this.connectionTimeoutMeter = meterRegistry.summaryBuilder(METRIC_NAME_TIMEOUT_RATE).tags(new String[]{METRIC_CATEGORY, poolName}).quantiles((Quantiles)WindowSketchQuantiles.quantiles((double[])new double[]{0.5, 0.95}).create()).histogram((Histogram)CumulativeHistogram.buckets((CumulativeBucketFunction)CumulativeHistogram.linear((double)0.0, (double)10.0, (int)20), (TimeUnit)TimeUnit.MILLISECONDS)).create();
        this.totalConnectionGauge = meterRegistry.gaugeBuilder(METRIC_NAME_TOTAL_CONNECTIONS, Integer.class, i -> poolStats.getTotalConnections()).tags(new String[]{METRIC_CATEGORY, poolName}).create();
        this.idleConnectionGauge = meterRegistry.gaugeBuilder(METRIC_NAME_IDLE_CONNECTIONS, Integer.class, i -> poolStats.getIdleConnections()).tags(new String[]{METRIC_CATEGORY, poolName}).create();
        this.activeConnectionGauge = meterRegistry.gaugeBuilder(METRIC_NAME_ACTIVE_CONNECTIONS, Integer.class, i -> poolStats.getActiveConnections()).tags(new String[]{METRIC_CATEGORY, poolName}).create();
        this.pendingConnectionGauge = meterRegistry.gaugeBuilder(METRIC_NAME_PENDING_CONNECTIONS, Integer.class, i -> poolStats.getPendingThreads()).tags(new String[]{METRIC_CATEGORY, poolName}).create();
    }

    @Override
    public void recordConnectionAcquiredNanos(long elapsedAcquiredNanos) {
        this.connectionObtainTimer.record(elapsedAcquiredNanos, TimeUnit.NANOSECONDS);
    }

    @Override
    public void recordConnectionUsageMillis(long elapsedBorrowedMillis) {
        this.connectionUsage.record((double)elapsedBorrowedMillis);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutMeter.count();
    }

    @Override
    public void recordConnectionCreatedMillis(long connectionCreatedMillis) {
        this.connectionCreation.record((double)connectionCreatedMillis);
    }
}

