/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.parser;

import com.github.liaochong.myexcel.core.PromptContainer;
import com.github.liaochong.myexcel.core.parser.Comment;
import com.github.liaochong.myexcel.core.parser.ContentTypeEnum;
import com.github.liaochong.myexcel.core.parser.DropdownList;
import com.github.liaochong.myexcel.core.parser.Font;
import com.github.liaochong.myexcel.core.parser.Image;
import com.github.liaochong.myexcel.core.parser.LineStyleEnum;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Slant;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Td;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.utils.ImageUtil;
import com.github.liaochong.myexcel.utils.RegexpUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import com.github.liaochong.myexcel.utils.StyleUtil;
import com.github.liaochong.myexcel.utils.TdUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.poi.xssf.usermodel.XSSFRichTextString;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTableParser {
    private static final Pattern DOUBLE_PATTERN = Pattern.compile("^[-+]?(\\d+(\\.\\d*)?|\\.\\d+)([eE]([-+]?([012]?\\d{1,2}|30[0-7])|-3([01]?[4-9]|[012]?[0-3])))?[dD]?$");
    private static final Pattern LINE_FEED_PATTERN = Pattern.compile("\\\\n");
    private static final Logger log = LoggerFactory.getLogger(HtmlTableParser.class);
    private ParseConfig parseConfig;
    private File htmlFile;
    private String html;
    private final Map<String, String> defaultLinkStyle = new HashMap<String, String>();
    private XSSFRichTextString spanText;

    private HtmlTableParser() {
        this.defaultLinkStyle.put("color", "blue");
        this.defaultLinkStyle.put("text-decoration", "underline");
    }

    public static HtmlTableParser of(File htmlFile) {
        Objects.requireNonNull(htmlFile);
        HtmlTableParser htmlTableParser = new HtmlTableParser();
        htmlTableParser.htmlFile = htmlFile;
        return htmlTableParser;
    }

    public static HtmlTableParser of(String html) {
        Objects.requireNonNull(html);
        HtmlTableParser htmlTableParser = new HtmlTableParser();
        htmlTableParser.html = html;
        return htmlTableParser;
    }

    public List<Table> getAllTable(ParseConfig parseConfig) throws IOException {
        log.info("Start parsing html file");
        long startTime = System.currentTimeMillis();
        Document document = this.htmlFile != null ? Jsoup.parse((File)this.htmlFile, (String)"UTF-8") : Jsoup.parse((String)this.html, (String)"UTF-8");
        document.outputSettings(new Document.OutputSettings().prettyPrint(false));
        document.select("br").after("\\n");
        document.select("p").before("\\n");
        this.parseConfig = parseConfig;
        Elements tableElements = document.getElementsByTag(HtmlTag.table.name());
        List<Table> result = tableElements.stream().map(tableElement -> {
            Table table = new Table();
            Elements captionElements = tableElement.getElementsByTag(HtmlTag.caption.name());
            if (!captionElements.isEmpty()) {
                table.caption = captionElements.first().text();
            }
            this.parseTrOfTable(table, (Element)tableElement, StyleUtil.parseStyle(tableElement));
            return table;
        }).collect(Collectors.toList());
        log.info("Complete html file parsing,takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }

    private void parseTrOfTable(Table table, Element tableElement, Map<String, String> tableStyle) {
        List trList;
        ConcurrentHashMap parentStyleMap = new ConcurrentHashMap();
        Elements trElements = tableElement.getElementsByTag(HtmlTag.tr.name());
        HashMap seizeMap = new HashMap();
        table.trList = trList = (List)IntStream.range(0, trElements.size()).mapToObj(index -> {
            Map<String, String> upperStyle;
            Element trElement = (Element)trElements.get(index);
            Element parent = trElement.parent();
            if (Objects.equals(parent, tableElement)) {
                upperStyle = tableStyle;
            } else if (parentStyleMap.containsKey(parent)) {
                upperStyle = (Map)parentStyleMap.get(parent);
            } else {
                upperStyle = StyleUtil.mixStyle(tableStyle, StyleUtil.parseStyle(parent));
                parentStyleMap.putIfAbsent(parent, upperStyle);
            }
            Map<String, String> trStyleMap = StyleUtil.mixStyle(upperStyle, StyleUtil.parseStyle(trElement));
            String height = trStyleMap.get("height");
            Tr tr = new Tr(index, TdUtil.getValue(height), true);
            tr.visibility = !Objects.equals(trStyleMap.get("visibility"), "hidden");
            this.parseTdOfTr(tr, trElement, trStyleMap, seizeMap);
            return tr;
        }).collect(Collectors.toCollection(LinkedList::new));
    }

    private void parseTdOfTr(Tr tr, Element trElement, Map<String, String> trStyle, Map<Integer, List<Integer>> seizeMap) {
        Elements tdElements = trElement.children();
        if (tdElements.isEmpty()) {
            tr.tdList = Collections.emptyList();
            tr.colWidthMap = Collections.emptyMap();
            return;
        }
        LinkedList<Td> tdList = new LinkedList<Td>();
        HashMap<Integer, Integer> colWidthMap = new HashMap<Integer, Integer>(tdElements.size());
        List seizeOfTr = seizeMap.getOrDefault(tr.index, Collections.emptyList());
        int shift = 0;
        int size = tdElements.size();
        for (int i = 0; i < size; ++i) {
            Element tdElement = (Element)tdElements.get(i);
            Td td = new Td(tr.index, i + shift);
            this.setTdContent(tdElement, td);
            td.th = Objects.equals(HtmlTag.th.name(), tdElement.tagName());
            Map<String, String> tdStyle = StyleUtil.parseStyle(tdElement);
            if (tdStyle.isEmpty() && ContentTypeEnum.isLink(td.tdContentType)) {
                tdStyle = this.defaultLinkStyle;
            }
            td.style = StyleUtil.mixStyle(trStyle, tdStyle);
            String colSpan = tdElement.attr(HtmlTag.colspan.name());
            td.setColSpan(TdUtil.getSpan(colSpan));
            String rowSpan = tdElement.attr(HtmlTag.rowspan.name());
            td.setRowSpan(TdUtil.getSpan(rowSpan));
            if (!seizeOfTr.isEmpty()) {
                ArrayList checkedPositions = new ArrayList();
                while (true) {
                    List seizePositions = seizeOfTr.stream().filter(s -> td.col >= s).collect(Collectors.toList());
                    if (!checkedPositions.isEmpty()) {
                        seizePositions.removeAll(checkedPositions);
                    }
                    if (seizePositions.isEmpty()) break;
                    td.col += seizePositions.size();
                    checkedPositions.addAll(seizePositions);
                }
            }
            if (td.rowSpan > 1) {
                int length = td.rowSpan;
                for (int j = 1; j < length; ++j) {
                    int rowNum = tr.index + j;
                    List<Integer> seizePosOfTr = seizeMap.get(rowNum);
                    if (Objects.isNull(seizePosOfTr)) {
                        seizePosOfTr = new ArrayList<Integer>();
                        seizeMap.put(rowNum, seizePosOfTr);
                    }
                    IntStream.rangeClosed(td.col, td.getColBound()).forEach(seizePosOfTr::add);
                }
            }
            if (td.colSpan > 0) {
                shift += td.colSpan - 1;
            }
            tdList.add(td);
            this.setSlant(tdElement, td);
            this.setColumnWidth(colWidthMap, td);
            this.setComment(tdElement, td);
            this.setPrompt(tdElement, td);
        }
        tr.tdList = tdList;
        tr.colWidthMap = colWidthMap;
    }

    private void setPrompt(Element tdElement, Td td) {
        String title = tdElement.attr("prompt-title");
        String text = tdElement.attr("prompt-text");
        if (StringUtil.isBlank(title) || StringUtil.isBlank(text)) {
            return;
        }
        PromptContainer promptContainer = new PromptContainer();
        promptContainer.title = title;
        promptContainer.text = text;
        td.promptContainer = promptContainer;
    }

    private void setComment(Element tdElement, Td td) {
        String commentText = tdElement.attr("comment-text");
        String author = tdElement.attr("comment-author");
        if (StringUtil.isBlank(commentText) && StringUtil.isBlank(author)) {
            return;
        }
        Comment comment = new Comment();
        comment.text = commentText;
        comment.author = author;
        td.comment = comment;
    }

    private void setSlant(Element tdElement, Td td) {
        boolean hasSlant = tdElement.hasAttr("slant");
        if (hasSlant) {
            String slantStr = tdElement.attr("slant");
            if (StringUtil.isNotBlank(slantStr)) {
                String[] splits = slantStr.split(" ");
                if (splits.length != 3) {
                    throw new IllegalArgumentException("Slash setting error");
                }
                td.slant = new Slant(LineStyleEnum.getByName(splits[0]), splits[1], splits[2]);
            } else {
                td.slant = new Slant();
            }
        }
    }

    private void setColumnWidth(Map<Integer, Integer> colWidthMap, Td td) {
        int width;
        String widthStr;
        if (this.parseConfig.isComputeAutoWidth()) {
            int width2 = TdUtil.getStringWidth(td.content);
            if (td.colSpan > 1) {
                int realWidth = (int)Math.ceil((double)width2 * 1.0 / (double)td.colSpan);
                int span = td.colSpan;
                for (int j = 0; j < span; ++j) {
                    int colIndex = td.col + j;
                    Integer colWidth = colWidthMap.get(colIndex);
                    if (colWidth != null && colWidth >= realWidth) continue;
                    colWidthMap.put(colIndex, realWidth);
                }
            } else {
                colWidthMap.put(td.col, width2);
            }
        }
        if ((widthStr = td.style.get("width")) != null && (width = TdUtil.getValue(widthStr)) >= 0) {
            colWidthMap.put(td.col, width);
        }
    }

    private void setTdContent(Element tdElement, Td td) {
        Elements imgs = tdElement.getElementsByTag(HtmlTag.img.name());
        if (!imgs.isEmpty()) {
            Map<String, String> imgStyle;
            String src = ((Element)imgs.get(0)).attr("src");
            if (src.startsWith("http")) {
                td.fileIs = ImageUtil.getImageFromNetByUrl(src);
            } else if (src.startsWith("data")) {
                td.fileIs = ImageUtil.generateImageFromBase64(src);
            } else {
                td.file = new File(src);
            }
            Image image = new Image();
            String scale = ((Element)imgs.get(0)).attr("scale");
            if (StringUtil.isNotBlank(scale)) {
                String[] scales = scale.trim().split(",");
                if (scales.length != 2) {
                    throw new IllegalArgumentException("Scale parameter error, must be two double type parameters separated by commas.");
                }
                image.setScaleX(Double.parseDouble(scales[0]));
                image.setScaleY(Double.parseDouble(scales[1]));
            }
            if (!(imgStyle = StyleUtil.parseStyle((Element)imgs.get(0))).isEmpty()) {
                String height;
                String width;
                String marginLeft;
                String marginTop = imgStyle.get("margin-top");
                if (StringUtil.isNotBlank(marginTop)) {
                    image.setMarginTop(TdUtil.getValue(marginTop));
                }
                if (StringUtil.isNotBlank(marginLeft = imgStyle.get("margin-left"))) {
                    image.setMarginLeft(TdUtil.getValue(marginLeft));
                }
                if (StringUtil.isNotBlank(width = imgStyle.get("width"))) {
                    image.setWidth(TdUtil.getValue(width));
                }
                if (StringUtil.isNotBlank(height = imgStyle.get("height"))) {
                    image.setHeight(TdUtil.getValue(height));
                }
            }
            td.setImage(image);
            td.tdContentType = ContentTypeEnum.IMAGE;
            return;
        }
        Elements links = tdElement.getElementsByTag(HtmlTag.a.name());
        if (!links.isEmpty()) {
            String href;
            Element a = (Element)links.get(0);
            td.content = a.text();
            td.link = href = a.attr("href").trim();
            td.tdContentType = href.startsWith("mailto:") ? ContentTypeEnum.LINK_EMAIL : ContentTypeEnum.LINK_URL;
            return;
        }
        if (tdElement.hasAttr("blank")) {
            td.content = null;
            return;
        }
        String content = this.parseContent(tdElement, td);
        if (tdElement.hasAttr("string")) {
            td.content = content;
            return;
        }
        if (StringUtil.isBlank(content)) {
            return;
        }
        td.content = content;
        if (tdElement.hasAttr("double")) {
            td.tdContentType = ContentTypeEnum.DOUBLE;
            td.content = RegexpUtil.removeComma(td.content);
            return;
        }
        boolean isFormula = tdElement.hasAttr("formula");
        if (isFormula) {
            td.formula = true;
            String formula = td.content.trim();
            if (formula.startsWith("=")) {
                formula = formula.substring(1);
            }
            td.content = formula;
            return;
        }
        if (tdElement.hasAttr("url")) {
            String link = tdElement.attr("url");
            td.tdContentType = ContentTypeEnum.LINK_URL;
            td.link = link;
            return;
        }
        if (tdElement.hasAttr("email")) {
            String link = tdElement.attr("email");
            td.tdContentType = ContentTypeEnum.LINK_EMAIL;
            td.link = link;
            return;
        }
        if (tdElement.hasAttr("dropdownlist") || tdElement.hasAttr("dropDownList")) {
            String dropdownListParent;
            td.tdContentType = ContentTypeEnum.DROP_DOWN_LIST;
            String dropdownListName = tdElement.attr("dropdownlist-name");
            if (StringUtil.isNotBlank(dropdownListName)) {
                DropdownList dropdownList = new DropdownList();
                dropdownList.setName(dropdownListName);
                td.dropdownList = dropdownList;
            }
            if (StringUtil.isNotBlank(dropdownListParent = tdElement.attr("dropdownlist-parent"))) {
                if (td.dropdownList == null) {
                    td.dropdownList = new DropdownList();
                }
                td.dropdownList.setParent(dropdownListParent);
            }
            return;
        }
        if ("true".equals(content) || "false".equals(content)) {
            td.tdContentType = ContentTypeEnum.BOOLEAN;
            return;
        }
        if (DOUBLE_PATTERN.matcher(content).matches()) {
            td.tdContentType = ContentTypeEnum.DOUBLE;
        }
    }

    private String parseContent(Element tdElement, Td td) {
        Elements spans = tdElement.getElementsByTag(HtmlTag.span.name());
        if (!spans.isEmpty()) {
            td.fonts = new LinkedList<Font>();
            if (this.spanText == null) {
                this.spanText = new XSSFRichTextString("");
            }
            int startIndex = 0;
            for (Element spanElement : spans) {
                String spanContent = spanElement.text();
                spanContent = LINE_FEED_PATTERN.matcher(spanContent).replaceAll("\n");
                this.spanText.setString(spanContent);
                Font font = new Font();
                font.startIndex = startIndex;
                font.endIndex = startIndex + this.spanText.length();
                Map<String, String> fontStyle = StyleUtil.parseStyle(spanElement);
                if (!fontStyle.isEmpty()) {
                    font.style = fontStyle;
                    td.fonts.add(font);
                }
                startIndex = font.endIndex;
            }
        }
        return LINE_FEED_PATTERN.matcher(tdElement.text()).replaceAll("\n");
    }

    public static enum HtmlTag {
        table,
        caption,
        thead,
        tbody,
        tr,
        th,
        td,
        colspan,
        rowspan,
        link,
        img,
        a,
        span;

    }
}

