/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core.converter.writer;

import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.cache.WeakCache;
import com.github.liaochong.myexcel.core.constant.Constants;
import com.github.liaochong.myexcel.core.container.Pair;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.CustomWriteContext;
import com.github.liaochong.myexcel.core.converter.DefaultCustomWriteConverter;
import com.github.liaochong.myexcel.core.converter.WriteConverter;
import java.lang.reflect.Field;

public class CustomWriteConverter
implements WriteConverter {
    private final WeakCache<Class, com.github.liaochong.myexcel.core.converter.CustomWriteConverter> cache = new WeakCache();

    @Override
    public boolean support(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        ExcelColumnMapping mapping = convertContext.excelColumnMappingMap.get(field);
        return mapping != null && mapping.customWriteConverter != null && mapping.customWriteConverter != DefaultCustomWriteConverter.class;
    }

    @Override
    public Pair<Class, Object> convert(Field field, Class<?> fieldType, Object fieldVal, ConvertContext convertContext) {
        Object result;
        ExcelColumnMapping excelColumnMapping = convertContext.excelColumnMappingMap.get(field);
        Class<? extends com.github.liaochong.myexcel.core.converter.CustomWriteConverter> converter = excelColumnMapping.customWriteConverter;
        CustomWriteContext customWriteContext = new CustomWriteContext();
        customWriteContext.setField(field);
        Object target = convertContext.configuration.applicationBeans.get(converter);
        if (target != null) {
            Object result2 = ((com.github.liaochong.myexcel.core.converter.CustomWriteConverter)target).convert(fieldVal, customWriteContext);
            return result2 == null ? Constants.NULL_PAIR : Pair.of(result2.getClass(), result2);
        }
        if (this.cache.get(converter) == null) {
            com.github.liaochong.myexcel.core.converter.CustomWriteConverter customWriteConverter;
            try {
                customWriteConverter = converter.newInstance();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.cache.cache(converter, customWriteConverter);
        }
        return (result = this.cache.get(converter).convert(fieldVal, customWriteContext)) == null ? Constants.NULL_PAIR : Pair.of(result.getClass(), result);
    }
}

