/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.jdbc.internal.ClickHouseLexer;
import com.clickhouse.jdbc.internal.ClickHouseParser;
import com.clickhouse.jdbc.internal.ParsedPreparedStatement;
import com.clickhouse.jdbc.internal.ParsedStatement;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.IterativeParseTreeWalker;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;

public class SqlParser {
    private static final Pattern UNQUOTE_INDENTIFIER = Pattern.compile("^[\\\"`]?(.+?)[\\\"`]?$");

    public ParsedStatement parsedStatement(String sql) {
        CodePointCharStream charStream = CharStreams.fromString((String)sql);
        ClickHouseLexer lexer = new ClickHouseLexer((CharStream)charStream);
        ClickHouseParser parser = new ClickHouseParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ClickHouseParser.QueryStmtContext parseTree = parser.queryStmt();
        ParsedStatement parserListener = new ParsedStatement();
        IterativeParseTreeWalker.DEFAULT.walk((ParseTreeListener)parserListener, (ParseTree)parseTree);
        return parserListener;
    }

    public ParsedPreparedStatement parsePreparedStatement(String sql) {
        CodePointCharStream charStream = CharStreams.fromString((String)sql);
        ClickHouseLexer lexer = new ClickHouseLexer((CharStream)charStream);
        ClickHouseParser parser = new ClickHouseParser((TokenStream)new CommonTokenStream((TokenSource)lexer));
        ClickHouseParser.QueryStmtContext parseTree = parser.queryStmt();
        ParsedPreparedStatement parserListener = new ParsedPreparedStatement();
        IterativeParseTreeWalker.DEFAULT.walk((ParseTreeListener)parserListener, (ParseTree)parseTree);
        return parserListener;
    }

    public static String unquoteIdentifier(String str) {
        Matcher matcher = UNQUOTE_INDENTIFIER.matcher(str.trim());
        if (matcher.find()) {
            return matcher.group(1);
        }
        return str;
    }

    public static String escapeQuotes(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.replace("'", "\\'").replace("\"", "\\\"");
    }
}

