/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import javafx.application.Platform;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.MultipleSelectionModel;

public final class Util {
    public static boolean intersect(LocalDate aStart, LocalDate aEnd, LocalDate bStart, LocalDate bEnd) {
        if (aStart.equals(bStart) || aEnd.equals(bEnd)) {
            return true;
        }
        return aStart.isBefore(bEnd) && aEnd.isAfter(bStart);
    }

    public static boolean intersect(LocalTime aStart, LocalTime aEnd, LocalTime bStart, LocalTime bEnd) {
        if (aStart.equals(bStart) || aEnd.equals(bEnd)) {
            return true;
        }
        return aStart.isBefore(bEnd) && aEnd.isAfter(bStart);
    }

    public static boolean intersect(ZonedDateTime aStart, ZonedDateTime aEnd, ZonedDateTime bStart, ZonedDateTime bEnd) {
        if (aStart.equals(bStart) || aEnd.equals(bEnd)) {
            return true;
        }
        return aStart.isBefore(bEnd) && aEnd.isAfter(bStart);
    }

    public static LocalDateTime truncate(LocalDateTime time, ChronoUnit unit, int stepRate, DayOfWeek firstDayOfWeek) {
        switch (unit) {
            case DAYS: {
                return Util.adjustField(time, ChronoField.DAY_OF_YEAR, stepRate).truncatedTo(unit);
            }
            case HALF_DAYS: {
                return time.truncatedTo(unit);
            }
            case HOURS: {
                return Util.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return Util.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return Util.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return Util.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return Util.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return Util.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MONTHS: {
                return time.with(ChronoField.MONTH_OF_YEAR, Math.max(1, time.get(ChronoField.MONTH_OF_YEAR) - time.get(ChronoField.MONTH_OF_YEAR) % stepRate)).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            case YEARS: {
                return Util.adjustField(time, ChronoField.YEAR, stepRate).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case WEEKS: {
                return time.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue()).truncatedTo(ChronoUnit.DAYS);
            }
            case DECADES: {
                int decade = time.getYear() / 10 * 10;
                return time.with(ChronoField.YEAR, decade).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case CENTURIES: {
                int century = time.getYear() / 100 * 100;
                return time.with(ChronoField.YEAR, century).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case MILLENNIA: {
                int millenium = time.getYear() / 1000 * 1000;
                return time.with(ChronoField.YEAR, millenium).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
        }
        return time;
    }

    public static ZonedDateTime truncate(ZonedDateTime time, ChronoUnit unit, int stepRate, DayOfWeek firstDayOfWeek) {
        switch (unit) {
            case DAYS: {
                return Util.adjustField(time, ChronoField.DAY_OF_YEAR, stepRate).truncatedTo(unit);
            }
            case HALF_DAYS: {
                return time.truncatedTo(unit);
            }
            case HOURS: {
                return Util.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return Util.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return Util.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return Util.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return Util.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return Util.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MONTHS: {
                return time.with(ChronoField.MONTH_OF_YEAR, Math.max(1, time.get(ChronoField.MONTH_OF_YEAR) - time.get(ChronoField.MONTH_OF_YEAR) % stepRate)).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
            }
            case YEARS: {
                return Util.adjustField(time, ChronoField.YEAR, stepRate).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case WEEKS: {
                return time.with(ChronoField.DAY_OF_WEEK, firstDayOfWeek.getValue()).truncatedTo(ChronoUnit.DAYS);
            }
            case DECADES: {
                int decade = time.getYear() / 10 * 10;
                return time.with(ChronoField.YEAR, decade).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case CENTURIES: {
                int century = time.getYear() / 100 * 100;
                return time.with(ChronoField.YEAR, century).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
            case MILLENNIA: {
                int millenium = time.getYear() / 1000 * 1000;
                return time.with(ChronoField.YEAR, millenium).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
            }
        }
        return time;
    }

    public static LocalTime truncate(LocalTime time, ChronoUnit unit, int stepRate) {
        switch (unit) {
            case HOURS: {
                return Util.adjustField(time, ChronoField.HOUR_OF_DAY, stepRate).truncatedTo(unit);
            }
            case MINUTES: {
                return Util.adjustField(time, ChronoField.MINUTE_OF_HOUR, stepRate).truncatedTo(unit);
            }
            case SECONDS: {
                return Util.adjustField(time, ChronoField.SECOND_OF_MINUTE, stepRate).truncatedTo(unit);
            }
            case MILLIS: {
                return Util.adjustField(time, ChronoField.MILLI_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case MICROS: {
                return Util.adjustField(time, ChronoField.MICRO_OF_SECOND, stepRate).truncatedTo(unit);
            }
            case NANOS: {
                return Util.adjustField(time, ChronoField.NANO_OF_SECOND, stepRate).truncatedTo(unit);
            }
        }
        return time;
    }

    public static boolean equals(Object first, Object second) {
        if (first == null) {
            return second == null;
        }
        if (second == null) {
            return false;
        }
        return first.equals(second);
    }

    public static void runInFXThread(Runnable runnable) {
        if (Platform.isFxApplicationThread()) {
            runnable.run();
        } else {
            Platform.runLater((Runnable)runnable);
        }
    }

    public static <T> MultipleSelectionModel<T> createEmptySelectionModel() {
        return new EmptySelectionModel();
    }

    private static ZonedDateTime adjustField(ZonedDateTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    private static LocalDateTime adjustField(LocalDateTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    private static LocalTime adjustField(LocalTime time, ChronoField field, int stepRate) {
        return time.with(field, time.get(field) - time.get(field) % stepRate);
    }

    private static class EmptySelectionModel<T>
    extends MultipleSelectionModel<T> {
        private final ObservableList<T> selectedItems = FXCollections.observableArrayList();
        private final ObservableList<Integer> selectedIndices = FXCollections.observableArrayList();

        private EmptySelectionModel() {
        }

        public void selectPrevious() {
        }

        public void selectNext() {
        }

        public void select(int index) {
        }

        public void select(T obj) {
        }

        public boolean isSelected(int index) {
            return false;
        }

        public boolean isEmpty() {
            return true;
        }

        public void clearSelection(int index) {
        }

        public void clearSelection() {
        }

        public void clearAndSelect(int index) {
        }

        public void selectLast() {
        }

        public void selectIndices(int index, int ... indices) {
        }

        public void selectFirst() {
        }

        public void selectAll() {
        }

        public ObservableList<T> getSelectedItems() {
            return this.selectedItems;
        }

        public ObservableList<Integer> getSelectedIndices() {
            return this.selectedIndices;
        }
    }
}

