/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.util;

import com.calendarfx.model.Entry;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.util.Column;
import impl.com.calendarfx.view.util.Placement;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class Cluster {
    private List<EntryViewBase<?>> entryViews;
    private ZonedDateTime startTime;
    private ZonedDateTime endTime;
    private List<Column> columns;

    public int getColumnCount() {
        if (this.columns == null || this.columns.isEmpty()) {
            return -1;
        }
        return this.columns.size();
    }

    public void add(EntryViewBase<?> view) {
        if (this.entryViews == null) {
            this.entryViews = new ArrayList();
        }
        this.entryViews.add(view);
        Entry<?> entry = view.getEntry();
        ZonedDateTime entryStartTime = entry.getStartAsZonedDateTime();
        ZonedDateTime entryEndTime = entry.getEndAsZonedDateTime();
        if (entry.isFullDay()) {
            entryStartTime = entryStartTime.with(LocalTime.MIN);
            entryEndTime = entryEndTime.with(LocalTime.MAX);
        }
        if (this.startTime == null || entryStartTime.isBefore(this.startTime)) {
            this.startTime = entryStartTime;
        }
        if (this.endTime == null || entryEndTime.isAfter(this.endTime)) {
            this.endTime = entryEndTime;
        }
    }

    public boolean intersects(EntryViewBase<?> view) {
        if (this.startTime == null) {
            return true;
        }
        Entry<?> entry = view.getEntry();
        ZonedDateTime entryStartTime = entry.getStartAsZonedDateTime();
        ZonedDateTime entryEndTime = entry.getEndAsZonedDateTime();
        if (entry.isFullDay()) {
            entryStartTime = entryStartTime.with(LocalTime.MIN);
            entryEndTime = entryEndTime.with(LocalTime.MAX);
        }
        return entryStartTime.isBefore(this.endTime) && entryEndTime.isAfter(this.startTime);
    }

    public List<Placement> resolve() {
        Column column;
        if (this.entryViews == null || this.entryViews.isEmpty()) {
            return Collections.emptyList();
        }
        this.columns = new ArrayList<Column>();
        this.columns.add(new Column());
        for (EntryViewBase<?> view : this.entryViews) {
            boolean added = false;
            for (Column column2 : this.columns) {
                if (!column2.hasRoomFor(view)) continue;
                column2.add(view);
                added = true;
                break;
            }
            if (added) continue;
            column = new Column();
            this.columns.add(column);
            column.add(view);
        }
        ArrayList<Placement> placements = new ArrayList<Placement>();
        int colCount = this.columns.size();
        for (int col = 0; col < this.columns.size(); ++col) {
            column = this.columns.get(col);
            for (EntryViewBase<?> view : column.getEntryViews()) {
                placements.add(new Placement(view, col, colCount));
            }
        }
        return placements;
    }

    public List<Column> getColumns() {
        return this.columns;
    }
}

