/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.print;

import com.calendarfx.view.Messages;
import com.calendarfx.view.print.TimeRangeField;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class TimeRangeFieldSkin
extends SkinBase<TimeRangeField> {
    private final DatePicker datePicker;
    private final Spinner<Integer> weekNumberSpinner;
    private final Spinner<Integer> monthYearSpinner;
    private final Spinner<Integer> afterUnitsSpinner;
    private final Label afterUnitsLabel;
    private final SpinnerValueFactory.IntegerSpinnerValueFactory weekValueFactory;
    private final SpinnerValueFactory.IntegerSpinnerValueFactory monthYearValueFactory;
    private final SpinnerValueFactory.IntegerSpinnerValueFactory afterUnitsValueFactory;

    public TimeRangeFieldSkin(TimeRangeField control) {
        super((Control)control);
        ComboBox valuesComboBox = new ComboBox();
        valuesComboBox.setConverter((StringConverter)new TimeRangeFieldValueStringConverter());
        valuesComboBox.setItems(control.getValues());
        valuesComboBox.valueProperty().bindBidirectional(control.valueProperty());
        valuesComboBox.setVisibleRowCount(5);
        this.datePicker = new DatePicker();
        this.datePicker.getEditor().setPrefColumnCount(6);
        this.datePicker.valueProperty().bindBidirectional(control.onDateProperty());
        this.datePicker.managedProperty().bind((ObservableValue)this.datePicker.visibleProperty());
        this.datePicker.setEditable(false);
        this.weekValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 52);
        this.weekValueFactory.valueProperty().addListener(obs -> control.setOnWeekNumber((Integer)this.weekValueFactory.getValue()));
        control.onWeekNumberProperty().addListener(obs -> {
            if (control.getOnWeekNumber() != null) {
                this.weekValueFactory.setValue((Object)control.getOnWeekNumber());
            }
        });
        this.weekNumberSpinner = new Spinner();
        this.weekNumberSpinner.setValueFactory((SpinnerValueFactory)this.weekValueFactory);
        this.weekNumberSpinner.managedProperty().bind((ObservableValue)this.weekNumberSpinner.visibleProperty());
        this.weekNumberSpinner.setPrefWidth(70.0);
        this.monthYearValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1972, 3000);
        this.monthYearValueFactory.valueProperty().addListener(obs -> control.setMonthYear((Integer)this.monthYearValueFactory.getValue()));
        control.monthYearProperty().addListener(obs -> {
            if (control.getMonthYear() != null) {
                this.monthYearValueFactory.setValue((Object)control.getMonthYear());
            }
        });
        this.monthYearSpinner = new Spinner();
        this.monthYearSpinner.getEditor().setPrefColumnCount(6);
        this.monthYearSpinner.setValueFactory((SpinnerValueFactory)this.monthYearValueFactory);
        this.monthYearSpinner.managedProperty().bind((ObservableValue)this.monthYearSpinner.visibleProperty());
        this.afterUnitsValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 500);
        this.afterUnitsValueFactory.valueProperty().addListener(obs -> control.setAfterUnits((Integer)this.afterUnitsValueFactory.getValue()));
        control.afterUnitsProperty().addListener(obs -> {
            if (control.getAfterUnits() != null) {
                this.afterUnitsValueFactory.setValue((Object)control.getAfterUnits());
            }
        });
        this.afterUnitsSpinner = new Spinner();
        this.afterUnitsSpinner.getEditor().setPrefColumnCount(4);
        this.afterUnitsSpinner.setValueFactory((SpinnerValueFactory)this.afterUnitsValueFactory);
        this.afterUnitsSpinner.managedProperty().bind((ObservableValue)this.afterUnitsSpinner.visibleProperty());
        this.afterUnitsLabel = new Label();
        this.afterUnitsLabel.managedProperty().bind((ObservableValue)this.afterUnitsLabel.visibleProperty());
        InvalidationListener listener = obs -> this.layout();
        control.viewTypeProperty().addListener(listener);
        control.valueProperty().addListener(listener);
        HBox container = new HBox(5.0, new Node[]{valuesComboBox, this.datePicker, this.weekNumberSpinner, this.monthYearSpinner, this.afterUnitsSpinner, this.afterUnitsLabel});
        container.setAlignment(Pos.CENTER_LEFT);
        HBox.setHgrow((Node)valuesComboBox, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)this.datePicker, (Priority)Priority.SOMETIMES);
        this.getChildren().add((Object)container);
        this.layout();
    }

    private void layout() {
        this.datePicker.setVisible(false);
        this.weekNumberSpinner.setVisible(false);
        this.monthYearSpinner.setVisible(false);
        this.afterUnitsSpinner.setVisible(false);
        this.afterUnitsLabel.setVisible(false);
        if (((TimeRangeField)this.getSkinnable()).getValue() == TimeRangeField.TimeRangeFieldValue.ON_DATE) {
            this.datePicker.setVisible(true);
        } else if (((TimeRangeField)this.getSkinnable()).getValue() == TimeRangeField.TimeRangeFieldValue.ON_WEEK_NUMBER) {
            this.weekNumberSpinner.setVisible(true);
            this.weekValueFactory.setValue((Object)((TimeRangeField)this.getSkinnable()).getOnWeekNumber());
        } else if (((TimeRangeField)this.getSkinnable()).getValue().isMonthValue()) {
            this.monthYearSpinner.setVisible(true);
            this.monthYearValueFactory.setValue((Object)((TimeRangeField)this.getSkinnable()).getMonthYear());
        } else if (((TimeRangeField)this.getSkinnable()).getValue() == TimeRangeField.TimeRangeFieldValue.AFTER) {
            this.afterUnitsLabel.setVisible(true);
            this.afterUnitsLabel.setText(Messages.getString(((TimeRangeField)this.getSkinnable()).getViewType().getPluralChronoMessageKey()));
            this.afterUnitsSpinner.setVisible(true);
            this.afterUnitsValueFactory.setValue((Object)((TimeRangeField)this.getSkinnable()).getAfterUnits());
        }
    }

    private static class TimeRangeFieldValueStringConverter
    extends StringConverter<TimeRangeField.TimeRangeFieldValue> {
        private TimeRangeFieldValueStringConverter() {
        }

        public String toString(TimeRangeField.TimeRangeFieldValue object) {
            return Messages.getString(object.getMessageKey());
        }

        public TimeRangeField.TimeRangeFieldValue fromString(String string) {
            if (string != null) {
                for (TimeRangeField.TimeRangeFieldValue type : TimeRangeField.TimeRangeFieldValue.values()) {
                    if (!string.equals(Messages.getString(type.getMessageKey()))) continue;
                    return type;
                }
            }
            return null;
        }
    }
}

