/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.print;

import com.calendarfx.view.Messages;
import com.calendarfx.view.SourceGridView;
import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.print.PrintablePage;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyStringProperty;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;

public class PrintablePageSkin
extends SkinBase<PrintablePage> {
    private final YearMonthView calendarOne = new YearMonthView();
    private final YearMonthView calendarTwo = new YearMonthView();

    public PrintablePageSkin(PrintablePage control) {
        super((Control)control);
        this.calendarOne.setShowTodayButton(false);
        this.calendarOne.setShowMonthArrows(false);
        this.calendarOne.setShowYearArrows(false);
        this.calendarOne.setShowWeekNumbers(false);
        this.calendarOne.setShowToday(false);
        this.calendarOne.weekFieldsProperty().bind(control.weekFieldsProperty());
        this.calendarOne.visibleProperty().bind((ObservableValue)control.showMiniCalendarsProperty());
        this.calendarOne.dateProperty().bind(control.pageStartDateProperty());
        this.calendarOne.managedProperty().bind((ObservableValue)this.calendarOne.visibleProperty());
        this.calendarTwo.setShowTodayButton(false);
        this.calendarTwo.setShowMonthArrows(false);
        this.calendarTwo.setShowYearArrows(false);
        this.calendarTwo.setShowWeekNumbers(false);
        this.calendarTwo.setShowToday(false);
        this.calendarTwo.weekFieldsProperty().bind(control.weekFieldsProperty());
        this.calendarTwo.dateProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> this.calendarOne.getDate().plusMonths(1L), (Observable[])new Observable[]{this.calendarOne.dateProperty()}));
        this.calendarTwo.visibleProperty().bind((ObservableValue)control.showMiniCalendarsProperty());
        this.calendarTwo.managedProperty().bind((ObservableValue)this.calendarTwo.visibleProperty());
        SourceGridView sourceView = new SourceGridView();
        sourceView.visibleProperty().bind((ObservableValue)control.showCalendarKeysProperty());
        sourceView.managedProperty().bind((ObservableValue)sourceView.visibleProperty());
        sourceView.bind(control);
        PrintPagePeriodFormatter formatter = new PrintPagePeriodFormatter(control);
        Label periodLabel = new Label();
        periodLabel.textProperty().bind((ObservableValue)formatter.textProperty());
        periodLabel.getStyleClass().add((Object)"period-label");
        VBox titleSection = new VBox();
        titleSection.getChildren().addAll((Object[])new Node[]{periodLabel, sourceView});
        titleSection.getStyleClass().add((Object)"title-section");
        HBox calendarsBox = new HBox(new Node[]{this.calendarOne, this.calendarTwo});
        calendarsBox.addEventFilter(MouseEvent.MOUSE_CLICKED, Event::consume);
        calendarsBox.getStyleClass().add((Object)"mini-calendars");
        BorderPane header = new BorderPane();
        header.setCenter((Node)titleSection);
        header.setRight((Node)calendarsBox);
        header.getStyleClass().add((Object)"header");
        BorderPane container = new BorderPane();
        container.setTop((Node)header);
        container.centerProperty().bind(control.viewProperty());
        container.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)container);
        InvalidationListener selectedDatesListener = obs -> this.updateSelectedDates();
        control.pageStartDateProperty().addListener(selectedDatesListener);
        control.pageEndDateProperty().addListener(selectedDatesListener);
        this.updateSelectedDates();
        Region glassPane = new Region();
        glassPane.prefWidthProperty().bind((ObservableValue)((PrintablePage)this.getSkinnable()).widthProperty());
        glassPane.prefHeightProperty().bind((ObservableValue)((PrintablePage)this.getSkinnable()).heightProperty());
        glassPane.getStyleClass().add((Object)"glasspane");
        glassPane.setMouseTransparent(false);
        this.getChildren().add((Object)glassPane);
    }

    private void updateSelectedDates() {
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        LocalDate start = ((PrintablePage)this.getSkinnable()).getPageStartDate();
        do {
            dates.add(start);
        } while ((start = start.plusDays(1L)).isBefore(((PrintablePage)this.getSkinnable()).getPageEndDate()) || start.isEqual(((PrintablePage)this.getSkinnable()).getPageEndDate()));
        this.calendarOne.getSelectedDates().clear();
        this.calendarOne.getSelectedDates().addAll(dates);
        this.calendarTwo.getSelectedDates().clear();
        this.calendarTwo.getSelectedDates().addAll(dates);
    }

    private static final class PrintPagePeriodFormatter
    implements InvalidationListener {
        private final PrintablePage page;
        private final ReadOnlyStringWrapper text = new ReadOnlyStringWrapper((Object)this, "text");

        private PrintPagePeriodFormatter(PrintablePage page) {
            this.page = page;
            page.viewTypeProperty().addListener((InvalidationListener)this);
            page.pageStartDateProperty().addListener((InvalidationListener)this);
            page.pageEndDateProperty().addListener((InvalidationListener)this);
            this.format();
        }

        public final ReadOnlyStringProperty textProperty() {
            return this.text.getReadOnlyProperty();
        }

        private void setText(String text) {
            this.text.set(text);
        }

        private void format() {
            DateTimeFormatter formatter = this.page.getViewType().getDateTimeFormatter();
            switch (this.page.getViewType()) {
                case DAY_VIEW: 
                case MONTH_VIEW: {
                    this.setText(formatter.format(this.page.getPageStartDate()));
                    break;
                }
                case WEEK_VIEW: {
                    StringBuilder sb = new StringBuilder();
                    if (this.page.getPageStartDate().getYear() == this.page.getPageEndDate().getYear()) {
                        sb.append(formatter.format(this.page.getPageStartDate()));
                        sb.append(" ").append(Messages.getString("PrintViewType.TO_LABEL")).append(" ");
                    } else {
                        sb.append(formatter.format(this.page.getPageStartDate()));
                        sb.append(" ").append(Messages.getString("PrintViewType.TO_LABEL")).append(" ");
                    }
                    sb.append(formatter.format(this.page.getPageEndDate()));
                    this.setText(sb.toString());
                    break;
                }
                default: {
                    this.setText("");
                }
            }
        }

        public void invalidated(Observable observable) {
            this.format();
        }
    }
}

