/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.popover;

import com.calendarfx.view.Messages;
import com.calendarfx.view.popover.RecurrencePopup;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Skin;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;

public class RecurrencePopupSkin
implements Skin<RecurrencePopup> {
    private StackPane stackPane;
    private RecurrencePopup popup;

    public RecurrencePopupSkin(RecurrencePopup popup) {
        this.popup = popup;
        Button okButton = new Button(Messages.getString("RecurrencePopupSkin.OK"));
        okButton.setDefaultButton(true);
        okButton.setOnAction(evt -> {
            popup.hide();
            popup.fireEvent(new RecurrencePopup.RecurrencePopupEvent(RecurrencePopup.RecurrencePopupEvent.OK_PRESSED));
        });
        Button cancelButton = new Button(Messages.getString("RecurrencePopupSkin.CANCEL"));
        cancelButton.setCancelButton(true);
        cancelButton.setOnAction(evt -> {
            popup.hide();
            popup.fireEvent(new RecurrencePopup.RecurrencePopupEvent(RecurrencePopup.RecurrencePopupEvent.CANCEL_PRESSED));
        });
        HBox buttonBox = new HBox();
        buttonBox.setAlignment(Pos.CENTER);
        buttonBox.getChildren().addAll((Object[])new Node[]{cancelButton, okButton});
        buttonBox.getStyleClass().add((Object)"button-pane");
        BorderPane contentPane = new BorderPane();
        contentPane.getStyleClass().add((Object)"content");
        contentPane.setCenter((Node)popup.getRecurrenceView());
        contentPane.setBottom((Node)buttonBox);
        this.stackPane = popup.getRoot();
        this.stackPane.getChildren().add((Object)contentPane);
    }

    public RecurrencePopup getSkinnable() {
        return this.popup;
    }

    public Node getNode() {
        return this.stackPane;
    }

    public void dispose() {
    }
}

