/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.page;

import com.calendarfx.view.ButtonBar;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.page.PageBase;
import java.time.format.DateTimeFormatter;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.BorderPane;
import javafx.scene.text.Text;

public abstract class PageBaseSkin<C extends PageBase>
extends SkinBase<C> {
    private Text dateText;
    private BorderPane headerPane;
    private BorderPane borderPane;

    public PageBaseSkin(C page) {
        super(page);
        Button backButton = new Button("<");
        Button forwardButton = new Button(">");
        Button todayButton = new Button(Messages.getString("PageBaseSkin.TODAY"));
        backButton.getStyleClass().add((Object)"previous-date-button");
        forwardButton.getStyleClass().add((Object)"next-date-button");
        backButton.setOnAction(evt -> page.goBack());
        forwardButton.setOnAction(evt -> page.goForward());
        todayButton.setOnAction(evt -> page.goToday());
        ButtonBar navigationButton = new ButtonBar(backButton, todayButton, forwardButton);
        navigationButton.getStyleClass().add((Object)"navigation-button-bar");
        navigationButton.visibleProperty().bind((ObservableValue)((PageBase)((Object)page)).showNavigationProperty());
        this.dateText = new Text("Date");
        this.dateText.getStyleClass().add((Object)"date-text");
        this.dateText.visibleProperty().bind((ObservableValue)((PageBase)((Object)page)).showDateProperty());
        ((DateControl)((Object)page)).dateProperty().addListener(evt -> this.updateDateText());
        BorderPane.setMargin((Node)navigationButton, (Insets)new Insets(10.0));
        BorderPane.setMargin((Node)this.dateText, (Insets)new Insets(10.0));
        this.headerPane = new BorderPane();
        this.headerPane.getStyleClass().add((Object)"header");
        this.headerPane.setLeft((Node)navigationButton);
        this.headerPane.setRight((Node)this.dateText);
        Node content = this.createContent();
        content.getStyleClass().add((Object)"content");
        content.sceneProperty().addListener(it -> {
            if (content.getScene() != null) {
                content.applyCss();
            }
        });
        this.borderPane = new BorderPane();
        this.borderPane.getStyleClass().add((Object)"container");
        this.borderPane.setCenter(content);
        this.getChildren().add((Object)this.borderPane);
        this.updateDateText();
        this.updateHeaderVisibility();
        ((PageBase)((Object)page)).showDateProperty().addListener(it -> this.updateHeaderVisibility());
        ((PageBase)((Object)page)).showNavigationProperty().addListener(it -> this.updateHeaderVisibility());
    }

    private void updateHeaderVisibility() {
        if (((PageBase)this.getSkinnable()).isShowDateHeader() || ((PageBase)this.getSkinnable()).isShowNavigation()) {
            this.borderPane.setTop((Node)this.headerPane);
        } else {
            this.borderPane.setTop(null);
        }
    }

    private void updateDateText() {
        DateTimeFormatter formatter = ((PageBase)this.getSkinnable()).getDateTimeFormatter();
        String text = formatter.format(((PageBase)this.getSkinnable()).getDate());
        this.dateText.setText(text);
    }

    protected abstract Node createContent();
}

