/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view.page;

import com.calendarfx.view.AgendaView;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.DetailedDayView;
import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.page.DayPage;
import impl.com.calendarfx.view.page.PageBaseSkin;
import java.time.LocalDate;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.scene.control.SelectionMode;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class DayPageSkin
extends PageBaseSkin<DayPage> {
    private Label todayLabel;
    private YearMonthView yearMonthView;
    private Node leftSide;
    private Node rightSide;
    private ColumnConstraints leftColumn;
    private ColumnConstraints rightColumn;
    private GridPane gridPane;

    public DayPageSkin(DayPage view) {
        super(view);
        this.yearMonthView.getSelectedDates().addListener(evt -> {
            if (this.yearMonthView.getSelectedDates().size() == 1) {
                LocalDate date = (LocalDate)this.yearMonthView.getSelectedDates().iterator().next();
                ((DayPage)this.getSkinnable()).setDate(date);
            }
        });
        this.updateView();
        view.dateProperty().addListener(evt -> this.updateView());
        view.dayPageLayoutProperty().addListener(it -> this.updateLayout());
        this.updateLayout();
    }

    private void updateView() {
        LocalDate date = ((DayPage)this.getSkinnable()).getDate();
        this.todayLabel.setText(Long.toString(date.getDayOfMonth()));
        this.yearMonthView.getSelectedDates().clear();
        this.yearMonthView.getSelectedDates().add((Object)date);
    }

    @Override
    protected Node createContent() {
        this.leftSide = this.createLeftHandSide();
        this.rightSide = this.createRightHandSide();
        this.leftColumn = new ColumnConstraints();
        this.leftColumn.setPercentWidth(50.0);
        this.leftColumn.setMinWidth(-1.0);
        this.leftColumn.setPrefWidth(-1.0);
        this.leftColumn.setMaxWidth(Double.MAX_VALUE);
        this.leftColumn.setFillWidth(true);
        this.rightColumn = new ColumnConstraints();
        this.rightColumn.setPercentWidth(50.0);
        this.rightColumn.setMinWidth(-1.0);
        this.rightColumn.setPrefWidth(-1.0);
        this.rightColumn.setMaxWidth(Double.MAX_VALUE);
        this.rightColumn.setFillWidth(true);
        RowConstraints rowConstraints = new RowConstraints();
        rowConstraints.setPercentHeight(100.0);
        rowConstraints.setFillHeight(true);
        this.gridPane = new GridPane();
        this.gridPane.setHgap(20.0);
        this.gridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{this.leftColumn, this.rightColumn});
        this.gridPane.getRowConstraints().addAll((Object[])new RowConstraints[]{rowConstraints});
        this.gridPane.add(this.leftSide, 0, 0);
        this.gridPane.add(this.rightSide, 1, 0);
        ((DayPage)this.getSkinnable()).widthProperty().addListener(it -> this.updateLayout());
        return this.gridPane;
    }

    private void updateLayout() {
        DayPage page = (DayPage)this.getSkinnable();
        switch (page.getDayPageLayout()) {
            case STANDARD: {
                Insets insets = page.getInsets();
                if (page.getWidth() - insets.getLeft() - insets.getRight() < this.leftSide.prefWidth(-1.0) + this.rightSide.prefWidth(-1.0)) {
                    this.leftSide.setVisible(false);
                    this.rightSide.setVisible(true);
                    this.leftColumn.setPercentWidth(0.0);
                    this.rightColumn.setPercentWidth(100.0);
                    break;
                }
                this.leftSide.setVisible(true);
                this.rightSide.setVisible(true);
                this.leftColumn.setPercentWidth(50.0);
                this.rightColumn.setPercentWidth(50.0);
                break;
            }
            case AGENDA_ONLY: {
                this.leftSide.setVisible(true);
                this.rightSide.setVisible(false);
                this.leftColumn.setPercentWidth(100.0);
                this.rightColumn.setPercentWidth(0.0);
                break;
            }
            case DAY_ONLY: {
                this.leftSide.setVisible(false);
                this.rightSide.setVisible(true);
                this.leftColumn.setPercentWidth(0.0);
                this.rightColumn.setPercentWidth(100.0);
            }
        }
    }

    protected Node createLeftHandSide() {
        DayPage dayPage = (DayPage)this.getSkinnable();
        this.todayLabel = new Label();
        this.todayLabel.getStyleClass().add((Object)"today-label");
        this.todayLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.todayLabel.setAlignment(Pos.TOP_LEFT);
        this.todayLabel.setTextOverrun(OverrunStyle.CLIP);
        this.todayLabel.setMinWidth(Double.NEGATIVE_INFINITY);
        HBox.setHgrow((Node)this.todayLabel, (Priority)Priority.ALWAYS);
        this.yearMonthView = dayPage.getYearMonthView();
        this.yearMonthView.setSelectionMode(SelectionMode.SINGLE);
        this.yearMonthView.setShowMonth(false);
        this.yearMonthView.setShowYear(false);
        this.yearMonthView.setShowTodayButton(false);
        HBox.setHgrow((Node)this.yearMonthView, (Priority)Priority.NEVER);
        ((DayPage)this.getSkinnable()).bind(this.yearMonthView, true);
        HBox header = new HBox(10.0);
        header.setFillHeight(true);
        header.getChildren().addAll((Object[])new Node[]{this.todayLabel, this.yearMonthView});
        header.getStyleClass().add((Object)"header");
        AgendaView agendaView = dayPage.getAgendaView();
        ((DayPage)this.getSkinnable()).bind(agendaView, true);
        HBox.setMargin((Node)agendaView, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        BorderPane leftHandSide = new BorderPane();
        leftHandSide.getStyleClass().add((Object)"left-side");
        leftHandSide.setTop((Node)header);
        leftHandSide.setCenter((Node)agendaView);
        HBox.setHgrow((Node)leftHandSide, (Priority)Priority.ALWAYS);
        return leftHandSide;
    }

    protected Node createRightHandSide() {
        DayPage dayPage = (DayPage)this.getSkinnable();
        DetailedDayView dayView = dayPage.getDetailedDayView();
        ((DayPage)this.getSkinnable()).bind(dayView, true);
        AllDayView allDayView = dayView.getAllDayView();
        allDayView.showTodayProperty().unbind();
        return dayView;
    }
}

