/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.YearView;
import impl.com.calendarfx.view.DateControlSkin;
import java.time.LocalDate;
import java.time.Month;
import java.time.YearMonth;
import javafx.geometry.HPos;
import javafx.geometry.VPos;
import javafx.scene.Node;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;

public class YearViewSkin
extends DateControlSkin<YearView> {
    public YearViewSkin(YearView view) {
        super(view);
        int row;
        view.dateProperty().addListener(evt -> this.updateMonths());
        GridPane gridPane = new GridPane();
        gridPane.getStyleClass().add((Object)"container");
        gridPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        for (row = 0; row < 3; ++row) {
            RowConstraints rowConstraints = new RowConstraints();
            rowConstraints.setMinHeight(Double.NEGATIVE_INFINITY);
            rowConstraints.setPrefHeight(-1.0);
            rowConstraints.setMaxHeight(-1.0);
            rowConstraints.setVgrow(Priority.ALWAYS);
            rowConstraints.setValignment(VPos.CENTER);
            gridPane.getRowConstraints().add((Object)rowConstraints);
        }
        for (int col = 0; col < 4; ++col) {
            ColumnConstraints colConstraints = new ColumnConstraints();
            colConstraints.setMinWidth(Double.NEGATIVE_INFINITY);
            colConstraints.setPrefWidth(-1.0);
            colConstraints.setMaxWidth(-1.0);
            colConstraints.setHgrow(Priority.ALWAYS);
            colConstraints.setHalignment(HPos.CENTER);
            gridPane.getColumnConstraints().add((Object)colConstraints);
        }
        for (row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                Month month = Month.of(row * 4 + col + 1);
                YearMonthView yearMonthView = view.getMonthView(month);
                yearMonthView.setShowMonthArrows(false);
                yearMonthView.setShowTodayButton(false);
                yearMonthView.setShowUsageColors(true);
                yearMonthView.setClickBehaviour(YearMonthView.ClickBehaviour.SHOW_DETAILS);
                gridPane.add((Node)yearMonthView, col, row);
                view.bind(yearMonthView, false);
            }
        }
        this.getChildren().add((Object)gridPane);
        this.updateMonths();
    }

    private void updateMonths() {
        YearView yearPage = (YearView)this.getSkinnable();
        LocalDate date = yearPage.getDate();
        int year = date.getYear();
        for (Month month : Month.values()) {
            YearMonth yearMonth = YearMonth.of(year, month);
            YearMonthView view = yearPage.getMonthView(month);
            view.setMinSize(0.0, 0.0);
            view.setDate(yearMonth.atDay(1));
        }
    }
}

