/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.WeekDayView;
import com.calendarfx.view.WeekView;
import impl.com.calendarfx.view.DayViewEditController;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoField;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.shape.Rectangle;
import javafx.util.Callback;

public class WeekViewSkin
extends SkinBase<WeekView> {
    private GridPane dayGridPane = new GridPane();

    public WeekViewSkin(WeekView view) {
        super((Control)view);
        InvalidationListener rebuildListener = it -> this.buildDays();
        view.numberOfDaysProperty().addListener(rebuildListener);
        view.adjustToFirstDayOfWeekProperty().addListener(rebuildListener);
        view.weekDayViewFactoryProperty().addListener(rebuildListener);
        this.buildDays();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)view.widthProperty());
        clip.heightProperty().bind((ObservableValue)view.heightProperty());
        view.setClip((Node)clip);
        new DayViewEditController(view);
        this.getChildren().add((Object)this.dayGridPane);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double height = this.dayGridPane.prefHeight(-1.0);
        this.dayGridPane.resizeRelocate(contentX, contentY, contentWidth, height);
    }

    private void buildDays() {
        WeekView weekView = (WeekView)this.getSkinnable();
        ObservableList<WeekDayView> weekDayViews = weekView.getWeekDayViews();
        weekDayViews.forEach(view -> ((WeekView)this.getSkinnable()).unbind((DayViewBase)view));
        this.dayGridPane.getChildren().clear();
        this.dayGridPane.getColumnConstraints().clear();
        weekDayViews.clear();
        Callback<WeekView.WeekDayParameter, WeekDayView> weekDayViewFactory = weekView.getWeekDayViewFactory();
        int numberOfDays = weekView.getNumberOfDays();
        for (int i = 0; i < numberOfDays; ++i) {
            ColumnConstraints con = new ColumnConstraints();
            con.setPercentWidth(100.0 / (double)numberOfDays);
            this.dayGridPane.getColumnConstraints().add((Object)con);
            WeekView.WeekDayParameter param = new WeekView.WeekDayParameter(weekView);
            WeekDayView weekDayView = (WeekDayView)weekDayViewFactory.call((Object)param);
            weekDayView.getProperties().put((Object)"week.view", (Object)weekView);
            weekDayView.earliestTimeUsedProperty().addListener(it -> this.updateUsedTimes());
            weekDayView.latestTimeUsedProperty().addListener(it -> this.updateUsedTimes());
            if (i == 0) {
                weekDayView.getStyleClass().add((Object)"first-day");
            } else if (i == numberOfDays - 1) {
                weekDayView.getStyleClass().add((Object)"last-day");
            }
            GridPane.setHgrow((Node)weekDayView, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)weekDayView, (Priority)Priority.ALWAYS);
            int dayCount = i;
            InvalidationListener updateListener = it -> this.updateDate(weekDayView, dayCount);
            weekView.dateProperty().addListener(updateListener);
            weekView.weekFieldsProperty().addListener(updateListener);
            this.updateDate(weekDayView, dayCount);
            ((WeekView)this.getSkinnable()).bind(weekDayView, false);
            Bindings.bindBidirectional(weekDayView.startTimeProperty(), weekView.startTimeProperty());
            Bindings.bindBidirectional(weekDayView.endTimeProperty(), weekView.endTimeProperty());
            this.dayGridPane.add((Node)weekDayView, i, 0);
            weekDayViews.add(weekDayView);
        }
    }

    private void updateUsedTimes() {
        LocalTime earliestTime = null;
        LocalTime latestTime = null;
        for (WeekDayView view : ((WeekView)this.getSkinnable()).getWeekDayViews()) {
            LocalTime etu = view.getEarliestTimeUsed();
            LocalTime ltu = view.getLatestTimeUsed();
            if (earliestTime == null || etu != null && etu.isBefore(earliestTime)) {
                earliestTime = etu;
            }
            if (latestTime != null && (ltu == null || !ltu.isAfter(latestTime))) continue;
            latestTime = ltu;
        }
        ((WeekView)this.getSkinnable()).getProperties().put((Object)"earliest.time.used", earliestTime);
        ((WeekView)this.getSkinnable()).getProperties().put((Object)"latest.time.used", latestTime);
    }

    private void updateDate(WeekDayView view, int dayCount) {
        this.updateDate(view, ((WeekView)this.getSkinnable()).getDate(), dayCount);
    }

    private void updateDate(WeekDayView view, LocalDate startDate, int dayCount) {
        LocalDate date = this.getDate(startDate, dayCount);
        view.setDate(date);
    }

    private LocalDate getDate(LocalDate startDate, int dayCount) {
        if (((WeekView)this.getSkinnable()).isAdjustToFirstDayOfWeek()) {
            LocalDate newStartDate = startDate.with(ChronoField.DAY_OF_WEEK, ((WeekView)this.getSkinnable()).getFirstDayOfWeek().getValue());
            startDate = newStartDate.isAfter(startDate) ? newStartDate.minusWeeks(1L) : newStartDate;
        }
        return startDate.plusDays(dayCount);
    }
}

