/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.WeekDayHeaderView;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.util.Callback;

public class WeekDayHeaderViewSkin
extends SkinBase<WeekDayHeaderView> {
    private static final String TODAY = "today";
    private GridPane pane = new GridPane();

    public WeekDayHeaderViewSkin(WeekDayHeaderView view) {
        super((Control)view);
        this.pane.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.pane);
        InvalidationListener updateListener = it -> this.updateControl();
        view.numberOfDaysProperty().addListener(updateListener);
        view.showTodayProperty().addListener(updateListener);
        view.weekFieldsProperty().addListener(updateListener);
        view.enableHyperlinksProperty().addListener(updateListener);
        view.adjustToFirstDayOfWeekProperty().addListener(updateListener);
        this.updateControl();
    }

    private void updateControl() {
        this.pane.getChildren().clear();
        this.pane.getColumnConstraints().clear();
        WeekDayHeaderView view = (WeekDayHeaderView)this.getSkinnable();
        int numberOfDays = view.getNumberOfDays();
        Callback<WeekDayHeaderView, WeekDayHeaderView.WeekDayCell> cellFactory = view.getCellFactory();
        for (int i = 0; i < numberOfDays; ++i) {
            ColumnConstraints con = new ColumnConstraints();
            con.setPercentWidth(100.0 / (double)numberOfDays);
            this.pane.getColumnConstraints().add((Object)con);
            WeekDayHeaderView.WeekDayCell cell = (WeekDayHeaderView.WeekDayCell)((Object)cellFactory.call((Object)view));
            GridPane.setHgrow((Node)cell, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)cell, (Priority)Priority.ALWAYS);
            GridPane.setFillHeight((Node)cell, (Boolean)true);
            GridPane.setFillWidth((Node)cell, (Boolean)true);
            int dayCount = i;
            view.dateProperty().addListener(evt -> this.updateCell(cell, dayCount));
            this.updateCell(cell, dayCount);
            this.pane.add((Node)cell, i, 0);
        }
    }

    private void updateCell(WeekDayHeaderView.WeekDayCell cell, int dayCount) {
        LocalDate startDate = ((WeekDayHeaderView)this.getSkinnable()).getDate();
        LocalDate date = this.getDate(startDate, dayCount);
        cell.setDate(date);
        if (((WeekDayHeaderView)this.getSkinnable()).isShowToday() && date.equals(((WeekDayHeaderView)this.getSkinnable()).getToday())) {
            if (!cell.getStyleClass().contains((Object)TODAY)) {
                cell.getStyleClass().add((Object)TODAY);
            }
        } else {
            cell.getStyleClass().remove((Object)TODAY);
        }
    }

    private LocalDate getDate(LocalDate startDate, int dayCount) {
        if (((WeekDayHeaderView)this.getSkinnable()).isAdjustToFirstDayOfWeek()) {
            LocalDate newStartDate = startDate.with(ChronoField.DAY_OF_WEEK, ((WeekDayHeaderView)this.getSkinnable()).getFirstDayOfWeek().getValue());
            startDate = newStartDate.isAfter(startDate) ? newStartDate.minusWeeks(1L) : newStartDate;
        }
        return startDate.plusDays(dayCount);
    }
}

