/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayViewBase;
import impl.com.calendarfx.view.DayViewScrollPane;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import javafx.collections.ObservableList;
import javafx.geometry.Bounds;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.effect.Light;
import javafx.stage.Screen;
import org.controlsfx.control.PopOver;

public final class ViewHelper {
    public static double getTimeLocation(DayViewBase view, LocalTime time) {
        return ViewHelper.getTimeLocation(view, time, false);
    }

    public static double getTimeLocation(DayViewBase view, LocalTime time, boolean prefHeight) {
        LocalTime startTime = view.getStartTime();
        LocalTime endTime = view.getEndTime();
        double availableHeight = view.getHeight();
        if (prefHeight) {
            availableHeight = view.prefHeight(-1.0);
        }
        DayViewBase.EarlyLateHoursStrategy strategy = view.getEarlyLateHoursStrategy();
        switch (strategy) {
            case SHOW: {
                long startNano = LocalTime.MIN.toNanoOfDay();
                long endNano = LocalTime.MAX.toNanoOfDay();
                double npp = (double)(endNano - startNano) / availableHeight;
                return (double)((int)((double)(time.toNanoOfDay() - startNano) / npp)) + 0.5;
            }
            case HIDE: {
                if (time.isBefore(startTime)) {
                    return -1.0;
                }
                if (time.isAfter(endTime)) {
                    return availableHeight;
                }
                long startNano = startTime.toNanoOfDay();
                long endNano = endTime.toNanoOfDay();
                double npp = (double)(endNano - startNano) / availableHeight;
                return (double)((int)((double)(time.toNanoOfDay() - startNano) / npp)) + 0.5;
            }
            case SHOW_COMPRESSED: {
                long earlyHours = ChronoUnit.HOURS.between(LocalTime.MIN, startTime);
                long lateHours = ChronoUnit.HOURS.between(endTime, LocalTime.MAX) + 1L;
                double hourHeightCompressed = view.getHourHeightCompressed();
                double earlyHeight = hourHeightCompressed * (double)earlyHours;
                double lateHeight = hourHeightCompressed * (double)lateHours;
                if (time.isBefore(startTime)) {
                    long startNano = LocalTime.MIN.toNanoOfDay();
                    long endNano = startTime.toNanoOfDay();
                    double npp = (double)(endNano - startNano) / earlyHeight;
                    return (double)((int)((double)(time.toNanoOfDay() - startNano) / npp)) + 0.5;
                }
                if (time.isAfter(endTime)) {
                    long startNano = endTime.toNanoOfDay();
                    long endNano = LocalTime.MAX.toNanoOfDay();
                    double npp = (double)(endNano - startNano) / lateHeight;
                    return (double)((int)((double)(time.toNanoOfDay() - startNano) / npp)) + (availableHeight - lateHeight) + 0.5;
                }
                long startNano = startTime.toNanoOfDay();
                long endNano = endTime.toNanoOfDay();
                double npp = (double)(endNano - startNano) / (availableHeight - earlyHeight - lateHeight);
                return earlyHeight + (double)((int)((double)(time.toNanoOfDay() - startNano) / npp)) + 0.5;
            }
        }
        return 0.0;
    }

    public static LocalDateTime getLocationTime(DayViewBase view, double y, boolean trim, boolean prefHeight) {
        if (view.getEarlyLateHoursStrategy().equals((Object)DayViewBase.EarlyLateHoursStrategy.HIDE)) {
            trim = true;
        }
        LocalDate localDate = view.getDate();
        double availableHeight = view.getHeight();
        if (prefHeight) {
            availableHeight = view.prefHeight(-1.0);
        }
        if (y < 0.0) {
            if (trim) {
                return LocalDateTime.of(view.getDate(), view.getStartTime());
            }
            y = availableHeight + y;
            localDate = localDate.minusDays(1L);
        } else if (y > availableHeight) {
            if (trim) {
                return LocalDateTime.of(view.getDate(), view.getEndTime());
            }
            y -= availableHeight;
            localDate = localDate.plusDays(1L);
        }
        LocalTime startTime = view.getStartTime();
        LocalTime endTime = view.getEndTime();
        switch (view.getEarlyLateHoursStrategy()) {
            case SHOW: {
                long startNano = LocalTime.MIN.toNanoOfDay();
                long endNano = LocalTime.MAX.toNanoOfDay();
                double npp = (double)(endNano - startNano) / availableHeight;
                long nanos = Math.min(LocalTime.MAX.toNanoOfDay(), (long)(npp * y));
                return LocalDateTime.of(localDate, LocalTime.ofNanoOfDay(nanos));
            }
            case HIDE: {
                long startNano = startTime.toNanoOfDay();
                long endNano = endTime.toNanoOfDay();
                double npp = (double)(endNano - startNano) / availableHeight;
                long nanos = Math.min(endTime.toNanoOfDay(), (long)(npp * y) + startNano);
                return LocalDateTime.of(localDate, LocalTime.ofNanoOfDay(nanos));
            }
            case SHOW_COMPRESSED: {
                long earlyHours = ChronoUnit.HOURS.between(LocalTime.MIN, startTime);
                long lateHours = ChronoUnit.HOURS.between(endTime, LocalTime.MAX) + 1L;
                double hourHeightCompressed = view.getHourHeightCompressed();
                double earlyHeight = hourHeightCompressed * (double)earlyHours;
                double lateHeight = hourHeightCompressed * (double)lateHours;
                if (y < earlyHeight) {
                    long startNano = LocalTime.MIN.toNanoOfDay();
                    long endNano = startTime.toNanoOfDay();
                    double npp = (double)(endNano - startNano) / earlyHeight;
                    long nanos = Math.min(LocalTime.MAX.toNanoOfDay(), (long)(npp * y));
                    return LocalDateTime.of(localDate, LocalTime.ofNanoOfDay(nanos));
                }
                if (y > availableHeight - lateHeight) {
                    long startNano = endTime.toNanoOfDay();
                    long endNano = LocalTime.MAX.toNanoOfDay();
                    double npp = (double)(endNano - startNano) / lateHeight;
                    long nanos = Math.min(LocalTime.MAX.toNanoOfDay(), (long)(npp * (y - (availableHeight - lateHeight))) + startNano);
                    return LocalDateTime.of(localDate, LocalTime.ofNanoOfDay(nanos));
                }
                long startNano = startTime.toNanoOfDay();
                long endNano = endTime.toNanoOfDay();
                double npp = (double)(endNano - startNano) / (availableHeight - earlyHeight - lateHeight);
                long nanos = Math.min(LocalTime.MAX.toNanoOfDay(), (long)(npp * (y - earlyHeight)) + startNano);
                return LocalDateTime.of(localDate, LocalTime.ofNanoOfDay(nanos));
            }
        }
        return LocalDateTime.of(localDate, LocalTime.MIN);
    }

    public static PopOver.ArrowLocation findPopOverArrowLocation(Node view) {
        Bounds localBounds = view.getBoundsInLocal();
        Bounds entryBounds = view.localToScreen(localBounds);
        ObservableList screens = Screen.getScreensForRectangle((double)entryBounds.getMinX(), (double)entryBounds.getMinY(), (double)entryBounds.getWidth(), (double)entryBounds.getHeight());
        Rectangle2D screenBounds = ((Screen)screens.get(0)).getVisualBounds();
        double spaceLeft = entryBounds.getMinX();
        double spaceRight = screenBounds.getWidth() - entryBounds.getMaxX();
        double spaceTop = entryBounds.getMinY();
        double spaceBottom = screenBounds.getHeight() - entryBounds.getMaxY();
        if (spaceLeft > spaceRight) {
            if (spaceTop > spaceBottom) {
                return PopOver.ArrowLocation.RIGHT_BOTTOM;
            }
            return PopOver.ArrowLocation.RIGHT_TOP;
        }
        if (spaceTop > spaceBottom) {
            return PopOver.ArrowLocation.LEFT_BOTTOM;
        }
        return PopOver.ArrowLocation.LEFT_TOP;
    }

    public static Light.Point findPopOverArrowPosition(Node node, double screenY, double arrowSize, PopOver.ArrowLocation arrowLocation) {
        Light.Point point = new Light.Point();
        point.setY(screenY);
        Bounds entryBounds = node.localToScreen(node.getBoundsInLocal());
        if (arrowLocation == PopOver.ArrowLocation.LEFT_TOP || arrowLocation == PopOver.ArrowLocation.LEFT_BOTTOM) {
            point.setX(entryBounds.getMaxX());
        } else {
            point.setX(entryBounds.getMinX() - arrowSize);
        }
        return point;
    }

    public static void scrollToRequestedTime(DateControl control, DayViewScrollPane scrollPane) {
        LocalTime requestedTime = control.getRequestedTime();
        if (requestedTime != null) {
            scrollPane.scrollToTime(requestedTime);
        }
    }
}

