/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.TimeScaleView;
import impl.com.calendarfx.view.DayViewBaseSkin;
import impl.com.calendarfx.view.ViewHelper;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.OverrunStyle;
import javafx.util.Duration;

public class TimeScaleViewSkin<T extends TimeScaleView>
extends DayViewBaseSkin<T> {
    private List<Label> labels = new ArrayList<Label>();
    private Label currentTimeLabel;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);

    public TimeScaleViewSkin(T view) {
        super(view);
        LocalTime time = LocalTime.of(1, 0);
        for (int i = 1; i < 24; ++i) {
            Label label = new Label(time.format(this.formatter));
            label.setManaged(false);
            label.setMaxWidth(Double.MAX_VALUE);
            label.setAlignment(Pos.CENTER_RIGHT);
            label.getStyleClass().add((Object)"time-label");
            label.setTextOverrun(OverrunStyle.CLIP);
            this.labels.add(label);
            this.getChildren().add((Object)label);
            time = time.plusHours(1L);
        }
        this.currentTimeLabel = new Label();
        this.currentTimeLabel.getStyleClass().add((Object)"current-time-label");
        this.currentTimeLabel.setManaged(false);
        this.currentTimeLabel.setMaxWidth(Double.MAX_VALUE);
        this.currentTimeLabel.setAlignment(Pos.CENTER_RIGHT);
        this.currentTimeLabel.setOpacity(0.0);
        this.currentTimeLabel.setTextOverrun(OverrunStyle.CLIP);
        this.currentTimeLabel.visibleProperty().bind((ObservableValue)((DayViewBase)view).enableCurrentTimeMarkerProperty());
        this.getChildren().add((Object)this.currentTimeLabel);
        this.updateCurrentTimeMarkerVisibility();
        ((DayViewBase)view).showCurrentTimeMarkerProperty().addListener(it -> this.updateCurrentTimeMarkerVisibility());
        this.setupCurrentTimeMarkerSupport();
        this.updateShowMarkers();
    }

    private void updateCurrentTimeMarkerVisibility() {
        double opacity = ((TimeScaleView)this.getSkinnable()).isShowCurrentTimeMarker() ? 1.0 : 0.0;
        FadeTransition lineTransition = new FadeTransition(Duration.millis((double)600.0), (Node)this.currentTimeLabel);
        lineTransition.setToValue(opacity);
        lineTransition.play();
        ((TimeScaleView)this.getSkinnable()).requestLayout();
    }

    protected void setupCurrentTimeMarkerSupport() {
        TimeScaleView view = (TimeScaleView)this.getSkinnable();
        InvalidationListener listener = evt -> this.updateShowMarkers();
        view.dateProperty().addListener(listener);
        view.todayProperty().addListener(listener);
    }

    private void updateShowMarkers() {
        TimeScaleView view = (TimeScaleView)this.getSkinnable();
        view.getProperties().put((Object)"show.current.time.marker", (Object)this.isShowingTimeMarker());
    }

    protected boolean isShowingTimeMarker() {
        return ((TimeScaleView)this.getSkinnable()).getDate().equals(((TimeScaleView)this.getSkinnable()).getToday());
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        int labelCount = this.labels.size();
        LocalTime now = ((TimeScaleView)this.getSkinnable()).getTime();
        this.currentTimeLabel.setText(now.format(this.formatter));
        this.placeLabel(this.currentTimeLabel, now, contentX, contentY, contentWidth, contentHeight);
        LocalTime startTime = ((TimeScaleView)this.getSkinnable()).getStartTime();
        LocalTime endTime = ((TimeScaleView)this.getSkinnable()).getEndTime();
        block4: for (int hour = 0; hour < labelCount; ++hour) {
            LocalTime time = LocalTime.of(hour + 1, 0);
            Label label = this.labels.get(hour);
            label.getStyleClass().removeAll((Object[])new String[]{"early-hour-label", "late-hour-label"});
            this.placeLabel(label, time, contentX, contentY, contentWidth, contentHeight);
            Bounds localToParent1 = this.currentTimeLabel.localToParent(this.currentTimeLabel.getLayoutBounds());
            Bounds localToParent2 = label.localToParent(label.getLayoutBounds());
            if (this.currentTimeLabel.isVisible() && ((TimeScaleView)this.getSkinnable()).isShowCurrentTimeMarker() && localToParent1.intersects(localToParent2)) {
                label.setVisible(false);
            } else {
                label.setVisible(true);
            }
            if (time.isBefore(startTime) && !label.getStyleClass().contains((Object)"early-hour-label")) {
                label.getStyleClass().add((Object)"early-hour-label");
            }
            if (time.isAfter(endTime) && !label.getStyleClass().contains((Object)"late-hour-label")) {
                label.getStyleClass().add((Object)"late-hour-label");
            }
            if (!label.isVisible()) continue;
            switch (((TimeScaleView)this.getSkinnable()).getEarlyLateHoursStrategy()) {
                case HIDE: 
                case SHOW_COMPRESSED: {
                    if (!time.isBefore(startTime) && !time.isAfter(endTime)) continue block4;
                    label.setVisible(false);
                    continue block4;
                }
                case SHOW: {
                    label.setVisible(true);
                    continue block4;
                }
            }
        }
        this.currentTimeLabel.toFront();
    }

    private void placeLabel(Label label, LocalTime time, double contentX, double contentY, double contentWidth, double contentHeight) {
        double prefHeight = label.prefHeight(contentWidth);
        double y = contentY + ViewHelper.getTimeLocation((DayViewBase)this.getSkinnable(), time, true);
        y = Math.min(contentHeight - label.getFont().getSize(), Math.max(0.0, (double)((int)(y - prefHeight / 2.0)) + 0.5));
        label.resizeRelocate(this.snapPosition(contentX), this.snapPosition(y), this.snapSize(contentWidth), this.snapSize(prefHeight));
    }

    protected double computePrefWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        double width = 0.0;
        for (Label label : this.labels) {
            width = Math.max(width, label.prefWidth(-1.0));
        }
        return width + leftInset + rightInset;
    }

    protected double computeMinWidth(double height, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefWidth(height, topInset, rightInset, bottomInset, leftInset);
    }
}

