/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.view.SourceView;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.SkinBase;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;

public class SourceViewSkin
extends SkinBase<SourceView> {
    private VBox vbox;
    private final InvalidationListener updater = obs -> this.updateView();

    public SourceViewSkin(SourceView view) {
        super((Control)view);
        this.vbox = new VBox();
        this.vbox.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.vbox);
        view.getCalendarSources().addListener(this.updater);
        this.updateView();
    }

    private void updateView() {
        this.vbox.getChildren().clear();
        for (CalendarSource source : ((SourceView)this.getSkinnable()).getCalendarSources()) {
            source.getCalendars().removeListener(this.updater);
            source.getCalendars().addListener(this.updater);
            VBox box = new VBox(8.0);
            box.getStyleClass().add((Object)"single-calendar-group");
            for (Calendar calendar : source.getCalendars()) {
                CheckBox checkBox = new CheckBox();
                checkBox.textProperty().bind((ObservableValue)calendar.nameProperty());
                checkBox.getStyleClass().addAll((Object[])new String[]{"default-style-visibility-checkbox", calendar.getStyle() + "-visibility-checkbox"});
                Bindings.bindBidirectional((Property)checkBox.selectedProperty(), (Property)((SourceView)this.getSkinnable()).getCalendarVisibilityProperty(calendar));
                box.getChildren().add((Object)checkBox);
            }
            if (((SourceView)this.getSkinnable()).getCalendarSources().size() == 1) {
                this.vbox.getChildren().add((Object)box);
                continue;
            }
            TitledPane titledPane = new TitledPane();
            titledPane.textProperty().bind((ObservableValue)source.nameProperty());
            titledPane.setContent((Node)box);
            this.vbox.getChildren().add((Object)titledPane);
        }
    }
}

