/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.view.SourceGridView;
import java.util.ArrayList;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ListChangeListener;
import javafx.collections.WeakListChangeListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;

public class SourceGridViewSkin
extends SkinBase<SourceGridView> {
    private static final String DEFAULT_STYLE = "source-grid-view";
    private final InvalidationListener buildListener = obs -> this.build();
    private final WeakInvalidationListener buildWeakListener = new WeakInvalidationListener(this.buildListener);
    private final ListChangeListener<CalendarSource> sourcesChangeListener = c -> {
        while (c.next()) {
            for (CalendarSource added : c.getAddedSubList()) {
                added.getCalendars().addListener((InvalidationListener)this.buildWeakListener);
            }
            for (CalendarSource removed : c.getRemoved()) {
                removed.getCalendars().removeListener((InvalidationListener)this.buildWeakListener);
            }
        }
        this.build();
    };
    private final WeakListChangeListener<CalendarSource> sourcesWeakChangeListener = new WeakListChangeListener(this.sourcesChangeListener);
    private final HBox container = new HBox();

    public SourceGridViewSkin(SourceGridView control) {
        super((Control)control);
        this.container.getStyleClass().add((Object)DEFAULT_STYLE);
        this.build();
        control.getCalendarSources().addListener(this.sourcesWeakChangeListener);
        control.maximumRowsPerColumnProperty().addListener((InvalidationListener)this.buildWeakListener);
        this.getChildren().add((Object)this.container);
    }

    private void build() {
        ArrayList<VBox> children = new ArrayList<VBox>();
        VBox row = null;
        int count = 0;
        SourceGridView view = (SourceGridView)this.getSkinnable();
        for (CalendarSource source : view.getCalendarSources()) {
            for (Calendar calendar : source.getCalendars()) {
                view.getCalendarVisibilityProperty(calendar).removeListener((InvalidationListener)this.buildWeakListener);
                view.getCalendarVisibilityProperty(calendar).addListener((InvalidationListener)this.buildWeakListener);
                if (!view.isCalendarVisible(calendar)) continue;
                if (count == 0) {
                    row = new VBox();
                    row.getStyleClass().add((Object)"column");
                    children.add(row);
                }
                row.getChildren().add((Object)new CalendarItem(calendar));
                if (++count != view.getMaximumRowsPerColumn()) continue;
                count = 0;
            }
        }
        this.container.getChildren().setAll(children);
    }

    private static class CalendarItem
    extends Label {
        public CalendarItem(Calendar calendar) {
            Pane graphic = new Pane();
            graphic.getStyleClass().add((Object)"item-box");
            graphic.getStyleClass().add((Object)(calendar.getStyle() + "-source-grid-item-box"));
            this.getStyleClass().add((Object)"item");
            this.setGraphic((Node)graphic);
            this.setText(calendar.getName());
        }
    }
}

