/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.util.LoggingDomain;
import com.calendarfx.util.Util;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RecurrenceView;
import com.google.ical.compat.jodatime.LocalDateIterator;
import com.google.ical.compat.jodatime.LocalDateIteratorFactory;
import com.google.ical.values.DateValue;
import com.google.ical.values.DateValueImpl;
import com.google.ical.values.RRule;
import com.google.ical.values.Weekday;
import com.google.ical.values.WeekdayNum;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.geometry.HPos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SkinBase;
import javafx.scene.control.Spinner;
import javafx.scene.control.SpinnerValueFactory;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;

public class RecurrenceViewSkin
extends SkinBase<RecurrenceView> {
    private ComboBox<Frequency> frequencyBox = new ComboBox();
    private Spinner<Integer> repeatCountSpinner = new Spinner();
    private Label repeatCountGranularity = new Label();
    private Label startOnDateLabel = new Label();
    private RadioButton endsNeverButton = new RadioButton(Messages.getString("RecurrenceViewSkin.NEVER"));
    private RadioButton endsAfterButton = new RadioButton(Messages.getString("RecurrenceViewSkin.AFTER"));
    private Spinner<Integer> endsAfterCounterSpinner = new Spinner();
    private Label endsAfterOccurencesLabel = new Label(Messages.getString("RecurrenceViewSkin.OCCURENCES"));
    private RadioButton endsOnButton = new RadioButton(Messages.getString("RecurrenceViewSkin.ON"));
    private DatePicker endsOnDatePicker = new DatePicker(LocalDate.now());
    private Label summaryLabel = new Label();
    private RadioButton repeatByDayOfTheMonth = new RadioButton(Messages.getString("RecurrenceViewSkin.DAY_OF_MONTH"));
    private RadioButton repeatByDayOfTheWeek = new RadioButton(Messages.getString("RecurrenceViewSkin.DAY_OF_WEEK"));
    private ToggleButton weekDayMondayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_MONDAY"));
    private ToggleButton weekDayTuesdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_TUESDAY"));
    private ToggleButton weekDayWednesdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_WEDNESDAY"));
    private ToggleButton weekDayThursdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_THURSDAY"));
    private ToggleButton weekDayFridayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_FRIDAY"));
    private ToggleButton weekDaySaturdayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_SATURDAY"));
    private ToggleButton weekDaySundayButton = new ToggleButton(Messages.getString("RecurrenceViewSkin.SHORT_SUNDAY"));
    private HBox weekdayBox;
    private HBox repeatByBox;
    private HBox repeatCountBox;
    private Label labelRepeatOn;
    private Label summary = new Label();
    private Label labelRepeatBy;
    private Label frequencyLabel;
    private Label repeatCountLabel;
    private Label startsOnLabel;
    private Label endsOnLabel;
    private HBox endsAfterBox;
    private HBox endsOnBox;
    private GridPane grid;
    private SpinnerValueFactory.IntegerSpinnerValueFactory repeatCountSpinnerValueFactory;
    private SpinnerValueFactory.IntegerSpinnerValueFactory endsAfterCounterSpinnerValueFactory;

    public RecurrenceViewSkin(RecurrenceView view) {
        super((Control)view);
        this.summary.setMaxWidth(250.0);
        this.summary.setWrapText(true);
        this.frequencyBox.getItems().setAll((Object[])Frequency.values());
        this.frequencyBox.setValue((Object)Frequency.DAILY);
        this.frequencyBox.setConverter((StringConverter)new StringConverter<Frequency>(){

            public String toString(Frequency frequency) {
                switch (frequency) {
                    case DAILY: {
                        return Messages.getString("RecurrenceViewSkin.DAILY");
                    }
                    case MONTHLY: {
                        return Messages.getString("RecurrenceViewSkin.MONTHLY");
                    }
                    case WEEKLY: {
                        return Messages.getString("RecurrenceViewSkin.WEEKLY");
                    }
                    case YEARLY: {
                        return Messages.getString("RecurrenceViewSkin.YEARLY");
                    }
                }
                return "";
            }

            public Frequency fromString(String txt) {
                return null;
            }
        });
        this.repeatCountSpinnerValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 100);
        this.repeatCountSpinner.setValueFactory((SpinnerValueFactory)this.repeatCountSpinnerValueFactory);
        this.repeatCountSpinner.setEditable(true);
        this.repeatCountSpinner.getEditor().setPrefColumnCount(5);
        this.endsAfterCounterSpinnerValueFactory = new SpinnerValueFactory.IntegerSpinnerValueFactory(1, 1000);
        this.endsAfterCounterSpinner.setValueFactory((SpinnerValueFactory)this.endsAfterCounterSpinnerValueFactory);
        this.endsAfterCounterSpinner.setEditable(true);
        this.endsAfterCounterSpinner.getEditor().setPrefColumnCount(5);
        this.endsAfterCounterSpinner.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.endsAfterButton.selectedProperty()));
        this.endsAfterOccurencesLabel.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.endsAfterButton.selectedProperty()));
        this.endsOnDatePicker.disableProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)this.endsOnButton.selectedProperty()));
        this.endsOnDatePicker.getEditor().setPrefColumnCount(14);
        ToggleGroup endsByGroup = new ToggleGroup();
        endsByGroup.getToggles().setAll((Object[])new Toggle[]{this.endsAfterButton, this.endsNeverButton, this.endsOnButton});
        ToggleGroup repeatByGroup = new ToggleGroup();
        repeatByGroup.getToggles().setAll((Object[])new Toggle[]{this.repeatByDayOfTheMonth, this.repeatByDayOfTheWeek});
        ToggleGroup endsGroup = new ToggleGroup();
        endsGroup.getToggles().setAll((Object[])new Toggle[]{this.endsOnButton, this.endsAfterButton, this.endsNeverButton});
        this.repeatCountBox = new HBox();
        this.repeatCountBox.getStyleClass().add((Object)"repeat-count-box");
        this.repeatCountBox.getChildren().setAll((Object[])new Node[]{this.repeatCountSpinner, this.repeatCountGranularity});
        this.weekdayBox = new HBox();
        this.weekdayBox.getStyleClass().add((Object)"weekday-box");
        this.weekdayBox.getChildren().setAll((Object[])new Node[]{this.weekDayMondayButton, this.weekDayTuesdayButton, this.weekDayWednesdayButton, this.weekDayThursdayButton, this.weekDayFridayButton, this.weekDaySaturdayButton, this.weekDaySundayButton});
        this.repeatByBox = new HBox();
        this.repeatByBox.getStyleClass().add((Object)"repeat-by-box");
        this.repeatByBox.getChildren().setAll((Object[])new Node[]{this.repeatByDayOfTheMonth, this.repeatByDayOfTheWeek});
        this.endsAfterBox = new HBox();
        this.endsAfterBox.getStyleClass().add((Object)"ends-after-box");
        this.endsAfterBox.getChildren().setAll((Object[])new Node[]{this.endsAfterButton, this.endsAfterCounterSpinner, this.endsAfterOccurencesLabel});
        this.endsOnBox = new HBox();
        this.endsOnBox.getStyleClass().add((Object)"ends-on-box");
        this.endsOnBox.getChildren().setAll((Object[])new Node[]{this.endsOnButton, this.endsOnDatePicker});
        this.grid = new GridPane();
        this.grid.getStyleClass().add((Object)"container");
        ColumnConstraints labelsColumn = new ColumnConstraints();
        ColumnConstraints fieldsColumn = new ColumnConstraints();
        labelsColumn.setHalignment(HPos.RIGHT);
        labelsColumn.setPrefWidth(-1.0);
        this.grid.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{labelsColumn, fieldsColumn});
        this.frequencyLabel = new Label(Messages.getString("RecurrenceViewSkin.FREQUENCY"));
        this.repeatCountLabel = new Label(Messages.getString("RecurrenceViewSkin.REPEAT_EVERY"));
        this.labelRepeatOn = new Label(Messages.getString("RecurrenceViewSkin.REPEAT_ON"));
        this.labelRepeatBy = new Label(Messages.getString("RecurrenceViewSkin.REPEAT_BY"));
        this.startsOnLabel = new Label(Messages.getString("RecurrenceViewSkin.STARTS_ON"));
        this.endsOnLabel = new Label(Messages.getString("RecurrenceViewSkin.ENDS"));
        this.summaryLabel = new Label(Messages.getString("RecurrenceViewSkin.SUMMARY"));
        this.grid.add((Node)this.frequencyLabel, 0, 0);
        this.grid.add(this.frequencyBox, 1, 0);
        this.grid.add((Node)this.repeatCountLabel, 0, 1);
        this.grid.add((Node)this.repeatCountBox, 1, 1);
        this.buildGrid();
        this.frequencyBox.setMaxWidth(Double.MAX_VALUE);
        GridPane.setFillWidth(this.frequencyBox, (Boolean)true);
        this.getChildren().add((Object)this.grid);
        InvalidationListener updateListener = it -> this.updateRule();
        this.frequencyBox.valueProperty().addListener(updateListener);
        this.frequencyBox.valueProperty().addListener(it -> this.buildGrid());
        this.repeatCountSpinner.valueProperty().addListener(updateListener);
        this.weekDayMondayButton.selectedProperty().addListener(updateListener);
        this.weekDayTuesdayButton.selectedProperty().addListener(updateListener);
        this.weekDayWednesdayButton.selectedProperty().addListener(updateListener);
        this.weekDayThursdayButton.selectedProperty().addListener(updateListener);
        this.weekDayFridayButton.selectedProperty().addListener(updateListener);
        this.weekDaySaturdayButton.selectedProperty().addListener(updateListener);
        this.weekDaySundayButton.selectedProperty().addListener(updateListener);
        this.repeatByDayOfTheMonth.selectedProperty().addListener(updateListener);
        this.repeatByDayOfTheWeek.selectedProperty().addListener(updateListener);
        this.endsNeverButton.selectedProperty().addListener(updateListener);
        this.endsAfterButton.selectedProperty().addListener(updateListener);
        this.endsAfterCounterSpinner.valueProperty().addListener(updateListener);
        this.endsOnButton.selectedProperty().addListener(updateListener);
        this.endsOnDatePicker.valueProperty().addListener(updateListener);
        ((RecurrenceView)this.getSkinnable()).showSummaryProperty().addListener(it -> this.buildGrid());
        view.recurrenceRuleProperty().addListener(it -> this.updateView());
        this.updateView();
    }

    private void buildGrid() {
        this.grid.getChildren().removeIf(node -> node != this.frequencyLabel && node != this.frequencyBox && node != this.repeatCountLabel && node != this.repeatCountBox);
        int row = 2;
        if (((Frequency)((Object)this.frequencyBox.getValue())).equals((Object)Frequency.WEEKLY)) {
            this.grid.add((Node)this.labelRepeatOn, 0, row);
            this.grid.add((Node)this.weekdayBox, 1, row);
            ++row;
        }
        if (((Frequency)((Object)this.frequencyBox.getValue())).equals((Object)Frequency.MONTHLY)) {
            this.grid.add((Node)this.labelRepeatBy, 0, row);
            this.grid.add((Node)this.repeatByBox, 1, row);
            ++row;
        }
        this.grid.add((Node)this.startsOnLabel, 0, row);
        this.grid.add((Node)this.startOnDateLabel, 1, row);
        this.grid.add((Node)this.endsOnLabel, 0, ++row);
        this.grid.add((Node)this.endsNeverButton, 1, row);
        this.grid.add((Node)this.endsAfterBox, 1, ++row);
        this.grid.add((Node)this.endsOnBox, 1, ++row);
        ++row;
        if (((RecurrenceView)this.getSkinnable()).isShowSummary()) {
            this.grid.add((Node)this.summaryLabel, 0, row);
            this.grid.add((Node)this.summary, 1, row);
        }
    }

    private void updateView() {
        try {
            String rule = ((RecurrenceView)this.getSkinnable()).getRecurrenceRule();
            if (rule == null) {
                return;
            }
            RRule rrule = new RRule(rule);
            switch (rrule.getFreq()) {
                case DAILY: {
                    this.frequencyBox.setValue((Object)Frequency.DAILY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.DAYS"));
                    break;
                }
                case WEEKLY: {
                    this.frequencyBox.setValue((Object)Frequency.WEEKLY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.32"));
                    break;
                }
                case MONTHLY: {
                    this.frequencyBox.setValue((Object)Frequency.MONTHLY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.MONTHS"));
                    break;
                }
                case YEARLY: {
                    this.frequencyBox.setValue((Object)Frequency.YEARLY);
                    this.repeatCountGranularity.setText(Messages.getString("RecurrenceViewSkin.YEARS"));
                    break;
                }
                case SECONDLY: 
                case HOURLY: 
                case MINUTELY: {
                    throw new IllegalArgumentException("unsupported frequency: " + rrule.getFreq());
                }
                default: {
                    throw new IllegalArgumentException("unknown frequency: " + rrule.getFreq());
                }
            }
            DateValue until = rrule.getUntil();
            if (until != null) {
                this.endsOnButton.setSelected(true);
                this.endsOnDatePicker.setValue((Object)LocalDate.of(until.year(), until.month(), until.day()));
            } else if (rrule.getCount() > 0) {
                this.endsAfterButton.setSelected(true);
            } else {
                this.endsNeverButton.setSelected(true);
            }
            if (rrule.getByMonthDay().length > 0) {
                this.repeatByDayOfTheMonth.setSelected(true);
            } else {
                this.repeatByDayOfTheWeek.setSelected(true);
            }
            this.repeatCountSpinnerValueFactory.setValue((Object)rrule.getInterval());
            this.endsAfterCounterSpinnerValueFactory.setValue((Object)rrule.getCount());
            List days = rrule.getByDay();
            this.weekDayMondayButton.setSelected(this.isSelected(Weekday.MO, days));
            this.weekDayTuesdayButton.setSelected(this.isSelected(Weekday.TU, days));
            this.weekDayWednesdayButton.setSelected(this.isSelected(Weekday.WE, days));
            this.weekDayThursdayButton.setSelected(this.isSelected(Weekday.TH, days));
            this.weekDayFridayButton.setSelected(this.isSelected(Weekday.FR, days));
            this.weekDaySaturdayButton.setSelected(this.isSelected(Weekday.SA, days));
            this.weekDaySundayButton.setSelected(this.isSelected(Weekday.SU, days));
            this.summary.setText(Util.convertRFC2445ToText(rule, ((RecurrenceView)this.getSkinnable()).getStartDate()));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        this.startOnDateLabel.setText(DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG).format(((RecurrenceView)this.getSkinnable()).getStartDate()));
    }

    private boolean isSelected(Weekday day, List<WeekdayNum> days) {
        for (WeekdayNum num : days) {
            if (!num.wday.equals((Object)day)) continue;
            return true;
        }
        return false;
    }

    private void updateRule() {
        RRule rule = new RRule();
        switch ((Frequency)((Object)this.frequencyBox.getValue())) {
            case DAILY: {
                rule.setFreq(com.google.ical.values.Frequency.DAILY);
                break;
            }
            case MONTHLY: {
                rule.setFreq(com.google.ical.values.Frequency.MONTHLY);
                break;
            }
            case WEEKLY: {
                rule.setFreq(com.google.ical.values.Frequency.WEEKLY);
                break;
            }
            case YEARLY: {
                rule.setFreq(com.google.ical.values.Frequency.YEARLY);
                break;
            }
        }
        int interval = (Integer)this.repeatCountSpinner.getValue();
        if (interval > 1) {
            rule.setInterval(interval);
        } else {
            rule.setInterval(0);
        }
        if (this.endsOnButton.isSelected()) {
            LocalDate date = (LocalDate)this.endsOnDatePicker.getValue();
            rule.setUntil((DateValue)new DateValueImpl(date.getYear(), date.getMonthValue(), date.getDayOfMonth()));
        }
        if (this.endsAfterButton.isSelected()) {
            rule.setCount(((Integer)this.endsAfterCounterSpinner.getValue()).intValue());
        }
        if (rule.getFreq().equals((Object)com.google.ical.values.Frequency.MONTHLY)) {
            if (this.repeatByDayOfTheMonth.isSelected()) {
                rule.setByMonthDay(new int[]{((RecurrenceView)this.getSkinnable()).getStartDate().getDayOfMonth()});
            } else {
                LocalDate localDate = ((RecurrenceView)this.getSkinnable()).getStartDate();
                ZonedDateTime zonedDateTime = ZonedDateTime.of(localDate, LocalTime.now(), ZoneId.systemDefault());
                int hits = 1;
                ZonedDateTime current = zonedDateTime.withDayOfMonth(1);
                do {
                    if (!current.getDayOfWeek().equals(zonedDateTime.getDayOfWeek())) continue;
                    ++hits;
                } while ((current = current.plusDays(1L)).toLocalDate().isBefore(localDate));
                ArrayList<WeekdayNum> weekdays = new ArrayList<WeekdayNum>();
                switch (zonedDateTime.getDayOfWeek()) {
                    case FRIDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.FR));
                        break;
                    }
                    case MONDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.MO));
                        break;
                    }
                    case SATURDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.SA));
                        break;
                    }
                    case SUNDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.SU));
                        break;
                    }
                    case THURSDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.TH));
                        break;
                    }
                    case TUESDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.TU));
                        break;
                    }
                    case WEDNESDAY: {
                        weekdays.add(new WeekdayNum(hits, Weekday.WE));
                        break;
                    }
                }
                rule.setByDay(weekdays);
            }
        }
        if (rule.getFreq().equals((Object)com.google.ical.values.Frequency.WEEKLY)) {
            ArrayList<WeekdayNum> weekdays = new ArrayList<WeekdayNum>();
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.MO), this.weekDayMondayButton);
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.TU), this.weekDayTuesdayButton);
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.WE), this.weekDayWednesdayButton);
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.TH), this.weekDayThursdayButton);
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.FR), this.weekDayFridayButton);
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.SA), this.weekDaySaturdayButton);
            this.maybeAddWeekday(weekdays, new WeekdayNum(0, Weekday.SU), this.weekDaySundayButton);
            rule.setByDay(weekdays);
        }
        ((RecurrenceView)this.getSkinnable()).setRecurrenceRule(rule.toIcal());
        if (LoggingDomain.RECURRENCE.isLoggable(Level.FINE)) {
            LoggingDomain.RECURRENCE.fine("test dumping 10 recurrences starting with today's date");
            try {
                LocalDateIterator iterator = LocalDateIteratorFactory.createLocalDateIterator((String)rule.toIcal(), (org.joda.time.LocalDate)new org.joda.time.LocalDate(2015, 8, 18), (boolean)true);
                int counter = 0;
                while (iterator.hasNext()) {
                    org.joda.time.LocalDate repeatingDate = (org.joda.time.LocalDate)iterator.next();
                    LoggingDomain.RECURRENCE.fine(repeatingDate.toString());
                    if (++counter != 10) continue;
                    break;
                }
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    private void maybeAddWeekday(List<WeekdayNum> weekdays, WeekdayNum weekdayNum, ToggleButton button) {
        if (button.isSelected()) {
            weekdays.add(weekdayNum);
        }
    }

    static enum Frequency {
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }
}

