/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.Messages;
import com.calendarfx.view.MonthEntryView;
import java.text.MessageFormat;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.shape.Circle;

public class MonthEntryViewSkin
extends SkinBase<MonthEntryView> {
    private Label titleLabel;
    private Label timeLabel;
    private Circle colorDot;
    private InvalidationListener updateViewListener = it -> this.updateView();
    private WeakInvalidationListener weakUpdateViewListener = new WeakInvalidationListener(this.updateViewListener);

    public MonthEntryViewSkin(MonthEntryView view) {
        super((Control)view);
        Entry<?> entry = view.getEntry();
        if (entry.isRecurrence()) {
            entry = entry.getRecurrenceSourceEntry();
        }
        Calendar calendar = entry.getCalendar();
        this.colorDot = new Circle();
        this.colorDot.setRadius(2.5);
        this.colorDot.setMouseTransparent(true);
        this.titleLabel = new Label();
        this.titleLabel.setGraphic((Node)this.colorDot);
        this.titleLabel.setMinSize(0.0, 0.0);
        this.titleLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.titleLabel.setMouseTransparent(true);
        this.timeLabel = new Label();
        this.timeLabel.setMouseTransparent(true);
        this.timeLabel.setMaxHeight(Double.MAX_VALUE);
        this.timeLabel.setMouseTransparent(true);
        entry.titleProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        entry.fullDayProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        entry.intervalProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        entry.calendarProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        view.positionProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        if (calendar != null) {
            calendar.styleProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        }
        this.getChildren().addAll((Object[])new Node[]{this.titleLabel, this.timeLabel});
        this.updateView();
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double pw = 0.0;
        if (contentWidth > 120.0) {
            pw = this.timeLabel.prefWidth(-1.0);
            this.timeLabel.resizeRelocate(this.snapPosition(contentX + contentWidth - pw), this.snapPosition(contentY), this.snapSize(pw), this.snapSize(contentHeight));
            this.titleLabel.resizeRelocate(this.snapPosition(contentX), this.snapPosition(contentY), this.snapSize(contentWidth - pw), this.snapSize(contentHeight));
            this.timeLabel.setVisible(true);
        } else {
            this.titleLabel.resizeRelocate(this.snapPosition(contentX), this.snapPosition(contentY), this.snapSize(contentWidth - pw), this.snapSize(contentHeight));
            this.timeLabel.setVisible(false);
        }
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return Math.max(this.titleLabel.prefHeight(-1.0), this.timeLabel.prefHeight(-1.0)) + topInset + bottomInset;
    }

    private void updateView() {
        block17: {
            Entry<?> entry;
            block18: {
                MonthEntryView view = (MonthEntryView)this.getSkinnable();
                entry = view.getEntry();
                Calendar calendar = entry.getCalendar();
                if (entry.isRecurrence()) {
                    entry = entry.getRecurrenceSourceEntry();
                }
                ObservableList styleClass = view.getStyleClass();
                styleClass.setAll((Object[])new String[]{"month-entry-view", "default-style-entry-small"});
                if (calendar != null) {
                    styleClass.add((Object)(calendar.getStyle() + "-entry-small"));
                }
                if (entry.isFullDay() || entry.isMultiDay()) {
                    styleClass.add((Object)"default-style-entry-small-full-day");
                    if (calendar != null) {
                        styleClass.add((Object)(calendar.getStyle() + "-entry-small-full-day"));
                    }
                }
                this.colorDot.setVisible(!entry.isFullDay() && !entry.isMultiDay());
                if (calendar != null) {
                    this.colorDot.getStyleClass().setAll((Object[])new String[]{"default-style-icon-small", calendar.getStyle() + "-icon-small"});
                    this.titleLabel.getStyleClass().setAll((Object[])new String[]{"default-style-entry-small-title-label", calendar.getStyle() + "-entry-small-title-label"});
                    this.timeLabel.getStyleClass().setAll((Object[])new String[]{"default-style-entry-small-time-label", calendar.getStyle() + "-entry-small-time-label"});
                    if (entry.isMultiDay() || entry.isFullDay()) {
                        this.titleLabel.getStyleClass().addAll((Object[])new String[]{"default-style-entry-small-title-label-full-day", calendar.getStyle() + "-entry-small-title-label-full-day"});
                        this.timeLabel.getStyleClass().addAll((Object[])new String[]{"default-style-entry-small-time-label-full-day", calendar.getStyle() + "-entry-small-time-label-full-day"});
                    }
                } else {
                    this.colorDot.getStyleClass().setAll((Object[])new String[]{"default-style-icon-small"});
                    this.titleLabel.getStyleClass().setAll((Object[])new String[]{"default-style-entry-small-title-label"});
                    this.timeLabel.getStyleClass().setAll((Object[])new String[]{"default-style-entry-small-time-label"});
                    if (entry.isMultiDay() || entry.isFullDay()) {
                        this.titleLabel.getStyleClass().addAll((Object[])new String[]{"default-style-entry-small-title-label-full-day"});
                        this.timeLabel.getStyleClass().addAll((Object[])new String[]{"default-style-entry-small-time-label-full-day"});
                    }
                }
                if (entry.isFullDay()) {
                    this.timeLabel.setText("");
                }
                switch (view.getPosition()) {
                    case FIRST: 
                    case ONLY: {
                        this.titleLabel.setText(entry.getTitle());
                        if (entry.isFullDay() || entry.isMultiDay()) break;
                        this.titleLabel.setGraphic((Node)this.colorDot);
                        break;
                    }
                    default: {
                        this.titleLabel.setText(" ");
                        this.titleLabel.setGraphic(null);
                    }
                }
                styleClass.add((Object)("default-style-entry-small-" + view.getPosition().toString().toLowerCase()));
                if (entry.isFullDay()) break block17;
                if (!entry.isMultiDay()) break block18;
                switch (view.getPosition()) {
                    case LAST: {
                        this.timeLabel.setText(MessageFormat.format(Messages.getString("MonthEntryViewSkin.ENDS_AT"), DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(entry.getEndTime())));
                        break;
                    }
                    case FIRST: {
                        if (view.getStartDate().equals(entry.getStartDate())) {
                            this.timeLabel.setText(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(entry.getStartTime()));
                            break;
                        }
                        break block17;
                    }
                    default: {
                        this.timeLabel.setText("");
                        break;
                    }
                }
                break block17;
            }
            this.timeLabel.setText(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(entry.getStartTime()));
        }
    }
}

