/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DayViewBaseSkin;
import impl.com.calendarfx.view.DayViewEditController;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.ViewHelper;
import impl.com.calendarfx.view.WeekDayViewSkin;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.Resolver;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.animation.FadeTransition;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.transformation.FilteredList;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.Region;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Line;
import javafx.util.Callback;
import javafx.util.Duration;

public class DayViewSkin<T extends DayView>
extends DayViewBaseSkin<T>
implements LoadDataSettingsProvider {
    private List<Line> lines = new ArrayList<Line>();
    private DataLoader dataLoader = new DataLoader(this);
    private Circle currentTimeCircle;
    private Line currentTimeLine;
    private DayEntryView draggedEntryView;
    private Region earlyHoursRegion;
    private Region lateHoursRegion;
    private LocalDate displayedDate;
    private InvalidationListener layoutListener = it -> ((DayView)this.getSkinnable()).requestLayout();
    private WeakInvalidationListener weakLayoutListener = new WeakInvalidationListener(this.layoutListener);

    public DayViewSkin(T view) {
        super(view);
        this.earlyHoursRegion = new Region();
        this.earlyHoursRegion.setMouseTransparent(true);
        this.earlyHoursRegion.getStyleClass().add((Object)"early-hours-region");
        this.earlyHoursRegion.setManaged(false);
        this.getChildren().add((Object)this.earlyHoursRegion);
        this.lateHoursRegion = new Region();
        this.lateHoursRegion.setMouseTransparent(true);
        this.lateHoursRegion.getStyleClass().add((Object)"late-hours-region");
        this.lateHoursRegion.setManaged(false);
        this.getChildren().add((Object)this.lateHoursRegion);
        for (int i = 1; i < 24; ++i) {
            this.createLine("half-hour-line");
            this.createLine("full-hour-line");
        }
        this.createLine("half-hour-line");
        this.currentTimeCircle = new Circle(4.0);
        this.currentTimeCircle.getStyleClass().add((Object)"current-time-circle");
        this.currentTimeCircle.setManaged(false);
        this.currentTimeCircle.setMouseTransparent(true);
        this.currentTimeCircle.setOpacity(0.0);
        this.currentTimeCircle.visibleProperty().bind((ObservableValue)((DayViewBase)view).enableCurrentTimeMarkerProperty());
        this.getChildren().add((Object)this.currentTimeCircle);
        this.currentTimeLine = new Line();
        this.currentTimeLine.getStyleClass().add((Object)"current-time-line");
        this.currentTimeLine.setManaged(false);
        this.currentTimeLine.setMouseTransparent(true);
        this.currentTimeLine.setOpacity(0.0);
        this.currentTimeLine.visibleProperty().bind((ObservableValue)((DayViewBase)view).enableCurrentTimeMarkerProperty());
        this.getChildren().add((Object)this.currentTimeLine);
        if (!(this instanceof WeekDayViewSkin)) {
            new DayViewEditController((DayViewBase)view);
        }
        this.setupCurrentTimeMarkerSupport();
        ((DateControl)((Object)view)).draggedEntryProperty().addListener(it -> this.addOrRemoveDraggedEntryView());
        ((DayViewBase)view).showCurrentTimeMarkerProperty().addListener(it -> this.updateTimelineVisibility());
        ((DayViewBase)view).showCurrentTimeTodayMarkerProperty().addListener(it -> this.updateTimelineVisibility());
        ((DateControl)((Object)view)).layoutProperty().addListener(it -> view.requestLayout());
        this.updateShowMarkers();
        this.updateTimelineVisibility();
        ((DateControl)((Object)view)).dateProperty().addListener(it -> {
            if (this.displayedDate == null || !this.displayedDate.equals(view.getDate())) {
                this.loadData("date changed");
            }
        });
        ((DateControl)((Object)view)).suspendUpdatesProperty().addListener(evt -> this.loadData("suspend updates was set to false"));
        ((DateControl)((Object)view)).getCalendars().addListener(obs -> this.loadData("list of calendars changed"));
        this.updateLineStyling();
        InvalidationListener styleLinesListener = it -> this.updateLineStyling();
        ((DateControl)((Object)view)).startTimeProperty().addListener(styleLinesListener);
        ((DateControl)((Object)view)).endTimeProperty().addListener(styleLinesListener);
        ((DayViewBase)view).earlyLateHoursStrategyProperty().addListener(styleLinesListener);
        this.loadData("initial data loading");
    }

    @Override
    protected void calendarVisibilityChanged() {
        ((DayView)this.getSkinnable()).requestLayout();
    }

    @Override
    protected void refreshData() {
        this.loadData("refreshData() was called");
    }

    private void updateTimelineVisibility() {
        double lineOpacity = ((DayView)this.getSkinnable()).isShowCurrentTimeMarker() ? 1.0 : 0.0;
        FadeTransition lineTransition = new FadeTransition(Duration.millis((double)600.0), (Node)this.currentTimeLine);
        lineTransition.setToValue(lineOpacity);
        lineTransition.play();
        double circleOpacity = ((DayView)this.getSkinnable()).isShowCurrentTimeTodayMarker() ? 1.0 : 0.0;
        FadeTransition circleTransition = new FadeTransition(Duration.millis((double)600.0), (Node)this.currentTimeCircle);
        circleTransition.setToValue(circleOpacity);
        circleTransition.play();
    }

    private void setupCurrentTimeMarkerSupport() {
        DayView view = (DayView)this.getSkinnable();
        InvalidationListener listener = evt -> this.updateShowMarkers();
        view.dateProperty().addListener(listener);
        view.todayProperty().addListener(listener);
    }

    private void updateShowMarkers() {
        DayView view = (DayView)this.getSkinnable();
        view.getProperties().put((Object)"show.current.time.marker", (Object)this.isShowingTimeMarker());
        view.getProperties().put((Object)"show.current.time.today.marker", (Object)this.isShowingTimeTodayMarker());
    }

    protected boolean isShowingTimeMarker() {
        return ((DayView)this.getSkinnable()).getDate().equals(((DayView)this.getSkinnable()).getToday());
    }

    protected boolean isShowingTimeTodayMarker() {
        return this.isShowingTimeMarker();
    }

    private void addOrRemoveDraggedEntryView() {
        DayView view = (DayView)this.getSkinnable();
        DraggedEntry draggedEntry = view.getDraggedEntry();
        if (draggedEntry != null) {
            this.draggedEntryView = this.doAddEntryView(draggedEntry);
            this.draggedEntryView.toFront();
            this.draggedEntryView.setMouseTransparent(true);
            this.draggedEntryView.getProperties().put((Object)"selected", (Object)true);
            draggedEntry.intervalProperty().addListener((InvalidationListener)this.weakLayoutListener);
        } else if (this.draggedEntryView != null) {
            this.removeEntryView(this.draggedEntryView.getEntry());
            this.draggedEntryView = null;
        }
        view.requestLayout();
    }

    private void loadData(String reason) {
        if (((DayView)this.getSkinnable()).isSuspendUpdates()) {
            return;
        }
        this.updateEntries(reason);
    }

    private void createLine(String styleClass) {
        Line line = new Line();
        line.setManaged(false);
        line.getStyleClass().add((Object)styleClass);
        line.setMouseTransparent(true);
        this.lines.add(line);
        this.getChildren().add((Object)line);
    }

    private void updateLineStyling() {
        DayView dayView = (DayView)this.getSkinnable();
        LocalTime startTime = dayView.getStartTime();
        LocalTime endTime = dayView.getEndTime();
        boolean showEarlyHoursRegion = startTime.isAfter(LocalTime.MIN);
        boolean showLateHoursRegion = endTime.isBefore(LocalTime.MAX);
        this.earlyHoursRegion.setVisible(showEarlyHoursRegion);
        this.lateHoursRegion.setVisible(showLateHoursRegion);
        int lineCount = this.lines.size();
        block5: for (int i = 0; i < lineCount; ++i) {
            LocalTime time;
            boolean halfHourLine;
            Line line = this.lines.get(i);
            line.getStyleClass().removeAll((Object[])new String[]{"early-hour-line", "late-hour-line"});
            int hour = (i + 1) / 2;
            int minute = 0;
            boolean bl = halfHourLine = i % 2 == 0;
            if (halfHourLine) {
                minute = 30;
            }
            if ((time = LocalTime.of(hour, minute)).isBefore(startTime) && !line.getStyleClass().contains((Object)"early-hour-line")) {
                line.getStyleClass().add((Object)"early-hour-line");
            }
            if (time.isAfter(endTime) && !line.getStyleClass().contains((Object)"late-hour-line")) {
                line.getStyleClass().add((Object)"late-hour-line");
            }
            switch (dayView.getEarlyLateHoursStrategy()) {
                case HIDE: {
                    if (time.isBefore(startTime) || time.equals(startTime) || time.isAfter(endTime) || time.equals(endTime)) {
                        line.setVisible(false);
                        continue block5;
                    }
                    line.setVisible(true);
                    continue block5;
                }
                case SHOW: {
                    line.setVisible(true);
                    continue block5;
                }
                case SHOW_COMPRESSED: {
                    if (halfHourLine) {
                        line.setVisible(false);
                        continue block5;
                    }
                    line.setVisible(true);
                    continue block5;
                }
            }
        }
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        int lineCount = this.lines.size();
        DayView dayView = (DayView)this.getSkinnable();
        LocalTime startTime = dayView.getStartTime();
        LocalTime endTime = dayView.getEndTime();
        boolean showEarlyHoursRegion = startTime.isAfter(LocalTime.MIN);
        boolean showLateHoursRegion = endTime.isBefore(LocalTime.MAX);
        this.earlyHoursRegion.setVisible(showEarlyHoursRegion);
        this.lateHoursRegion.setVisible(showLateHoursRegion);
        double earlyHoursY = ViewHelper.getTimeLocation(dayView, startTime);
        double lateHoursY = ViewHelper.getTimeLocation(dayView, endTime);
        this.earlyHoursRegion.resizeRelocate(this.snapPosition(contentX), this.snapPosition(contentY), this.snapSize(contentWidth), this.snapSize(earlyHoursY));
        this.lateHoursRegion.resizeRelocate(this.snapPosition(contentX), this.snapPosition(lateHoursY), this.snapSize(contentWidth), this.snapSize(contentHeight - lateHoursY));
        for (int i = 0; i < lineCount; ++i) {
            boolean halfHourLine;
            Line line = this.lines.get(i);
            int hour = (i + 1) / 2;
            int minute = 0;
            boolean bl = halfHourLine = i % 2 == 0;
            if (halfHourLine) {
                minute = 30;
            }
            LocalTime time = LocalTime.of(hour, minute);
            double yy = this.snapPosition(contentY + ViewHelper.getTimeLocation(dayView, time));
            line.setStartX(this.snapPosition(contentX + 4.0));
            line.setStartY(yy);
            line.setEndX(this.snapPosition(contentX + contentWidth - 4.0));
            line.setEndY(yy);
        }
        if (this.draggedEntryView != null) {
            boolean showing = this.isRelevant(this.draggedEntryView.getEntry());
            this.draggedEntryView.setVisible(showing);
        }
        switch (dayView.getLayout()) {
            case STANDARD: {
                this.layoutStandard(dayView, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            case SWIMLANE: {
                this.layoutSwimlane(dayView, contentX, contentY, contentWidth, contentHeight);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown layout: " + (Object)((Object)dayView.getLayout()));
            }
        }
        LocalTime time = dayView.getTime();
        double y = this.snapPosition(contentY + ViewHelper.getTimeLocation(dayView, time));
        this.currentTimeLine.setStartX(this.snapPosition(contentX));
        this.currentTimeLine.setStartY(this.snapPosition(y));
        this.currentTimeLine.setEndX(this.snapPosition(contentX + contentWidth));
        this.currentTimeLine.setEndY(this.snapPosition(y));
        this.currentTimeLine.toFront();
        this.currentTimeCircle.setCenterX(this.snapPosition(contentX + this.currentTimeCircle.getRadius() + 4.0));
        this.currentTimeCircle.setCenterY(y);
        this.currentTimeCircle.toFront();
    }

    private void layoutStandard(DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        List<DayEntryView> entryViews = this.getChildren().stream().filter(node -> node instanceof DayEntryView).map(node -> (DayEntryView)node).collect(Collectors.toList());
        this.layoutEntryViews(entryViews, dayView, contentX, contentY, contentWidth, contentHeight);
    }

    private void layoutSwimlane(DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        FilteredList visibleCalendars = dayView.getCalendars().filtered(c -> ((DayView)this.getSkinnable()).isCalendarVisible((Calendar)c));
        double x = contentX;
        double w = contentWidth / (double)visibleCalendars.size();
        for (Calendar calendar : visibleCalendars) {
            List<DayEntryView> entryViews = this.getChildren().stream().filter(node -> node instanceof DayEntryView).map(node -> (DayEntryView)node).filter(view -> {
                Calendar cal;
                Entry<?> entry = view.getEntry();
                if (entry instanceof DraggedEntry) {
                    DraggedEntry draggedEntry = (DraggedEntry)view.getEntry();
                    cal = draggedEntry.getOriginalCalendar();
                } else {
                    cal = entry.getCalendar();
                }
                return cal != null && cal.equals(calendar);
            }).collect(Collectors.toList());
            this.layoutEntryViews(entryViews, dayView, x, contentY, w, contentHeight);
            x += w;
        }
    }

    private void layoutEntryViews(List<DayEntryView> entryViews, DayView dayView, double contentX, double contentY, double contentWidth, double contentHeight) {
        List<Placement> placements = Resolver.resolve(entryViews);
        if (placements != null) {
            contentWidth = contentWidth * dayView.getEntryWidthPercentage() / 100.0;
            for (Placement placement : placements) {
                LocalDate endDate;
                EntryViewBase<?> view = placement.getEntryView();
                Entry<?> entry = view.getEntry();
                LocalDate viewDate = dayView.getDate();
                LocalTime viewStartTime = entry.getStartTime();
                LocalTime viewEndTime = entry.getEndTime();
                double y1 = ViewHelper.getTimeLocation(dayView, entry.getStartTime());
                double y2 = ViewHelper.getTimeLocation(dayView, entry.getEndTime());
                boolean startsBefore = false;
                boolean endsAfter = false;
                LocalDate startDate = entry.getStartDate();
                if (startDate.isBefore(dayView.getDate())) {
                    y1 = contentY;
                    viewStartTime = dayView.getStartTime();
                    startsBefore = true;
                }
                if ((endDate = entry.getEndDate()).isAfter(dayView.getDate())) {
                    y2 = contentHeight;
                    viewEndTime = dayView.getEndTime();
                    endsAfter = true;
                }
                EntryViewBase.Position position = EntryViewBase.Position.ONLY;
                if (startsBefore && endsAfter) {
                    position = EntryViewBase.Position.MIDDLE;
                } else if (startsBefore) {
                    position = EntryViewBase.Position.LAST;
                } else if (endsAfter) {
                    position = EntryViewBase.Position.FIRST;
                }
                view.getProperties().put((Object)"position", (Object)position);
                view.getProperties().put((Object)"startDate", (Object)viewDate);
                view.getProperties().put((Object)"endDate", (Object)viewDate);
                view.getProperties().put((Object)"startTime", (Object)viewStartTime);
                view.getProperties().put((Object)"endTime", (Object)viewEndTime);
                double minHeight = view.minHeight(contentWidth);
                double columnWidth = contentWidth / (double)placement.getColumnCount();
                double x = contentX + (double)placement.getColumnIndex() * columnWidth;
                view.resizeRelocate(this.snapPosition(x), this.snapPosition(y1), this.snapSize(columnWidth), this.snapSize(Math.max(minHeight, y2 - y1 - 2.0)));
            }
        }
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        if (!((DayView)this.getSkinnable()).isSuspendUpdates()) {
            this.loadData("changes in calendar " + calendar.getName());
        }
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            return;
        }
        if (evt.isEntryRemoved()) {
            this.removeEntryView(entry);
            ((DayView)this.getSkinnable()).requestLayout();
        }
        if (evt.isEntryAdded() && this.isRelevant(entry)) {
            this.addEntryView(entry);
        }
        if (this.isRelevant(entry)) {
            ((DayView)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            if (entry.isFullDay()) {
                this.removeEntryView(entry);
            } else {
                this.addEntryView(entry);
            }
            ((DayView)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            return;
        }
        this.removeEntryView(entry);
        this.addEntryView(entry);
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (entry.isFullDay()) {
            return;
        }
        this.removeEntryView(entry);
        if (this.isRelevant(entry)) {
            this.addEntryView(entry);
        }
    }

    private boolean removeEntryView(Entry<?> entry) {
        boolean removed = this.getChildren().removeIf(node -> {
            if (node instanceof DayEntryView) {
                Entry<?> viewEntry;
                DayEntryView view = (DayEntryView)node;
                Entry removedEntry = entry;
                if (removedEntry.getRecurrenceSourceEntry() != null) {
                    removedEntry = removedEntry.getRecurrenceSourceEntry();
                }
                if ((viewEntry = view.getEntry()).getRecurrenceSourceEntry() != null) {
                    viewEntry = viewEntry.getRecurrenceSourceEntry();
                }
                if (viewEntry.getId().equals(removedEntry.getId())) {
                    return true;
                }
            }
            return false;
        });
        if (removed && !(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("successfully removed the entry view of entry " + entry);
        }
        return removed;
    }

    private void addEntryView(Entry<?> entry) {
        if (entry.isRecurring()) {
            LocalDate date;
            Calendar calendar = entry.getCalendar();
            Map<LocalDate, List<Entry<?>>> entries = calendar.findEntries(date = ((DayView)this.getSkinnable()).getDate(), date, this.getZoneId());
            List<Entry<?>> entriesOnDate = entries.get(date);
            if (entriesOnDate != null && !entriesOnDate.isEmpty()) {
                this.doAddEntryView(entriesOnDate.get(0));
            }
        } else {
            this.doAddEntryView(entry);
        }
    }

    private DayEntryView doAddEntryView(Entry<?> entry) {
        Callback<Entry<?>, DayEntryView> factory = ((DayView)this.getSkinnable()).getEntryViewFactory();
        DayEntryView view = (DayEntryView)factory.call(entry);
        view.getProperties().put((Object)"control", (Object)this.getSkinnable());
        view.setManaged(false);
        int index = this.findIndex(entry);
        this.getChildren().add(index, (Object)view);
        if (!(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("added entry view " + entry.getTitle() + ", day = " + ((DayView)this.getSkinnable()).getDate());
        }
        return view;
    }

    private int findIndex(Entry<?> entry) {
        int childrenSize = this.getChildren().size();
        for (int i = 0; i < childrenSize; ++i) {
            DayEntryView view;
            Entry<?> viewEntry;
            Node node = (Node)this.getChildren().get(i);
            if (!(node instanceof DayEntryView) || !(viewEntry = (view = (DayEntryView)node).getEntry()).getStartAsZonedDateTime().isAfter(entry.getStartAsZonedDateTime())) continue;
            return i;
        }
        return childrenSize;
    }

    private void updateEntries(String reason) {
        this.displayedDate = ((DayView)this.getSkinnable()).getDate();
        this.getChildren().removeIf(node -> node instanceof DayEntryView);
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        List entryList = (List)dataMap.get(((DayView)this.getSkinnable()).getDate());
        LocalTime earliest = null;
        LocalTime latest = null;
        if (entryList != null) {
            entryList.removeIf(Entry::isFullDay);
            for (Entry entry : entryList) {
                this.doAddEntryView(entry);
                if (earliest == null || entry.getStartTime().isBefore(earliest)) {
                    earliest = entry.getStartTime();
                }
                if (entry.getStartDate().isBefore(((DayView)this.getSkinnable()).getDate())) {
                    earliest = LocalTime.MIN;
                }
                if (latest == null || entry.getEndTime().isAfter(latest)) {
                    latest = entry.getEndTime();
                }
                if (!entry.getEndDate().isAfter(((DayView)this.getSkinnable()).getDate())) continue;
                latest = LocalTime.MAX;
            }
        }
        ((DayView)this.getSkinnable()).getProperties().put((Object)"earliest.time.used", earliest);
        ((DayView)this.getSkinnable()).getProperties().put((Object)"latest.time.used", latest);
        ((DayView)this.getSkinnable()).requestLayout();
        LoggingDomain.VIEW.fine("updating entries in day view " + ((DayView)this.getSkinnable()).getDate() + ": reason = " + reason + ", entry count: " + this.getChildren().stream().filter(child -> child instanceof DayEntryView).count());
    }

    @Override
    public String getLoaderName() {
        return "Day View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        return ((DayView)this.getSkinnable()).getDate();
    }

    @Override
    public LocalDate getLoadEndDate() {
        return ((DayView)this.getSkinnable()).getDate();
    }

    @Override
    public ZoneId getZoneId() {
        return ZoneId.systemDefault();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((DayView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((DayView)this.getSkinnable()).isCalendarVisible(calendar);
    }
}

