/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayViewBase;
import impl.com.calendarfx.view.ViewHelper;
import java.time.LocalTime;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventTarget;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.Pane;
import javafx.scene.shape.Rectangle;

public class DayViewScrollPane
extends Pane {
    private DayViewBase dayView;
    private LocalTime cachedStartTime;
    private ReadOnlyObjectWrapper<LocalTime> startTime = new ReadOnlyObjectWrapper((Object)this, "startTime", (Object)LocalTime.MIN);
    private ReadOnlyObjectWrapper<LocalTime> endTime = new ReadOnlyObjectWrapper((Object)this, "endTime", (Object)LocalTime.MIN);
    private ScrollThread scrollThread;

    public DayViewScrollPane(DayViewBase dayView, ScrollBar scrollBar) {
        this.dayView = Objects.requireNonNull(dayView);
        this.dayView.setManaged(false);
        this.dayView.layoutBoundsProperty().addListener(it -> this.requestLayout());
        scrollBar.setOrientation(Orientation.VERTICAL);
        scrollBar.maxProperty().bind((ObservableValue)dayView.heightProperty().subtract((ObservableNumberValue)this.heightProperty()));
        scrollBar.visibleAmountProperty().bind((ObservableValue)Bindings.multiply((ObservableNumberValue)scrollBar.maxProperty(), (ObservableNumberValue)Bindings.divide((ObservableNumberValue)this.heightProperty(), (ObservableNumberValue)dayView.heightProperty())));
        scrollBar.valueProperty().addListener(it -> dayView.setTranslateY(scrollBar.getValue() * -1.0));
        scrollBar.unitIncrementProperty().bind((ObservableValue)dayView.hourHeightProperty());
        scrollBar.blockIncrementProperty().bind((ObservableValue)this.heightProperty().divide(2));
        dayView.translateYProperty().addListener(it -> {
            this.updateVisibleTimeRange();
            this.cachedStartTime = this.getStartTime();
            scrollBar.setValue(-dayView.getTranslateY());
        });
        this.getChildren().add((Object)dayView);
        this.heightProperty().addListener(it -> this.updateVisibleTimeRange());
        dayView.sceneProperty().addListener(it -> this.updateVisibleTimeRange());
        dayView.heightProperty().addListener(it -> this.updateVisibleTimeRange());
        dayView.visibleHoursProperty().addListener(it -> this.updateVisibleTimeRange());
        dayView.earlyLateHoursStrategyProperty().addListener(it -> this.requestLayout());
        dayView.hourHeightCompressedProperty().addListener(it -> this.requestLayout());
        dayView.hoursLayoutStrategyProperty().addListener(it -> this.requestLayout());
        dayView.hourHeightProperty().addListener(it -> this.requestLayout());
        this.updateVisibleTimeRange();
        this.addEventFilter(ScrollEvent.SCROLL, evt -> this.scrollY(evt.getDeltaY()));
        this.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::autoscrollIfNeeded);
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_OVER, this::autoscrollIfNeeded);
        this.addEventFilter(DragEvent.DRAG_EXITED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_DROPPED, evt -> this.stopAutoScrollIfNeeded());
        this.addEventFilter(DragEvent.DRAG_DONE, evt -> this.stopAutoScrollIfNeeded());
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)this.widthProperty());
        clip.heightProperty().bind((ObservableValue)this.heightProperty());
        this.setClip((Node)clip);
    }

    private void scrollY(double deltaY) {
        Insets insets = this.getInsets();
        this.dayView.setTranslateY(Math.min(0.0, Math.max(this.dayView.getTranslateY() + deltaY, this.getMaxTranslateY(insets))));
    }

    public void scrollToTime(LocalTime time) {
        double y = ViewHelper.getTimeLocation(this.dayView, time, true);
        Insets insets = this.getInsets();
        this.dayView.setTranslateY(Math.min(0.0, Math.max(-y + this.getHeight() / 3.0, this.getMaxTranslateY(insets))));
    }

    private void updateVisibleTimeRange() {
        if (this.dayView.getScene() == null || this.dayView.getHeight() == 0.0) {
            return;
        }
        LocalTime startTime = this.dayView.getZonedDateTimeAt(0.0, -this.dayView.getTranslateY()).toLocalTime();
        LocalTime endTime = this.dayView.getZonedDateTimeAt(0.0, -this.dayView.getTranslateY() + this.getHeight()).toLocalTime();
        this.startTime.set((Object)startTime);
        this.endTime.set((Object)endTime);
    }

    public final ReadOnlyObjectProperty<LocalTime> startTimeProperty() {
        return this.startTime.getReadOnlyProperty();
    }

    public final LocalTime getStartTime() {
        return (LocalTime)this.startTime.get();
    }

    public final ReadOnlyObjectProperty<LocalTime> endTimeProperty() {
        return this.endTime.getReadOnlyProperty();
    }

    public final LocalTime getEndTime() {
        return (LocalTime)this.endTime.get();
    }

    public DayViewBase getDayView() {
        return this.dayView;
    }

    protected double computePrefWidth(double height) {
        return this.getDayView().prefWidth(-1.0);
    }

    protected void layoutChildren() {
        super.layoutChildren();
        switch (this.dayView.getHoursLayoutStrategy()) {
            case FIXED_HOUR_COUNT: {
                double height = this.getHeight();
                int visibleHours = this.dayView.getVisibleHours();
                this.dayView.setHourHeight(Math.max(1.0, height / (double)visibleHours));
                break;
            }
        }
        Insets insets = this.getInsets();
        double ph = this.dayView.prefHeight(-1.0);
        this.dayView.resizeRelocate(this.snapPosition(insets.getLeft()), this.snapPosition(insets.getTop()), this.snapSize(this.getWidth() - insets.getLeft() - insets.getRight()), this.snapSize(Math.max(ph, this.getHeight() - insets.getTop() - insets.getBottom())));
        switch (this.dayView.getHoursLayoutStrategy()) {
            case FIXED_HOUR_COUNT: {
                if (this.cachedStartTime == null) break;
                this.dayView.setTranslateY(-ViewHelper.getTimeLocation(this.dayView, this.cachedStartTime, true));
                break;
            }
        }
        if (this.dayView.getTranslateY() + this.dayView.getHeight() < this.getHeight() - insets.getTop() - insets.getBottom()) {
            this.dayView.setTranslateY(this.getMaxTranslateY(insets));
        }
    }

    private double getMaxTranslateY(Insets insets) {
        return this.getHeight() - insets.getTop() - insets.getBottom() - this.dayView.getHeight();
    }

    private void startDrag(MouseEvent evt) {
        EventTarget target = evt.getTarget();
        if (!this.isOnEntry(target)) {
            return;
        }
        Dragboard db = this.startDragAndDrop(new TransferMode[]{TransferMode.MOVE});
        ClipboardContent content = new ClipboardContent();
        content.putString("dummy");
        db.setContent((Map)content);
    }

    private boolean isOnEntry(EventTarget target) {
        if (target == null || !(target instanceof Node)) {
            return false;
        }
        Node node = (Node)target;
        if (node instanceof DayEntryView) {
            return true;
        }
        return this.isOnEntry((EventTarget)node.getParent());
    }

    private void autoscrollIfNeeded(DragEvent evt) {
        double proximity;
        evt.acceptTransferModes(TransferMode.ANY);
        if (this.getBoundsInLocal().getWidth() < 1.0 && this.getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded();
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - this.localToScene(0.0, 0.0).getY();
        if (delta < (proximity = 20.0)) {
            yOffset = -(proximity - delta);
        }
        if ((delta = this.localToScene(0.0, 0.0).getY() + this.getHeight() - evt.getSceneY()) < proximity) {
            yOffset = proximity - delta;
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded();
        }
    }

    private void autoscrollIfNeeded(MouseEvent evt) {
        if (this.getBoundsInLocal().getWidth() < 1.0 && this.getBoundsInLocal().getWidth() < 1.0) {
            this.stopAutoScrollIfNeeded();
            return;
        }
        double yOffset = 0.0;
        double delta = evt.getSceneY() - this.localToScene(0.0, 0.0).getY();
        if (delta < 0.0) {
            yOffset = Math.max(delta / 2.0, -10.0);
        }
        if ((delta = this.localToScene(0.0, 0.0).getY() + this.getHeight() - evt.getSceneY()) < 0.0) {
            yOffset = Math.min(-delta / 2.0, 10.0);
        }
        if (yOffset != 0.0) {
            this.autoscroll(yOffset);
        } else {
            this.stopAutoScrollIfNeeded();
        }
    }

    private void autoscroll(double yOffset) {
        if (this.scrollThread == null) {
            this.scrollThread = new ScrollThread();
            this.scrollThread.start();
        }
        this.scrollThread.setDelta(yOffset);
    }

    private void stopAutoScrollIfNeeded() {
        if (this.scrollThread != null) {
            this.scrollThread.stopRunning();
            this.scrollThread = null;
        }
    }

    class ScrollThread
    extends Thread {
        private boolean running;
        private double yOffset;

        public ScrollThread() {
            super("Autoscrolling List View");
            this.running = true;
            this.setDaemon(true);
        }

        @Override
        public void run() {
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            while (this.running) {
                Platform.runLater(this::scrollToY);
                try {
                    ScrollThread.sleep(15L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void scrollToY() {
            DayViewScrollPane.this.scrollY(-this.yOffset);
        }

        public void stopRunning() {
            this.running = false;
        }

        public void setDelta(double yOffset) {
            this.yOffset = yOffset;
        }
    }
}

