/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.model.Interval;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DayView;
import com.calendarfx.view.DayViewBase;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import com.calendarfx.view.VirtualGrid;
import com.calendarfx.view.WeekView;
import java.time.DayOfWeek;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import java.util.logging.Logger;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.Parent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class DayViewEditController {
    private static final Logger LOGGER = LoggingDomain.EDITING;
    private boolean dragging;
    private DayViewBase dayView;
    private DayEntryView dayEntryView;
    private Entry<?> entry;
    private DraggedEntry.DragMode dragMode;
    private Handle handle;
    private Duration offsetDuration;
    private Duration entryDuration;

    public DayViewEditController(DayViewBase dayView) {
        this.dayView = Objects.requireNonNull(dayView);
        EventHandler mouseReleasedHandler = this::mouseReleased;
        dayView.addEventFilter(MouseEvent.MOUSE_PRESSED, this::mousePressed);
        dayView.addEventFilter(MouseEvent.MOUSE_DRAGGED, this::mouseDragged);
        if (dayView.getScene() != null) {
            dayView.getScene().addEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
            dayView.getScene().addEventFilter(MouseEvent.MOUSE_EXITED, mouseReleasedHandler);
        }
        dayView.sceneProperty().addListener((observable, oldValue, newValue) -> {
            if (oldValue != null) {
                oldValue.removeEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
                oldValue.removeEventFilter(MouseEvent.MOUSE_EXITED, mouseReleasedHandler);
            }
            if (newValue != null) {
                newValue.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseReleasedHandler);
                newValue.addEventFilter(MouseEvent.MOUSE_EXITED, mouseReleasedHandler);
            }
        });
        dayView.addEventFilter(MouseEvent.MOUSE_MOVED, this::mouseMoved);
    }

    private void initDragModeAndHandle(MouseEvent evt) {
        this.dragMode = null;
        this.handle = null;
        if (!(evt.getTarget() instanceof EntryViewBase)) {
            return;
        }
        this.dayEntryView = (DayEntryView)evt.getTarget();
        this.entry = this.dayEntryView.getEntry();
        Calendar calendar = this.entry.getCalendar();
        if (calendar.isReadOnly()) {
            return;
        }
        double y = evt.getY() - this.dayEntryView.getBoundsInParent().getMinY();
        LOGGER.finer("y-coordinate inside entry view: " + y);
        if (y > this.dayEntryView.getHeight() - 5.0) {
            if (((Boolean)this.dayView.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dayView, this.entry, DateControl.EditOperation.CHANGE_END))).booleanValue()) {
                this.dragMode = DraggedEntry.DragMode.END_TIME;
                this.handle = Handle.BOTTOM;
            }
        } else if (y < 5.0) {
            if (((Boolean)this.dayView.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dayView, this.entry, DateControl.EditOperation.CHANGE_START))).booleanValue()) {
                this.dragMode = DraggedEntry.DragMode.START_TIME;
                this.handle = Handle.TOP;
            }
        } else if (((Boolean)this.dayView.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dayView, this.entry, DateControl.EditOperation.MOVE))).booleanValue()) {
            this.dragMode = DraggedEntry.DragMode.START_AND_END_TIME;
            this.handle = Handle.CENTER;
        }
    }

    private void mouseMoved(MouseEvent evt) {
        if (!this.dragging) {
            this.initDragModeAndHandle(evt);
        }
        if (this.handle == null) {
            if (this.dayEntryView != null) {
                this.dayEntryView.setCursor(Cursor.DEFAULT);
            }
            return;
        }
        switch (this.handle) {
            case TOP: {
                this.dayEntryView.setCursor(Cursor.N_RESIZE);
                break;
            }
            case BOTTOM: {
                this.dayEntryView.setCursor(Cursor.S_RESIZE);
                break;
            }
            case CENTER: {
                this.dayEntryView.setCursor(Cursor.MOVE);
                break;
            }
            default: {
                this.dayEntryView.setCursor(Cursor.DEFAULT);
            }
        }
    }

    private void mousePressed(MouseEvent evt) {
        this.dragMode = null;
        this.handle = null;
        if (!evt.getButton().equals((Object)MouseButton.PRIMARY)) {
            return;
        }
        LOGGER.finer("mouse event source: " + evt.getSource());
        LOGGER.finer("mouse event target: " + evt.getTarget());
        LOGGER.finer("mouse event y-coordinate:" + evt.getY());
        LOGGER.finer("time: " + this.dayView.getZonedDateTimeAt(evt.getX(), evt.getY()));
        if (!(evt.getTarget() instanceof EntryViewBase)) {
            return;
        }
        Entry<?> entry = ((EntryViewBase)evt.getTarget()).getEntry();
        if (entry == null) {
            return;
        }
        this.initDragModeAndHandle(evt);
        LOGGER.finer("drag mode: " + (Object)((Object)this.dragMode));
        LOGGER.finer("handle: " + (Object)((Object)this.handle));
        if (this.dragMode == null) {
            return;
        }
        switch (this.dragMode) {
            case START_AND_END_TIME: {
                if (!((Boolean)this.dayView.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dayView, entry, DateControl.EditOperation.MOVE))).booleanValue()) break;
                this.dragging = true;
                this.dayEntryView.getProperties().put((Object)"dragged", (Object)true);
                LocalDateTime time = this.dayView.getZonedDateTimeAt(evt.getX(), evt.getY()).toLocalDateTime();
                this.offsetDuration = Duration.between(entry.getStartAsLocalDateTime(), time);
                this.entryDuration = entry.getDuration();
                LOGGER.finer("time at mouse pressed location: " + time);
                LOGGER.finer("offset duration: " + this.offsetDuration);
                LOGGER.finer("entry duration: " + this.entryDuration);
                this.dayView.requestLayout();
                break;
            }
            case END_TIME: {
                if (!((Boolean)this.dayView.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dayView, entry, DateControl.EditOperation.CHANGE_END))).booleanValue()) break;
                this.dragging = true;
                this.dayEntryView.getProperties().put((Object)"dragged-end", (Object)true);
                break;
            }
            case START_TIME: {
                if (!((Boolean)this.dayView.getEntryEditPolicy().call((Object)new DateControl.EntryEditParameter(this.dayView, entry, DateControl.EditOperation.CHANGE_START))).booleanValue()) break;
                this.dragging = true;
                this.dayEntryView.getProperties().put((Object)"dragged-start", (Object)true);
                break;
            }
        }
        if (!this.dragging) {
            return;
        }
        DayView dayView = (DayView)this.dayEntryView.getDateControl();
        if (dayView != null) {
            DraggedEntry draggedEntry = new DraggedEntry(this.dayEntryView.getEntry(), this.dragMode);
            draggedEntry.setOffsetDuration(this.offsetDuration);
            dayView.setDraggedEntry(draggedEntry);
        }
    }

    private void mouseReleased(MouseEvent evt) {
        if (!evt.getButton().equals((Object)MouseButton.PRIMARY) || this.dayEntryView == null || this.dragMode == null || !this.dragging) {
            return;
        }
        this.dragging = false;
        Calendar calendar = this.entry.getCalendar();
        if (calendar.isReadOnly()) {
            return;
        }
        this.dayEntryView.getProperties().put((Object)"dragged", (Object)false);
        this.dayEntryView.getProperties().put((Object)"dragged-start", (Object)false);
        this.dayEntryView.getProperties().put((Object)"dragged-end", (Object)false);
        DraggedEntry draggedEntry = this.dayView.getDraggedEntry();
        if (draggedEntry != null) {
            this.entry.setInterval(draggedEntry.getInterval());
            this.dayView.setDraggedEntry(null);
        }
    }

    private void mouseDragged(MouseEvent evt) {
        if (!evt.getButton().equals((Object)MouseButton.PRIMARY) || this.dayEntryView == null || this.dragMode == null || !this.dragging) {
            return;
        }
        Calendar calendar = this.entry.getCalendar();
        if (calendar.isReadOnly()) {
            return;
        }
        if (this.dayView.getDraggedEntry() == null || this.dayEntryView.getParent() == null) {
            return;
        }
        block0 : switch (this.dragMode) {
            case START_TIME: {
                switch (this.handle) {
                    case TOP: {
                        this.changeStartTime(evt);
                        break block0;
                    }
                    case BOTTOM: {
                        this.changeStartTime(evt);
                        break block0;
                    }
                }
                break;
            }
            case END_TIME: {
                switch (this.handle) {
                    case TOP: {
                        this.changeEndTime(evt);
                        break block0;
                    }
                    case BOTTOM: {
                        this.changeEndTime(evt);
                        break block0;
                    }
                }
                break;
            }
            case START_AND_END_TIME: {
                this.changeStartAndEndTime(evt);
            }
        }
    }

    private void changeStartTime(MouseEvent evt) {
        LocalDateTime locationTime = this.dayView.getZonedDateTimeAt(evt.getX(), evt.getY()).toLocalDateTime();
        LocalDateTime time = this.grid(locationTime);
        LOGGER.finer("changing start time, time = " + time);
        DraggedEntry draggedEntry = this.dayView.getDraggedEntry();
        if (this.isMinimumDuration(this.entry, this.entry.getEndAsLocalDateTime(), locationTime)) {
            LocalTime endTime;
            LocalTime startTime;
            Interval interval = draggedEntry.getInterval();
            LocalDate startDate = interval.getStartDate();
            LocalDate endDate = interval.getEndDate();
            if (locationTime.isAfter(this.entry.getEndAsLocalDateTime())) {
                startTime = this.entry.getEndTime();
                endTime = time.toLocalTime();
                endDate = time.toLocalDate();
            } else {
                startDate = time.toLocalDate();
                startTime = time.toLocalTime();
                endTime = this.entry.getEndTime();
            }
            LOGGER.finer("new interval: sd = " + startDate + ", st = " + startTime + ", ed = " + endDate + ", et = " + endTime);
            draggedEntry.setInterval(startDate, startTime, endDate, endTime);
            this.requestLayout();
        }
    }

    private void changeEndTime(MouseEvent evt) {
        LocalDateTime locationTime = this.dayView.getZonedDateTimeAt(evt.getX(), evt.getY()).toLocalDateTime();
        LocalDateTime time = this.grid(locationTime);
        LOGGER.finer("changing end time, time = " + time);
        DraggedEntry draggedEntry = this.dayView.getDraggedEntry();
        if (this.isMinimumDuration(this.entry, this.entry.getStartAsLocalDateTime(), locationTime)) {
            LocalTime startTime;
            LocalTime endTime;
            Interval interval = draggedEntry.getInterval();
            LOGGER.finer("dragged entry: " + draggedEntry.getInterval());
            LocalDate startDate = interval.getStartDate();
            LocalDate endDate = interval.getEndDate();
            if (locationTime.isBefore(this.entry.getStartAsLocalDateTime())) {
                endTime = this.entry.getStartTime();
                startTime = time.toLocalTime();
                startDate = time.toLocalDate();
            } else {
                startTime = this.entry.getStartTime();
                endTime = time.toLocalTime();
                endDate = time.toLocalDate();
            }
            LOGGER.finer("new interval: sd = " + startDate + ", st = " + startTime + ", ed = " + endDate + ", et = " + endTime);
            draggedEntry.setInterval(startDate, startTime, endDate, endTime);
            this.requestLayout();
        }
    }

    private void changeStartAndEndTime(MouseEvent evt) {
        DraggedEntry draggedEntry = this.dayView.getDraggedEntry();
        LocalDateTime locationTime = this.dayView.getZonedDateTimeAt(evt.getX(), evt.getY()).toLocalDateTime();
        LOGGER.fine("changing start/end time, time = " + locationTime + " offset duration = " + this.offsetDuration);
        if (locationTime != null && this.offsetDuration != null) {
            LocalDateTime newStartTime = locationTime.minus(this.offsetDuration);
            newStartTime = this.grid(newStartTime);
            LocalDateTime newEndTime = newStartTime.plus(this.entryDuration);
            LOGGER.fine("new start time = " + newStartTime);
            LOGGER.fine("new start time (grid) = " + newStartTime);
            LOGGER.fine("new end time = " + newEndTime);
            LocalDate startDate = newStartTime.toLocalDate();
            LocalTime startTime = newStartTime.toLocalTime();
            LocalDate endDate = LocalDateTime.of(startDate, startTime).plus(this.entryDuration).toLocalDate();
            LocalTime endTime = newEndTime.toLocalTime();
            LOGGER.finer("new interval: sd = " + startDate + ", st = " + startTime + ", ed = " + endDate + ", et = " + endTime);
            draggedEntry.setInterval(startDate, startTime, endDate, endTime);
            this.requestLayout();
        }
    }

    private boolean isMinimumDuration(Entry<?> entry, LocalDateTime timeA, LocalDateTime timeB) {
        Duration duration;
        Duration minDuration = entry.getMinimumDuration().abs();
        return minDuration == null || !(duration = Duration.between(timeA, timeB).abs()).minus(minDuration).isNegative();
    }

    private void requestLayout() {
        this.dayView.requestLayout();
        this.dayEntryView.getParent().requestLayout();
        if (this.dayView instanceof WeekView) {
            ((WeekView)this.dayView).getWeekDayViews().forEach(Parent::requestLayout);
        }
    }

    private LocalDateTime grid(LocalDateTime time) {
        DayOfWeek firstDayOfWeek = this.dayView.getFirstDayOfWeek();
        VirtualGrid grid = this.dayView.getVirtualGrid();
        LocalDateTime lowerTime = grid.adjustTime(time, false, firstDayOfWeek);
        LocalDateTime upperTime = grid.adjustTime(time, true, firstDayOfWeek);
        if (Duration.between(time, upperTime).abs().minus(Duration.between(time, lowerTime).abs()).isNegative()) {
            return upperTime;
        }
        return lowerTime;
    }

    private static enum Handle {
        TOP,
        CENTER,
        BOTTOM;

    }
}

