/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.view.DateControl;
import com.calendarfx.view.DayViewBase;
import impl.com.calendarfx.view.DateControlSkin;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import javafx.beans.InvalidationListener;

public class DayViewBaseSkin<T extends DayViewBase>
extends DateControlSkin<T> {
    public DayViewBaseSkin(T view) {
        super(view);
        InvalidationListener layoutListener = it -> {
            ((DayViewBase)this.getSkinnable()).autosize();
            ((DayViewBase)this.getSkinnable()).requestLayout();
        };
        ((DateControl)((Object)view)).timeProperty().addListener(layoutListener);
        ((DayViewBase)view).hourHeightProperty().addListener(layoutListener);
        ((DayViewBase)view).hourHeightCompressedProperty().addListener(layoutListener);
        ((DayViewBase)view).visibleHoursProperty().addListener(layoutListener);
        ((DayViewBase)view).earlyLateHoursStrategyProperty().addListener(layoutListener);
        ((DayViewBase)view).hoursLayoutStrategyProperty().addListener(layoutListener);
        ((DateControl)((Object)view)).startTimeProperty().addListener(layoutListener);
        ((DateControl)((Object)view)).endTimeProperty().addListener(layoutListener);
        ((DateControl)((Object)view)).getCalendars().addListener(layoutListener);
        ((DayViewBase)view).enableCurrentTimeMarkerProperty().addListener(layoutListener);
        ((DayViewBase)view).entryWidthPercentageProperty().addListener(layoutListener);
        ((DateControl)((Object)view)).showTodayProperty().addListener(layoutListener);
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        DayViewBase dayView = (DayViewBase)this.getSkinnable();
        double hourHeight = dayView.getHourHeight();
        DayViewBase.EarlyLateHoursStrategy strategy = dayView.getEarlyLateHoursStrategy();
        switch (strategy) {
            case HIDE: {
                long earlyHours = ChronoUnit.HOURS.between(LocalTime.MIN, dayView.getStartTime());
                long lateHours = ChronoUnit.HOURS.between(dayView.getEndTime(), LocalTime.MAX) + 1L;
                long hours = 24L - earlyHours - lateHours;
                return (double)hours * hourHeight;
            }
            case SHOW: {
                return 24.0 * hourHeight;
            }
            case SHOW_COMPRESSED: {
                long earlyHours = ChronoUnit.HOURS.between(LocalTime.MIN, dayView.getStartTime());
                long lateHours = ChronoUnit.HOURS.between(dayView.getEndTime(), LocalTime.MAX) + 1L;
                long hours = 24L - earlyHours - lateHours;
                double hourHeightCompressed = dayView.getHourHeightCompressed();
                return (double)hours * hourHeight + (double)(earlyHours + lateHours) * hourHeightCompressed;
            }
        }
        throw new IllegalArgumentException("unsupported early / late hours strategy: " + (Object)((Object)strategy));
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

