/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.DayEntryView;
import com.calendarfx.view.DraggedEntry;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;
import javafx.scene.shape.Rectangle;

public class DayEntryViewSkin
extends SkinBase<DayEntryView> {
    private DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT);
    protected Label startTimeLabel;
    protected Label titleLabel;
    private final InvalidationListener updateStylesListener = it -> this.updateStyles();
    private final WeakInvalidationListener weakUpdateStylesListener = new WeakInvalidationListener(this.updateStylesListener);
    private final InvalidationListener updateLabelsListener = it -> this.updateLabels();
    private final WeakInvalidationListener weakUpdateLabelsListener = new WeakInvalidationListener(this.updateLabelsListener);

    public DayEntryViewSkin(DayEntryView view) {
        super((Control)view);
        this.startTimeLabel = this.createStartTimeLabel();
        this.startTimeLabel.setManaged(false);
        this.startTimeLabel.setMouseTransparent(true);
        this.titleLabel = this.createTitleLabel();
        this.titleLabel.setManaged(false);
        this.titleLabel.setMouseTransparent(true);
        this.getChildren().addAll((Object[])new Node[]{this.startTimeLabel, this.titleLabel});
        Entry entry = this.getEntry();
        entry.intervalProperty().addListener((InvalidationListener)this.weakUpdateLabelsListener);
        entry.calendarProperty().addListener((InvalidationListener)this.weakUpdateStylesListener);
        entry.titleProperty().addListener((InvalidationListener)this.weakUpdateLabelsListener);
        ((DayEntryView)this.getSkinnable()).positionProperty().addListener((InvalidationListener)this.weakUpdateLabelsListener);
        this.updateLabels();
        Rectangle clip = new Rectangle();
        clip.widthProperty().bind((ObservableValue)view.widthProperty());
        clip.heightProperty().bind((ObservableValue)view.heightProperty());
        view.setClip((Node)clip);
        this.updateStyles();
    }

    protected Entry getEntry() {
        Entry<?> entry = ((DayEntryView)this.getSkinnable()).getEntry();
        if (entry.isRecurrence()) {
            entry = entry.getRecurrenceSourceEntry();
        }
        return entry;
    }

    protected void updateStyles() {
        DayEntryView view = (DayEntryView)this.getSkinnable();
        Entry entry = this.getEntry();
        Calendar calendar = entry.getCalendar();
        if (entry instanceof DraggedEntry) {
            calendar = ((DraggedEntry)entry).getOriginalCalendar();
        }
        if (calendar == null) {
            return;
        }
        view.getStyleClass().setAll((Object[])new String[]{"default-style-entry", calendar.getStyle() + "-entry"});
        if (entry.isRecurrence()) {
            view.getStyleClass().add((Object)"recurrence");
        }
        this.startTimeLabel.getStyleClass().setAll((Object[])new String[]{"start-time-label", "default-style-entry-time-label", calendar.getStyle() + "-entry-time-label"});
        this.titleLabel.getStyleClass().setAll((Object[])new String[]{"title-label", "default-style-entry-title-label", calendar.getStyle() + "-entry-title-label"});
    }

    protected Label createStartTimeLabel() {
        Label label = new Label();
        label.setMinSize(0.0, 0.0);
        return label;
    }

    protected String formatTime(LocalTime time) {
        return this.formatter.format(time);
    }

    protected String formatTitle(String title) {
        return title;
    }

    protected Label createTitleLabel() {
        Label label = new Label();
        label.setWrapText(true);
        label.setMinSize(0.0, 0.0);
        return label;
    }

    protected void updateLabels() {
        Entry entry = this.getEntry();
        this.startTimeLabel.setText(this.formatTime(entry.getStartTime()));
        this.titleLabel.setText(this.formatTitle(entry.getTitle()));
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        double titleHeight = this.titleLabel.prefHeight(contentWidth);
        this.titleLabel.resizeRelocate(this.snapPosition(contentX), this.snapPosition(contentY), this.snapSize(contentWidth), this.snapSize(titleHeight));
        double timeLabelHeight = this.startTimeLabel.prefHeight(contentWidth);
        if (contentHeight - titleHeight > timeLabelHeight) {
            this.startTimeLabel.setVisible(true);
            this.startTimeLabel.resizeRelocate(this.snapPosition(contentX), this.snapPosition(contentY + titleHeight), this.snapSize(contentWidth), this.snapSize(timeLabelHeight));
        } else {
            this.startTimeLabel.setVisible(false);
        }
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        if (this.titleLabel != null) {
            return this.titleLabel.prefHeight(-1.0) + topInset + bottomInset;
        }
        return super.computeMinHeight(width, topInset, rightInset, bottomInset, leftInset);
    }
}

