/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Entry;
import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.DeveloperConsole;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RequestEvent;
import com.calendarfx.view.SearchResultView;
import com.calendarfx.view.SourceView;
import com.calendarfx.view.YearMonthView;
import com.calendarfx.view.page.DayPage;
import com.calendarfx.view.page.MonthPage;
import com.calendarfx.view.page.PageBase;
import com.calendarfx.view.page.WeekPage;
import com.calendarfx.view.page.YearPage;
import com.calendarfx.view.print.PrintView;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.geometry.HPos;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.geometry.VPos;
import javafx.scene.CacheHint;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.Separator;
import javafx.scene.control.SkinBase;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Text;
import javafx.util.Duration;
import org.controlsfx.control.MasterDetailPane;
import org.controlsfx.control.SegmentedButton;
import org.controlsfx.control.textfield.CustomTextField;

public class CalendarViewSkin
extends SkinBase<CalendarView> {
    private MasterDetailPane leftMasterDetailPane;
    private ToggleButton trayButton;
    private Button addCalendarButton;
    private Button printButton;
    private SearchResultView searchResultView;
    private StackPane stackPane;
    private DayPage dayPage;
    private WeekPage weekPage;
    private MonthPage monthPage;
    private YearPage yearPage;
    private List<PageBase> pageList = new ArrayList<PageBase>();
    private ToggleButton showYear;
    private ToggleButton showMonth;
    private ToggleButton showWeek;
    private ToggleButton showDay;
    private HBox leftToolBarBox;
    private SegmentedButton switcher;
    private Timeline timeline;
    private PrintView printView;

    public CalendarViewSkin(CalendarView view) {
        super((Control)view);
        if (Boolean.getBoolean("calendarfx.developer")) {
            view.addEventFilter(KeyEvent.KEY_PRESSED, evt -> {
                if (evt.isMetaDown() && evt.getCode().equals((Object)KeyCode.D)) {
                    view.setShowDeveloperConsole(!view.isShowDeveloperConsole());
                }
            });
        }
        view.addEventHandler(RequestEvent.REQUEST_DATE, evt -> view.showDate(evt.getDate()));
        view.addEventHandler(RequestEvent.REQUEST_DATE_TIME, evt -> view.showDateTime(evt.getDateTime()));
        view.addEventHandler(RequestEvent.REQUEST_WEEK, evt -> view.showWeek(evt.getYear(), evt.getWeekOfYear()));
        view.addEventHandler(RequestEvent.REQUEST_YEAR_MONTH, evt -> view.showYearMonth(evt.getYearMonth()));
        view.addEventHandler(RequestEvent.REQUEST_YEAR, evt -> view.showYear(evt.getYear()));
        view.addEventHandler(RequestEvent.REQUEST_ENTRY, evt -> view.getSelectedPage().editEntry(evt.getEntry()));
        this.dayPage = view.getDayPage();
        this.weekPage = view.getWeekPage();
        this.monthPage = view.getMonthPage();
        this.yearPage = view.getYearPage();
        this.pageList.add(this.dayPage);
        this.pageList.add(this.weekPage);
        this.pageList.add(this.monthPage);
        this.pageList.add(this.yearPage);
        view.bind(this.dayPage, true);
        view.bind(this.weekPage, true);
        view.bind(this.monthPage, true);
        view.bind(this.yearPage, true);
        InvalidationListener updateSwitcherListener = it -> this.buildSwitcher();
        this.dayPage.hiddenProperty().addListener(updateSwitcherListener);
        this.weekPage.hiddenProperty().addListener(updateSwitcherListener);
        this.monthPage.hiddenProperty().addListener(updateSwitcherListener);
        this.yearPage.hiddenProperty().addListener(updateSwitcherListener);
        this.leftMasterDetailPane = new MasterDetailPane(Side.LEFT);
        TrayPane trayPane = new TrayPane();
        this.trayButton = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SOURCE_TRAY"));
        this.trayButton.setId("show-tray-button");
        this.addCalendarButton = new Button();
        this.addCalendarButton.setId("add-calendar-button");
        this.addCalendarButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        Text addIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.PLUS);
        addIcon.getStyleClass().addAll((Object[])new String[]{"button-icon", "add-calendar-button-icon"});
        this.addCalendarButton.setGraphic((Node)addIcon);
        this.addCalendarButton.setOnAction(evt -> view.createCalendarSource());
        this.printButton = new Button();
        this.printButton.setId("print-button");
        this.printButton.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        this.printButton.setOnAction(evt -> this.print());
        Text printIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.PRINT);
        printIcon.getStyleClass().addAll((Object[])new String[]{"button-icon", "print-button-icon"});
        this.printButton.setGraphic((Node)printIcon);
        if (view.isShowSourceTray()) {
            this.openTray();
        } else {
            this.closeTray();
        }
        Bindings.bindBidirectional((Property)this.trayButton.selectedProperty(), (Property)view.showSourceTrayProperty());
        view.showSourceTrayProperty().addListener(it -> {
            if (view.isShowSourceTray()) {
                this.openTray();
            } else {
                this.closeTray();
            }
        });
        ColumnConstraints leftColumn = new ColumnConstraints();
        ColumnConstraints centerColumn = new ColumnConstraints();
        ColumnConstraints rightColumn = new ColumnConstraints();
        leftColumn.setPercentWidth(35.0);
        centerColumn.setPercentWidth(30.0);
        rightColumn.setPercentWidth(35.0);
        GridPane toolBarGridPane = new GridPane();
        toolBarGridPane.setMinWidth(0.0);
        toolBarGridPane.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{leftColumn, centerColumn, rightColumn});
        toolBarGridPane.setId("toolbar");
        this.leftToolBarBox = new HBox();
        this.leftToolBarBox.setSpacing(5.0);
        this.buildLeftToolBarBox();
        InvalidationListener buildLeftToolBarBoxListener = it -> this.buildLeftToolBarBox();
        view.showSourceTrayButtonProperty().addListener(buildLeftToolBarBoxListener);
        view.showAddCalendarButtonProperty().addListener(buildLeftToolBarBoxListener);
        view.showPrintButtonProperty().addListener(buildLeftToolBarBoxListener);
        view.showPageToolBarControlsProperty().addListener(buildLeftToolBarBoxListener);
        view.selectedPageProperty().addListener(buildLeftToolBarBoxListener);
        toolBarGridPane.add((Node)this.leftToolBarBox, 0, 0);
        this.showDay = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_DAY"));
        this.showWeek = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_WEEK"));
        this.showMonth = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_MONTH"));
        this.showYear = new ToggleButton(Messages.getString("CalendarViewSkin.TOGGLE_SHOW_YEAR"));
        this.showDay.setOnAction(evt -> view.showDayPage());
        this.showWeek.setOnAction(evt -> view.showWeekPage());
        this.showMonth.setOnAction(evt -> view.showMonthPage());
        this.showYear.setOnAction(evt -> view.showYearPage());
        this.switcher = new SegmentedButton();
        this.switcher.setId("switcher");
        this.switcher.visibleProperty().bind((ObservableValue)view.showPageSwitcherProperty());
        this.buildSwitcher();
        GridPane centerToolBarBox = new GridPane();
        GridPane.setHalignment((Node)this.switcher, (HPos)HPos.CENTER);
        GridPane.setValignment((Node)this.switcher, (VPos)VPos.CENTER);
        centerToolBarBox.add((Node)this.switcher, 0, 0);
        centerToolBarBox.setAlignment(Pos.CENTER);
        toolBarGridPane.add((Node)centerToolBarBox, 1, 0);
        this.trayButton.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SOURCE_TRAY")));
        this.addCalendarButton.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_ADD_CALENDAR")));
        this.printButton.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_PRINT")));
        this.showDay.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_DAY")));
        this.showWeek.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_WEEK")));
        this.showMonth.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_MONTH")));
        this.showYear.setTooltip(new Tooltip(Messages.getString("CalendarViewSkin.TOOLTIP_SHOW_YEAR")));
        Text searchIcon = FontAwesomeIconFactory.get().createIcon((GlyphIcons)FontAwesomeIcon.SEARCH);
        searchIcon.setId("search-icon");
        CustomTextField searchField = view.getSearchField();
        searchField.setPrefColumnCount(20);
        searchField.setLeft((Node)searchIcon);
        searchField.setId("search-field");
        searchField.setPromptText(Messages.getString("CalendarViewSkin.PROMPT_SEARCH_FIELD"));
        searchField.getStylesheets().add((Object)CalendarFXControl.class.getResource("calendar.css").toExternalForm());
        GridPane.setFillWidth((Node)searchField, (Boolean)false);
        GridPane.setHalignment((Node)searchField, (HPos)HPos.RIGHT);
        toolBarGridPane.add((Node)searchField, 2, 0);
        BorderPane borderPane1 = new BorderPane();
        borderPane1.topProperty().bind(view.headerProperty());
        this.stackPane = new StackPane();
        borderPane1.setCenter((Node)this.stackPane);
        borderPane1.bottomProperty().bind(view.footerProperty());
        view.selectedPageProperty().addListener(it -> this.changePage());
        this.leftMasterDetailPane.setMasterNode((Node)borderPane1);
        this.leftMasterDetailPane.setDetailNode((Node)trayPane);
        this.leftMasterDetailPane.setId("tray-pane");
        this.leftMasterDetailPane.animatedProperty().bindBidirectional((Property)view.traysAnimatedProperty());
        this.leftMasterDetailPane.getStylesheets().add((Object)CalendarFXControl.class.getResource("calendar.css").toExternalForm());
        MasterDetailPane rightMasterDetailPane = new MasterDetailPane(Side.RIGHT);
        this.searchResultView = view.getSearchResultView();
        Bindings.bindContentBidirectional(this.searchResultView.getCalendarSources(), view.getCalendarSources());
        this.searchResultView.zoneIdProperty().bind(view.zoneIdProperty());
        this.searchResultView.searchTextProperty().bind((ObservableValue)searchField.textProperty());
        this.searchResultView.selectedEntryProperty().addListener(evt -> this.showSelectedSearchResult());
        view.showSearchResultsTrayProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)Bindings.isEmpty(this.searchResultView.getSearchResults())));
        rightMasterDetailPane.setDetailNode((Node)this.searchResultView);
        rightMasterDetailPane.setMasterNode((Node)this.leftMasterDetailPane);
        rightMasterDetailPane.showDetailNodeProperty().bind((ObservableValue)view.showSearchResultsTrayProperty());
        BorderPane borderPane = new BorderPane();
        if (view.isShowToolBar()) {
            borderPane.setTop((Node)toolBarGridPane);
        }
        view.showToolBarProperty().addListener(it -> {
            if (view.isShowToolBar()) {
                borderPane.setTop((Node)toolBarGridPane);
            } else {
                borderPane.setTop(null);
            }
        });
        borderPane.setCenter((Node)rightMasterDetailPane);
        if (Boolean.getBoolean("calendarfx.developer")) {
            DeveloperConsole developerConsole = view.getDeveloperConsole();
            MasterDetailPane developerConsoleMasterDetailPane = new MasterDetailPane(Side.BOTTOM);
            developerConsoleMasterDetailPane.setDividerPosition(0.6);
            developerConsoleMasterDetailPane.animatedProperty().bind((ObservableValue)view.traysAnimatedProperty());
            developerConsoleMasterDetailPane.getStyleClass().add((Object)"developer-master-detail-pane");
            developerConsoleMasterDetailPane.setDetailSide(Side.BOTTOM);
            developerConsoleMasterDetailPane.setMasterNode((Node)borderPane);
            developerConsoleMasterDetailPane.setDetailNode((Node)developerConsole);
            developerConsoleMasterDetailPane.setShowDetailNode(true);
            developerConsoleMasterDetailPane.showDetailNodeProperty().bind((ObservableValue)view.showDeveloperConsoleProperty());
            developerConsoleMasterDetailPane.getStylesheets().add((Object)CalendarFXControl.class.getResource("calendar.css").toExternalForm());
            this.getChildren().add((Object)developerConsoleMasterDetailPane);
        } else {
            this.getChildren().add((Object)borderPane);
        }
        this.stackPane.getChildren().setAll((Object[])new Node[]{this.dayPage, this.weekPage, this.monthPage, this.yearPage});
        PageBase selectedPage = view.getSelectedPage();
        selectedPage.toFront();
        this.hideNonSelectedPages();
    }

    private void openTray() {
        this.leftMasterDetailPane.resetDividerPosition();
        this.leftMasterDetailPane.setShowDetailNode(true);
    }

    private void closeTray() {
        this.leftMasterDetailPane.setShowDetailNode(false);
    }

    private void buildSwitcher() {
        this.switcher.getButtons().clear();
        if (!this.dayPage.isHidden()) {
            this.switcher.getButtons().add((Object)this.showDay);
        }
        if (!this.weekPage.isHidden()) {
            this.switcher.getButtons().add((Object)this.showWeek);
        }
        if (!this.monthPage.isHidden()) {
            this.switcher.getButtons().add((Object)this.showMonth);
        }
        if (!this.yearPage.isHidden()) {
            this.switcher.getButtons().add((Object)this.showYear);
        }
        if (this.switcher.getButtons().size() == 1) {
            this.switcher.getButtons().clear();
        }
    }

    private void buildLeftToolBarBox() {
        PageBase page;
        Node toolBarControls;
        this.leftToolBarBox.getChildren().clear();
        if (((CalendarView)this.getSkinnable()).isShowSourceTrayButton()) {
            this.leftToolBarBox.getChildren().add((Object)this.trayButton);
        }
        if (((CalendarView)this.getSkinnable()).isShowAddCalendarButton()) {
            this.leftToolBarBox.getChildren().add((Object)this.addCalendarButton);
        }
        if (!this.leftToolBarBox.getChildren().isEmpty() && ((CalendarView)this.getSkinnable()).isShowPrintButton()) {
            this.leftToolBarBox.getChildren().add((Object)new Separator(Orientation.VERTICAL));
        }
        if (((CalendarView)this.getSkinnable()).isShowPrintButton()) {
            this.leftToolBarBox.getChildren().add((Object)this.printButton);
        }
        if (!(!((CalendarView)this.getSkinnable()).isShowPageToolBarControls() || (toolBarControls = (page = ((CalendarView)this.getSkinnable()).getSelectedPage()).getToolBarControls()) == null || toolBarControls instanceof Pane && ((Pane)toolBarControls).getChildrenUnmodifiable().isEmpty())) {
            if (!this.leftToolBarBox.getChildren().isEmpty()) {
                this.leftToolBarBox.getChildren().add((Object)new Separator(Orientation.VERTICAL));
            }
            this.leftToolBarBox.getChildren().add((Object)toolBarControls);
        }
    }

    private void changePage() {
        CalendarView view = (CalendarView)this.getSkinnable();
        if (view.isTransitionsEnabled()) {
            this.animateChangePage();
        } else {
            this.updateToggleButtons();
            PageBase selectedPage = view.getSelectedPage();
            selectedPage.setManaged(true);
            selectedPage.setVisible(true);
            selectedPage.setScaleX(1.0);
            selectedPage.setScaleY(1.0);
            selectedPage.setOpacity(1.0);
            selectedPage.toFront();
            this.hideNonSelectedPages();
        }
    }

    private void hideNonSelectedPages() {
        PageBase selectedPage = ((CalendarView)this.getSkinnable()).getSelectedPage();
        this.pageList.forEach(page -> {
            if (page != selectedPage) {
                page.setVisible(false);
                page.setManaged(false);
            }
        });
    }

    private void updateToggleButtons() {
        CalendarView view = (CalendarView)this.getSkinnable();
        PageBase page = view.getSelectedPage();
        if (page == view.getDayPage()) {
            this.showDay.setSelected(true);
        } else if (page == view.getWeekPage()) {
            this.showWeek.setSelected(true);
        } else if (page == view.getMonthPage()) {
            this.showMonth.setSelected(true);
        } else if (page == view.getYearPage()) {
            this.showYear.setSelected(true);
        }
    }

    private void animateChangePage() {
        if (this.timeline != null && this.timeline.getStatus().equals((Object)Animation.Status.RUNNING)) {
            return;
        }
        PageBase oldPage = null;
        ObservableList children = this.stackPane.getChildren();
        if (!children.isEmpty()) {
            oldPage = (PageBase)((Object)children.get(children.size() - 1));
        }
        PageBase fOldPage = oldPage;
        boolean zoomIn = false;
        PageBase newPage = ((CalendarView)this.getSkinnable()).getSelectedPage();
        this.timeline = new Timeline();
        double small = 0.6;
        double large = 1.4;
        Duration duration = Duration.seconds((double)0.2);
        if (oldPage != null) {
            oldPage.setCache(true);
            oldPage.setCacheHint(CacheHint.SCALE);
            zoomIn = this.pageList.indexOf((Object)newPage) < this.pageList.indexOf((Object)oldPage);
            KeyValue oldOpacity = new KeyValue((WritableValue)oldPage.opacityProperty(), (Object)0);
            KeyValue oldScaleX = new KeyValue((WritableValue)oldPage.scaleXProperty(), (Object)(zoomIn ? large : small));
            KeyValue oldScaleY = new KeyValue((WritableValue)oldPage.scaleYProperty(), (Object)(zoomIn ? large : small));
            KeyFrame frame1 = new KeyFrame(duration, new KeyValue[]{oldOpacity, oldScaleX, oldScaleY});
            this.timeline.getKeyFrames().add((Object)frame1);
            oldPage.setCache(true);
            oldPage.setCacheHint(CacheHint.SCALE);
            this.timeline.setOnFinished(arg_0 -> this.lambda$animateChangePage$20((Node)fOldPage, newPage, arg_0));
        } else {
            this.timeline.setOnFinished(evt -> this.updateToggleButtons());
        }
        newPage.setOpacity(0.0);
        newPage.setScaleX(zoomIn ? small : large);
        newPage.setScaleY(zoomIn ? small : large);
        newPage.setCache(true);
        newPage.setCacheHint(CacheHint.SCALE);
        newPage.toFront();
        this.pageList.forEach(arg_0 -> CalendarViewSkin.lambda$animateChangePage$22(newPage, (Node)fOldPage, arg_0));
        KeyValue newOpacity = new KeyValue((WritableValue)newPage.opacityProperty(), (Object)1);
        KeyValue newScaleX = new KeyValue((WritableValue)newPage.scaleXProperty(), (Object)1);
        KeyValue newScaleY = new KeyValue((WritableValue)newPage.scaleYProperty(), (Object)1);
        if (!children.contains((Object)newPage)) {
            children.add((Object)newPage);
        }
        KeyFrame frame2 = new KeyFrame(duration, new KeyValue[]{newOpacity, newScaleX, newScaleY});
        this.timeline.getKeyFrames().add((Object)frame2);
        this.timeline.play();
    }

    private void showSelectedSearchResult() {
        Entry<?> result = this.searchResultView.getSelectedEntry();
        if (result != null) {
            ((CalendarView)this.getSkinnable()).showEntry(result);
        }
    }

    private void print() {
        if (this.printView == null) {
            this.printView = ((CalendarView)this.getSkinnable()).getPrintView();
        }
        this.printView.setToday(((CalendarView)this.getSkinnable()).getToday());
        this.printView.setWeekFields(((CalendarView)this.getSkinnable()).getWeekFields());
        this.printView.getCalendarSources().setAll(((CalendarView)this.getSkinnable()).getCalendarSources());
        this.printView.setLayout(((CalendarView)this.getSkinnable()).getSelectedPage().getLayout());
        this.printView.setViewType(((CalendarView)this.getSkinnable()).getSelectedPage().getPrintViewType());
        this.printView.requestStartDate(((CalendarView)this.getSkinnable()).getDate());
        this.printView.show(((CalendarView)this.getSkinnable()).getScene().getWindow());
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double dayHeight = this.dayPage.prefHeight(-1.0);
        double weekHeight = this.weekPage.prefHeight(-1.0);
        double monthHeight = this.monthPage.prefHeight(-1.0);
        double yearHeight = this.yearPage.prefHeight(-1.0);
        return Math.max(dayHeight, Math.max(weekHeight, Math.max(monthHeight, yearHeight)));
    }

    protected double computePrefWidth(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        double dayWidth = this.dayPage.prefWidth(-1.0);
        double weekWidth = this.weekPage.prefWidth(-1.0);
        double monthWidth = this.monthPage.prefWidth(-1.0);
        double yearWidth = this.yearPage.prefWidth(-1.0);
        return Math.max(dayWidth, Math.max(weekWidth, Math.max(monthWidth, yearWidth)));
    }

    private static /* synthetic */ void lambda$animateChangePage$22(PageBase newPage, Node fOldPage, PageBase page) {
        if (page != newPage && page != fOldPage) {
            page.setVisible(false);
            page.setManaged(false);
        } else {
            page.setVisible(true);
            page.setManaged(true);
        }
    }

    private /* synthetic */ void lambda$animateChangePage$20(Node fOldPage, PageBase newPage, ActionEvent evt) {
        fOldPage.setVisible(false);
        fOldPage.setManaged(false);
        fOldPage.setCache(false);
        newPage.setCache(false);
        this.updateToggleButtons();
    }

    class TrayPane
    extends BorderPane {
        private SourceView sourceView;
        private YearMonthView yearMonthView;

        public TrayPane() {
            this.sourceView = ((CalendarView)CalendarViewSkin.this.getSkinnable()).getSourceView();
            this.sourceView.bind((DateControl)CalendarViewSkin.this.getSkinnable());
            this.yearMonthView = ((CalendarView)CalendarViewSkin.this.getSkinnable()).getYearMonthView();
            this.yearMonthView.setShowToday(false);
            this.yearMonthView.setShowTodayButton(false);
            this.yearMonthView.setId("date-picker");
            this.yearMonthView.setSelectionMode(SelectionMode.SINGLE);
            this.yearMonthView.setClickBehaviour(YearMonthView.ClickBehaviour.PERFORM_SELECTION);
            this.yearMonthView.getSelectedDates().add((Object)((CalendarView)CalendarViewSkin.this.getSkinnable()).getDate());
            this.yearMonthView.getSelectedDates().addListener(evt -> {
                if (this.yearMonthView.getSelectedDates().size() > 0) {
                    this.yearMonthView.setDate((LocalDate)this.yearMonthView.getSelectedDates().iterator().next());
                }
            });
            ((CalendarView)CalendarViewSkin.this.getSkinnable()).dateProperty().addListener(it -> {
                this.yearMonthView.getSelectedDates().clear();
                this.yearMonthView.getSelectedDates().add((Object)((CalendarView)CalendarViewSkin.this.getSkinnable()).getDate());
            });
            Bindings.bindBidirectional(this.yearMonthView.todayProperty(), ((CalendarView)CalendarViewSkin.this.getSkinnable()).todayProperty());
            Bindings.bindBidirectional(this.yearMonthView.dateProperty(), ((CalendarView)CalendarViewSkin.this.getSkinnable()).dateProperty());
            this.yearMonthView.weekFieldsProperty().bind(((CalendarView)CalendarViewSkin.this.getSkinnable()).weekFieldsProperty());
            ScrollPane scrollPane = new ScrollPane((Node)this.sourceView);
            scrollPane.getStyleClass().add((Object)"source-view-scroll-pane");
            this.setCenter((Node)scrollPane);
            this.setBottom((Node)this.yearMonthView);
        }
    }
}

