/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.util.Util;
import com.calendarfx.view.AllDayEntryView;
import com.calendarfx.view.AllDayView;
import com.calendarfx.view.DraggedEntry;
import com.calendarfx.view.EntryViewBase;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.util.Placement;
import impl.com.calendarfx.view.util.Resolver;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javafx.beans.InvalidationListener;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.util.Callback;

public class AllDayViewSkin
extends DateControlSkin<AllDayView>
implements LoadDataSettingsProvider {
    private static final String ALL_DAY_BACKGROUND_REGION = "day-region";
    private static final String ALL_DAY_BACKGROUND_REGION_TODAY = "today";
    private static final String ALL_DAY_BACKGROUND_REGION_WEEKEND = "weekend";
    private DataLoader dataLoader;
    private GridPane pane;

    public AllDayViewSkin(AllDayView view) {
        super(view);
        view.setFocusTraversable(true);
        this.pane = new GridPane();
        this.pane.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)this.pane);
        InvalidationListener updateBackgroundsListener = evt -> this.updateBackgrounds();
        view.numberOfDaysProperty().addListener(updateBackgroundsListener);
        view.showTodayProperty().addListener(updateBackgroundsListener);
        view.weekFieldsProperty().addListener(updateBackgroundsListener);
        view.adjustToFirstDayOfWeekProperty().addListener(updateBackgroundsListener);
        InvalidationListener updateEntriesListener = evt -> this.updateEntries("a view property changed");
        view.numberOfDaysProperty().addListener(updateEntriesListener);
        view.dateProperty().addListener(updateEntriesListener);
        view.extraPaddingProperty().addListener(updateEntriesListener);
        view.rowHeightProperty().addListener(updateEntriesListener);
        view.rowSpacingProperty().addListener(updateEntriesListener);
        view.columnSpacingProperty().addListener(updateEntriesListener);
        view.weekFieldsProperty().addListener(updateEntriesListener);
        view.adjustToFirstDayOfWeekProperty().addListener(updateEntriesListener);
        this.updateBackgrounds();
        this.dataLoader = new DataLoader(this);
        this.updateEntries("initial load");
    }

    @Override
    protected void refreshData() {
        this.updateEntries("refreshData() called");
    }

    private void updateEntries(String reason) {
        LoggingDomain.PERFORMANCE.fine("updating entries, reason: " + reason);
        this.getChildren().removeIf(child -> child instanceof AllDayEntryView);
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        HashSet<Entry> entrySet = new HashSet<Entry>();
        for (List entryList : dataMap.values()) {
            entrySet.addAll(entryList);
        }
        entrySet.removeIf(ref -> !ref.isFullDay());
        ArrayList entryList = new ArrayList(entrySet);
        for (Entry entry : entryList) {
            this.doAddEntryView(entry);
        }
        ((AllDayView)this.getSkinnable()).autosize();
    }

    private boolean removeEntryView(Entry<?> entry) {
        boolean removed = this.getChildren().removeIf(node -> {
            if (node instanceof AllDayEntryView) {
                Entry<?> viewEntry;
                AllDayEntryView view = (AllDayEntryView)node;
                Entry removedEntry = entry;
                if (removedEntry.getRecurrenceSourceEntry() != null) {
                    removedEntry = removedEntry.getRecurrenceSourceEntry();
                }
                if ((viewEntry = view.getEntry()).getRecurrenceSourceEntry() != null) {
                    viewEntry = viewEntry.getRecurrenceSourceEntry();
                }
                if (viewEntry.getId().equals(removedEntry.getId())) {
                    return true;
                }
            }
            return false;
        });
        if (removed && !(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("successfully removed the entry view of entry " + entry);
        }
        return removed;
    }

    private void addEntryView(Entry<?> entry) {
        if (entry.isRecurring()) {
            Calendar calendar = entry.getCalendar();
            Map<LocalDate, List<Entry<?>>> entries = calendar.findEntries(this.getLoadStartDate(), this.getLoadEndDate(), this.getZoneId());
            for (LocalDate date : entries.keySet()) {
                List<Entry<?>> entriesOnDate = entries.get(date);
                if (entriesOnDate == null) continue;
                entriesOnDate.forEach(this::doAddEntryView);
            }
        } else {
            this.doAddEntryView(entry);
        }
    }

    private AllDayEntryView doAddEntryView(Entry<?> entry) {
        Callback<Entry<?>, AllDayEntryView> factory = ((AllDayView)this.getSkinnable()).getEntryViewFactory();
        AllDayEntryView view = (AllDayEntryView)factory.call(entry);
        view.applyCss();
        view.getProperties().put((Object)"control", (Object)this.getSkinnable());
        view.setManaged(false);
        int index = this.findIndex(entry);
        this.getChildren().add(index, (Object)view);
        if (!(entry instanceof DraggedEntry) && LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("added entry view " + entry.getTitle() + ", day = " + ((AllDayView)this.getSkinnable()).getDate());
        }
        return view;
    }

    private int findIndex(Entry<?> entry) {
        int childrenSize = this.getChildren().size();
        for (int i = 0; i < childrenSize; ++i) {
            AllDayEntryView view;
            Entry<?> viewEntry;
            Node node = (Node)this.getChildren().get(i);
            if (!(node instanceof AllDayEntryView) || !(viewEntry = (view = (AllDayEntryView)node).getEntry()).getStartAsZonedDateTime().isAfter(entry.getStartAsZonedDateTime())) continue;
            return i;
        }
        return childrenSize;
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        this.updateEntries("calendar changed");
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (!entry.isFullDay()) {
            return;
        }
        if (evt.isEntryRemoved()) {
            this.removeEntryView(entry);
            ((AllDayView)this.getSkinnable()).requestLayout();
        }
        if (evt.isEntryAdded() && this.isRelevant(entry)) {
            this.addEntryView(entry);
            ((AllDayView)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            if (entry.isFullDay()) {
                this.addEntryView(entry);
            } else {
                this.removeEntryView(entry);
            }
            ((AllDayView)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (!entry.isFullDay()) {
            return;
        }
        this.removeEntryView(entry);
        this.addEntryView(entry);
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        Entry<?> entry = evt.getEntry();
        if (!entry.isFullDay()) {
            return;
        }
        this.removeEntryView(entry);
        if (this.isRelevant(entry)) {
            if (entry.isRecurring()) {
                Calendar calendar = entry.getCalendar();
                Map<LocalDate, List<Entry<?>>> entriesMap = calendar.findEntries(this.getLoadStartDate(), this.getLoadEndDate(), this.getZoneId());
                List<Entry<?>> entries = entriesMap.get(((AllDayView)this.getSkinnable()).getDate());
                if (entries != null) {
                    for (Entry<?> e : entries) {
                        if (!e.getId().equals(entry.getId())) continue;
                        this.addEntryView(e);
                        break;
                    }
                }
            } else {
                this.addEntryView(entry);
            }
        }
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        List entryViews = this.getChildren().stream().filter(node -> node instanceof AllDayEntryView).map(node -> (AllDayEntryView)node).collect(Collectors.toList());
        List<Placement> placements = Resolver.resolve(entryViews);
        int maxPosition = 0;
        for (Placement p : placements) {
            maxPosition = Math.max(maxPosition, p.getColumnIndex());
        }
        Insets insets = ((AllDayView)this.getSkinnable()).getInsets();
        Insets extraPadding = ((AllDayView)this.getSkinnable()).getExtraPadding();
        double rowHeight = ((AllDayView)this.getSkinnable()).getRowHeight();
        double rowSpacing = ((AllDayView)this.getSkinnable()).getRowSpacing();
        return (double)(maxPosition + 1) * rowHeight + (double)maxPosition * rowSpacing + insets.getTop() + insets.getBottom() * extraPadding.getTop() + extraPadding.getBottom();
    }

    protected double computeMinHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected double computeMaxHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.computePrefHeight(width, topInset, rightInset, bottomInset, leftInset);
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        super.layoutChildren(contentX, contentY, contentWidth, contentHeight);
        double rowHeight = ((AllDayView)this.getSkinnable()).getRowHeight();
        double rowSpacing = ((AllDayView)this.getSkinnable()).getRowSpacing();
        double height = 0.0;
        Insets extraPadding = ((AllDayView)this.getSkinnable()).getExtraPadding();
        List entryViews = this.getChildren().stream().filter(node -> node instanceof AllDayEntryView).map(node -> (AllDayEntryView)node).collect(Collectors.toList());
        List<Placement> placements = Resolver.resolve(entryViews);
        for (Placement placement : placements) {
            EntryViewBase<?> view = placement.getEntryView();
            Entry<?> entry = view.getEntry();
            LocalDate startDate = ((AllDayView)this.getSkinnable()).getDate();
            if (((AllDayView)this.getSkinnable()).isAdjustToFirstDayOfWeek()) {
                startDate = Util.adjustToFirstDayOfWeek(((AllDayView)this.getSkinnable()).getDate(), ((AllDayView)this.getSkinnable()).getFirstDayOfWeek());
            }
            LocalDate endDate = startDate.plusDays(((AllDayView)this.getSkinnable()).getNumberOfDays() - 1);
            long deltaDays = ChronoUnit.DAYS.between(startDate, entry.getStartDate());
            long entryDurationInDays = ChronoUnit.DAYS.between(entry.getStartDate(), entry.getEndDate()) + 1L;
            if (deltaDays < 0L) {
                entryDurationInDays += deltaDays;
            }
            if (entry.getStartDate().isBefore(startDate)) {
                view.getProperties().put((Object)"startDate", (Object)startDate);
            } else {
                view.getProperties().put((Object)"startDate", (Object)entry.getStartDate());
            }
            if (entry.getEndDate().isAfter(endDate)) {
                view.getProperties().put((Object)"endDate", (Object)endDate);
            } else {
                view.getProperties().put((Object)"endDate", (Object)entry.getEndDate());
            }
            entryDurationInDays = Math.max(entryDurationInDays, 1L);
            double dayWidth = contentWidth / (double)((AllDayView)this.getSkinnable()).getNumberOfDays();
            double x = Math.max(0.0, contentX + (double)deltaDays * dayWidth);
            double y = contentY + (double)placement.getColumnIndex() * (rowHeight + rowSpacing) + extraPadding.getTop();
            double w = ((AllDayView)this.getSkinnable()).getNumberOfDays() == 1 ? contentWidth + 1.0 : Math.min((double)entryDurationInDays * dayWidth - ((AllDayView)this.getSkinnable()).getColumnSpacing(), contentWidth - x);
            view.setMaxHeight(rowHeight);
            view.resizeRelocate(this.snapPosition(x), this.snapPosition(y), this.snapSize(w), this.snapSize(rowHeight));
            height = Math.max(height, y + rowHeight);
        }
    }

    private void updateBackgrounds() {
        this.pane.getChildren().clear();
        ArrayList<ColumnConstraints> constraints = new ArrayList<ColumnConstraints>();
        int numberOfDays = ((AllDayView)this.getSkinnable()).getNumberOfDays();
        for (int i = 0; i < numberOfDays; ++i) {
            ColumnConstraints con = new ColumnConstraints();
            con.setPercentWidth(100.0 / (double)numberOfDays);
            constraints.add(con);
            Region region = new Region();
            region.setMaxWidth(Double.MAX_VALUE);
            region.getStyleClass().add((Object)ALL_DAY_BACKGROUND_REGION);
            GridPane.setHgrow((Node)region, (Priority)Priority.ALWAYS);
            GridPane.setVgrow((Node)region, (Priority)Priority.ALWAYS);
            GridPane.setFillHeight((Node)region, (Boolean)true);
            GridPane.setFillWidth((Node)region, (Boolean)true);
            int day = i;
            ((AllDayView)this.getSkinnable()).dateProperty().addListener(evt -> this.updateRegion(region, day));
            this.updateRegion(region, day);
            this.pane.add((Node)region, i, 0);
        }
        this.pane.getColumnConstraints().setAll(constraints);
        ((AllDayView)this.getSkinnable()).requestLayout();
    }

    private void updateRegion(Region region, int day) {
        AllDayView view = (AllDayView)this.getSkinnable();
        LocalDate startDate = view.getDate();
        if (view.isAdjustToFirstDayOfWeek()) {
            startDate = Util.adjustToFirstDayOfWeek(view.getDate(), view.getFirstDayOfWeek());
        }
        LocalDate date = this.getDate(startDate, day);
        if (view.isShowToday() && date.equals(view.getToday())) {
            if (!region.getStyleClass().contains((Object)ALL_DAY_BACKGROUND_REGION_TODAY)) {
                region.getStyleClass().add((Object)ALL_DAY_BACKGROUND_REGION_TODAY);
            }
        } else {
            region.getStyleClass().remove((Object)ALL_DAY_BACKGROUND_REGION_TODAY);
        }
        if (view.getWeekendDays().contains((Object)date.getDayOfWeek())) {
            if (!region.getStyleClass().contains((Object)ALL_DAY_BACKGROUND_REGION_WEEKEND)) {
                region.getStyleClass().add((Object)ALL_DAY_BACKGROUND_REGION_WEEKEND);
            }
        } else {
            region.getStyleClass().remove((Object)ALL_DAY_BACKGROUND_REGION_WEEKEND);
        }
    }

    private LocalDate getDate(LocalDate startDate, int dayCount) {
        return startDate.plusDays(dayCount);
    }

    @Override
    public String getLoaderName() {
        return "All Day View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        AllDayView view = (AllDayView)this.getSkinnable();
        if (view.isAdjustToFirstDayOfWeek()) {
            return Util.adjustToFirstDayOfWeek(view.getDate(), view.getFirstDayOfWeek());
        }
        return view.getDate();
    }

    @Override
    public LocalDate getLoadEndDate() {
        return this.getLoadStartDate().plusDays(((AllDayView)this.getSkinnable()).getNumberOfDays() - 1);
    }

    @Override
    public ZoneId getZoneId() {
        return ZoneId.systemDefault();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((AllDayView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((AllDayView)this.getSkinnable()).isCalendarVisible(calendar);
    }
}

