/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.AllDayEntryView;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SkinBase;

public class AllDayEntryViewSkin
extends SkinBase<AllDayEntryView> {
    protected Label titleLabel;
    private InvalidationListener updateViewListener = it -> this.updateView();
    private WeakInvalidationListener weakUpdateViewListener = new WeakInvalidationListener(this.updateViewListener);

    public AllDayEntryViewSkin(AllDayEntryView view) {
        super((Control)view);
        this.titleLabel = new Label();
        this.titleLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.titleLabel.setMouseTransparent(true);
        this.titleLabel.setManaged(false);
        Entry<?> entry = view.getEntry();
        entry.calendarProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        entry.fullDayProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        entry.titleProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        entry.intervalProperty().addListener((InvalidationListener)this.weakUpdateViewListener);
        this.updateView();
        this.getChildren().addAll((Object[])new Node[]{this.titleLabel});
    }

    protected void updateView() {
        AllDayEntryView view = (AllDayEntryView)this.getSkinnable();
        Entry<?> entry = view.getEntry();
        Calendar calendar = entry.getCalendar();
        if (calendar == null) {
            return;
        }
        view.getStyleClass().setAll((Object[])new String[]{"default-style-entry-small", calendar.getStyle() + "-entry-small", "default-style-entry-small-full-day", calendar.getStyle() + "-entry-small-full-day"});
        this.titleLabel.getStyleClass().setAll((Object[])new String[]{"default-style-entry-small-title-label", calendar.getStyle() + "-entry-small-title-label", "default-style-entry-small-title-label-full-day", calendar.getStyle() + "-entry-small-title-label-full-day"});
        this.titleLabel.setText(entry.getTitle());
        view.getStyleClass().add((Object)"default-style-entry-small-only");
    }

    protected void layoutChildren(double contentX, double contentY, double contentWidth, double contentHeight) {
        this.titleLabel.resizeRelocate(this.snapPosition(contentX), this.snapPosition(contentY), this.snapSize(contentWidth), this.snapSize(contentHeight));
    }

    protected double computePrefHeight(double width, double topInset, double rightInset, double bottomInset, double leftInset) {
        return this.titleLabel.prefHeight(-1.0) + topInset + bottomInset;
    }
}

