/*
 * Decompiled with CFR 0.152.
 */
package impl.com.calendarfx.view;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.CalendarEvent;
import com.calendarfx.model.CalendarSource;
import com.calendarfx.model.Entry;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.view.AgendaView;
import com.calendarfx.view.Messages;
import impl.com.calendarfx.view.DataLoader;
import impl.com.calendarfx.view.DateControlSkin;
import impl.com.calendarfx.view.LoadDataSettingsProvider;
import impl.com.calendarfx.view.util.Util;
import java.text.MessageFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javafx.beans.InvalidationListener;
import javafx.beans.WeakInvalidationListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.layout.BorderPane;

public class AgendaViewSkin
extends DateControlSkin<AgendaView>
implements LoadDataSettingsProvider {
    private static final String AGENDA_VIEW_PLACEHOLDER_LABEL = "placeholder-label";
    private ListView<AgendaView.AgendaEntry> listView;
    private DataLoader dataLoader = new DataLoader(this);
    private Label statusLabel;
    private InvalidationListener calendarVisibilityChanged = it -> this.updateList("calendar visibility changed");
    private WeakInvalidationListener weakCalendarVisibilityChanged = new WeakInvalidationListener(this.calendarVisibilityChanged);

    public AgendaViewSkin(AgendaView view) {
        super(view);
        this.listView = view.getListView();
        this.listView.setMinWidth(1.0);
        this.listView.setFixedCellSize(-1.0);
        this.listView.setSelectionModel(Util.createEmptySelectionModel());
        this.listView.getStyleClass().add((Object)"agenda-view-list");
        this.statusLabel = new Label();
        this.statusLabel.getStyleClass().add((Object)"status-label");
        this.statusLabel.setMaxWidth(Double.MAX_VALUE);
        this.statusLabel.visibleProperty().bind((ObservableValue)view.showStatusLabelProperty());
        this.statusLabel.managedProperty().bind((ObservableValue)this.statusLabel.visibleProperty());
        Label placeholderLabel = new Label(Messages.getString("AgendaViewSkin.NO_ENTRIES"));
        placeholderLabel.getStyleClass().add((Object)AGENDA_VIEW_PLACEHOLDER_LABEL);
        this.listView.setPlaceholder((Node)placeholderLabel);
        BorderPane borderPane = new BorderPane();
        borderPane.getStyleClass().add((Object)"container");
        this.getChildren().add((Object)borderPane);
        borderPane.setCenter(this.listView);
        borderPane.setTop((Node)this.statusLabel);
        InvalidationListener reloadListener = it -> this.updateList("a view property has changed, property = " + it.toString());
        view.lookAheadPeriodInDaysProperty().addListener(reloadListener);
        view.lookBackPeriodInDaysProperty().addListener(reloadListener);
        view.enableHyperlinksProperty().addListener(reloadListener);
        view.getCalendars().addListener(reloadListener);
        this.updateList("initial loading");
        this.listenToCalendars();
        view.getCalendars().addListener(observable -> this.listenToCalendars());
        view.dateProperty().addListener(reloadListener);
    }

    private void listenToCalendars() {
        for (Calendar c : ((AgendaView)this.getSkinnable()).getCalendars()) {
            ((AgendaView)this.getSkinnable()).getCalendarVisibilityProperty(c).addListener((InvalidationListener)this.weakCalendarVisibilityChanged);
        }
    }

    @Override
    protected void calendarChanged(Calendar calendar) {
        this.updateList("calendar changed");
    }

    @Override
    protected void entryIntervalChanged(CalendarEvent evt) {
        this.updateList(evt, "entry interval changed, entry = " + evt.getEntry());
    }

    @Override
    protected void entryRecurrenceRuleChanged(CalendarEvent evt) {
        this.updateList(evt, "entry recurrence rule changed, entry = " + evt.getEntry());
    }

    @Override
    protected void entryFullDayChanged(CalendarEvent evt) {
        this.updateList(evt, "entry full day changed changed, entry = " + evt.getEntry());
    }

    @Override
    protected void entryCalendarChanged(CalendarEvent evt) {
        this.updateList(evt, "entry calendar changed, entry = " + evt.getEntry());
    }

    @Override
    protected void refreshData() {
        this.updateList("data refresh");
    }

    private void updateList(CalendarEvent evt, String reason) {
        Entry<?> entry = evt.getEntry();
        if (this.isRelevant(entry)) {
            this.updateList(reason);
        }
    }

    private void updateList(String reason) {
        if (LoggingDomain.VIEW.isLoggable(Level.FINE)) {
            LoggingDomain.VIEW.fine("updating list inside agenda view, reason = " + reason);
        }
        HashMap dataMap = new HashMap();
        this.dataLoader.loadEntries(dataMap);
        ArrayList<AgendaView.AgendaEntry> listEntries = new ArrayList<AgendaView.AgendaEntry>();
        for (LocalDate date : dataMap.keySet()) {
            AgendaView.AgendaEntry listViewEntry = new AgendaView.AgendaEntry(date);
            for (Entry entry : (List)dataMap.get(date)) {
                listViewEntry.getEntries().add(entry);
            }
            listEntries.add(listViewEntry);
        }
        Collections.sort(listEntries);
        this.listView.getItems().setAll(listEntries);
        DateTimeFormatter formatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.LONG);
        String startTime = formatter.format(this.getLoadStartDate());
        String endTime = formatter.format(this.getLoadEndDate());
        this.statusLabel.setText(MessageFormat.format(Messages.getString("AgendaViewSkin.AGENDA_TIME_RANGE"), startTime, endTime));
    }

    @Override
    public String getLoaderName() {
        return "Agenda View";
    }

    @Override
    public LocalDate getLoadStartDate() {
        return ((AgendaView)this.getSkinnable()).getDate().minusDays(((AgendaView)this.getSkinnable()).getLookBackPeriodInDays());
    }

    @Override
    public LocalDate getLoadEndDate() {
        return ((AgendaView)this.getSkinnable()).getDate().plusDays(((AgendaView)this.getSkinnable()).getLookAheadPeriodInDays());
    }

    @Override
    public ZoneId getZoneId() {
        return ZoneId.systemDefault();
    }

    @Override
    public List<CalendarSource> getCalendarSources() {
        return ((AgendaView)this.getSkinnable()).getCalendarSources();
    }

    @Override
    public Control getControl() {
        return this.getSkinnable();
    }

    @Override
    public boolean isCalendarVisible(Calendar calendar) {
        return ((AgendaView)this.getSkinnable()).isCalendarVisible(calendar);
    }
}

