/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.util.Util;
import com.calendarfx.view.print.TimeRangeField;
import com.calendarfx.view.print.ViewType;
import com.calendarfx.view.print.ViewTypeControl;
import impl.com.calendarfx.view.print.TimeRangeViewSkin;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.Month;
import java.time.YearMonth;
import java.time.temporal.ChronoField;
import java.time.temporal.WeekFields;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.ReadOnlyIntegerWrapper;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;

public class TimeRangeView
extends ViewTypeControl {
    private static final String DEFAULT_STYLE = "time-range-view";
    private final TimeRangeField startField = new TimeRangeField();
    private final TimeRangeField endField = new TimeRangeField(true);
    private final ObjectProperty<LocalDate> today = new SimpleObjectProperty((Object)this, "today", (Object)LocalDate.now());
    private final ObjectProperty<WeekFields> weekFields = new SimpleObjectProperty((Object)this, "weekFields", (Object)WeekFields.ISO);
    private final ReadOnlyObjectWrapper<LocalDate> startDate = new ReadOnlyObjectWrapper((Object)this, "startDate");
    private final ReadOnlyObjectWrapper<LocalDate> endDate = new ReadOnlyObjectWrapper((Object)this, "endDate");
    private final ReadOnlyIntegerWrapper unitsToPrint = new ReadOnlyIntegerWrapper((Object)this, "unitsToPrint");

    public TimeRangeView() {
        this.startField.viewTypeProperty().bind(this.viewTypeProperty());
        this.startField.todayProperty().bind(this.todayProperty());
        this.startField.weekFieldsProperty().bind(this.weekFieldsProperty());
        InvalidationListener startDateUpdater = obs -> this.updateStartDate();
        this.startField.valueProperty().addListener(startDateUpdater);
        this.startField.onDateProperty().addListener(startDateUpdater);
        this.startField.onWeekNumberProperty().addListener(startDateUpdater);
        this.startField.monthYearProperty().addListener(startDateUpdater);
        this.startField.afterUnitsProperty().addListener(startDateUpdater);
        this.startField.todayProperty().addListener(startDateUpdater);
        this.endField.viewTypeProperty().bind(this.viewTypeProperty());
        this.endField.todayProperty().bind(this.todayProperty());
        this.endField.weekFieldsProperty().bind(this.weekFieldsProperty());
        InvalidationListener endDateUpdater = obs -> this.updateEndDate();
        this.endField.valueProperty().addListener(endDateUpdater);
        this.endField.onDateProperty().addListener(endDateUpdater);
        this.endField.onWeekNumberProperty().addListener(endDateUpdater);
        this.endField.monthYearProperty().addListener(endDateUpdater);
        this.endField.afterUnitsProperty().addListener(endDateUpdater);
        this.endField.todayProperty().addListener(endDateUpdater);
        this.startDate.addListener(obs -> {
            this.fixEndField();
            this.updateEndDate();
            this.updateUnitsToPrint();
        });
        this.endDate.addListener(obs -> {
            this.fixStartField();
            this.updateUnitsToPrint();
        });
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        this.updateStartDate();
        this.updateEndDate();
        this.updateUnitsToPrint();
    }

    public final ObjectProperty<LocalDate> todayProperty() {
        return this.today;
    }

    public final void setToday(LocalDate date) {
        Objects.requireNonNull(date);
        this.todayProperty().set((Object)date);
    }

    public final LocalDate getToday() {
        return (LocalDate)this.todayProperty().get();
    }

    public final ObjectProperty<WeekFields> weekFieldsProperty() {
        return this.weekFields;
    }

    public final void setWeekFields(WeekFields fields) {
        Objects.requireNonNull(fields);
        this.weekFieldsProperty().set((Object)fields);
    }

    public final WeekFields getWeekFields() {
        return (WeekFields)this.weekFieldsProperty().get();
    }

    public final void requestStartDate(LocalDate date) {
        if (date == null) {
            return;
        }
        switch (this.getViewType()) {
            case DAY_VIEW: {
                if (date.equals(this.getToday())) {
                    this.startField.setValue(TimeRangeField.TimeRangeFieldValue.TODAY);
                    this.endField.setValue(TimeRangeField.TimeRangeFieldValue.TODAY);
                    break;
                }
                if (date.equals(this.getTomorrow())) {
                    this.startField.setValue(TimeRangeField.TimeRangeFieldValue.TOMORROW);
                    this.endField.setValue(TimeRangeField.TimeRangeFieldValue.TOMORROW);
                    break;
                }
                this.startField.setValue(TimeRangeField.TimeRangeFieldValue.ON_DATE);
                this.startField.setOnDate(date);
                this.endField.setValue(TimeRangeField.TimeRangeFieldValue.ON_DATE);
                this.endField.setOnDate(date);
                break;
            }
            case WEEK_VIEW: {
                if (date.equals(this.getThisWeekDate())) {
                    this.startField.setValue(TimeRangeField.TimeRangeFieldValue.THIS_WEEK);
                    this.endField.setValue(TimeRangeField.TimeRangeFieldValue.THIS_WEEK);
                    break;
                }
                if (date.equals(this.getNextWeekDate())) {
                    this.startField.setValue(TimeRangeField.TimeRangeFieldValue.NEXT_WEEK);
                    this.endField.setValue(TimeRangeField.TimeRangeFieldValue.NEXT_WEEK);
                    break;
                }
                this.startField.setValue(TimeRangeField.TimeRangeFieldValue.ON_DATE);
                this.startField.setOnDate(date);
                this.endField.setValue(TimeRangeField.TimeRangeFieldValue.ON_DATE);
                this.endField.setOnDate(date);
                break;
            }
            case MONTH_VIEW: {
                if (date.equals(this.getThisMonthDate())) {
                    this.startField.setValue(TimeRangeField.TimeRangeFieldValue.THIS_MONTH);
                    this.endField.setValue(TimeRangeField.TimeRangeFieldValue.THIS_MONTH);
                    break;
                }
                if (date.equals(this.getNextMonthDate())) {
                    this.startField.setValue(TimeRangeField.TimeRangeFieldValue.NEXT_MONTH);
                    this.endField.setValue(TimeRangeField.TimeRangeFieldValue.NEXT_MONTH);
                    break;
                }
                TimeRangeField.TimeRangeFieldValue month = TimeRangeField.TimeRangeFieldValue.getFromMonth(date.getMonth());
                int year = date.getYear();
                this.endField.setValue(month);
                this.endField.setMonthYear(year);
                this.startField.setValue(month);
                this.startField.setMonthYear(year);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet!: " + (Object)((Object)this.getViewType()));
            }
        }
    }

    protected Skin<?> createDefaultSkin() {
        return new TimeRangeViewSkin(this);
    }

    public final TimeRangeField getStartField() {
        return this.startField;
    }

    public final TimeRangeField getEndField() {
        return this.endField;
    }

    public final ReadOnlyObjectProperty<LocalDate> startDateProperty() {
        return this.startDate.getReadOnlyProperty();
    }

    public final LocalDate getStartDate() {
        return (LocalDate)this.startDate.get();
    }

    private void setStartDate(LocalDate startDate) {
        if (!Objects.requireNonNull(startDate).equals(this.getStartDate())) {
            this.startDate.set((Object)startDate);
        }
    }

    private LocalDate getTomorrow() {
        return this.getToday().plusDays(1L);
    }

    private LocalDate getThisWeekDate() {
        return this.getStartOfWeek(this.getToday());
    }

    private LocalDate getNextWeekDate() {
        return this.getThisWeekDate().plusWeeks(1L);
    }

    private LocalDate getStartOfWeek(LocalDate date) {
        return Util.adjustToFirstDayOfWeek(date, this.getWeekFields().getFirstDayOfWeek());
    }

    private LocalDate getEndOfWeek(LocalDate date) {
        return Util.adjustToLastDayOfWeek(date, this.getWeekFields().getFirstDayOfWeek());
    }

    private LocalDate getThisMonthDate() {
        return this.getStartOfMonth(this.getToday());
    }

    private LocalDate getNextMonthDate() {
        return this.getThisMonthDate().plusMonths(1L);
    }

    private LocalDate getStartOfMonth(LocalDate date) {
        return YearMonth.of(date.getYear(), date.getMonthValue()).atDay(1);
    }

    private LocalDate getEndOfMonth(LocalDate date) {
        return YearMonth.of(date.getYear(), date.getMonthValue()).atEndOfMonth();
    }

    private void updateStartDate() {
        switch (this.startField.getValue()) {
            case TODAY: {
                this.setStartDate(this.getToday());
                break;
            }
            case TOMORROW: {
                this.setStartDate(this.getTomorrow());
                break;
            }
            case ON_DATE: {
                if (this.getViewType() == ViewType.DAY_VIEW) {
                    this.setStartDate(this.startField.getOnDate());
                    break;
                }
                this.setStartDate(this.getStartOfWeek(this.startField.getOnDate()));
                break;
            }
            case THIS_WEEK: {
                this.setStartDate(this.getThisWeekDate());
                break;
            }
            case NEXT_WEEK: {
                this.setStartDate(this.getNextWeekDate());
                break;
            }
            case ON_WEEK_NUMBER: {
                int startWeekNumber = this.getToday().get(this.getWeekFields().weekOfWeekBasedYear());
                int diff = this.startField.getOnWeekNumber() - startWeekNumber;
                this.setStartDate(this.getToday().plusWeeks(diff).with(ChronoField.DAY_OF_WEEK, this.getWeekFields().getFirstDayOfWeek().getValue()));
                break;
            }
            case THIS_MONTH: {
                this.setStartDate(this.getThisMonthDate());
                break;
            }
            case NEXT_MONTH: {
                this.setStartDate(this.getNextMonthDate());
                break;
            }
            case JANUARY: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.JANUARY.getValue()).atDay(1));
                break;
            }
            case FEBRUARY: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.FEBRUARY.getValue()).atDay(1));
                break;
            }
            case MARCH: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.MARCH.getValue()).atDay(1));
                break;
            }
            case APRIL: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.APRIL.getValue()).atDay(1));
                break;
            }
            case MAY: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.MAY.getValue()).atDay(1));
                break;
            }
            case JUNE: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.JUNE.getValue()).atDay(1));
                break;
            }
            case JULY: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.JULY.getValue()).atDay(1));
                break;
            }
            case AUGUST: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.AUGUST.getValue()).atDay(1));
                break;
            }
            case SEPTEMBER: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.SEPTEMBER.getValue()).atDay(1));
                break;
            }
            case OCTOBER: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.OCTOBER.getValue()).atDay(1));
                break;
            }
            case NOVEMBER: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.NOVEMBER.getValue()).atDay(1));
                break;
            }
            case DECEMBER: {
                this.setStartDate(YearMonth.of((int)this.startField.getMonthYear(), Month.DECEMBER.getValue()).atDay(1));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Value not supported!");
            }
        }
    }

    public final ReadOnlyObjectProperty<LocalDate> endDateProperty() {
        return this.endDate.getReadOnlyProperty();
    }

    public final LocalDate getEndDate() {
        return (LocalDate)this.endDate.get();
    }

    private void setEndDate(LocalDate endDate) {
        if (!Objects.requireNonNull(endDate).equals(this.getEndDate())) {
            this.endDate.set((Object)endDate);
        }
    }

    private void updateEndDate() {
        switch (this.endField.getValue()) {
            case TODAY: {
                this.setEndDate(this.getToday());
                break;
            }
            case TOMORROW: {
                this.setEndDate(this.getTomorrow());
                break;
            }
            case ON_DATE: {
                if (this.getViewType() == ViewType.DAY_VIEW) {
                    this.setEndDate(this.endField.getOnDate());
                    break;
                }
                this.setEndDate(this.getEndOfWeek(this.endField.getOnDate()));
                break;
            }
            case THIS_WEEK: {
                this.setEndDate(this.getEndOfWeek(this.getToday()));
                break;
            }
            case NEXT_WEEK: {
                this.setEndDate(this.getEndOfWeek(this.getToday()).plusWeeks(1L));
                break;
            }
            case ON_WEEK_NUMBER: {
                int startWeekNumber = this.getToday().get(this.getWeekFields().weekOfWeekBasedYear());
                int difference = this.endField.getOnWeekNumber() - startWeekNumber;
                this.setEndDate(this.getToday().plusWeeks(difference).with(ChronoField.DAY_OF_WEEK, this.getWeekFields().getFirstDayOfWeek().plus(6L).getValue()));
                break;
            }
            case THIS_MONTH: {
                this.setEndDate(this.getEndOfMonth(this.getToday()));
                break;
            }
            case NEXT_MONTH: {
                this.setEndDate(this.getEndOfMonth(this.getToday()).plusMonths(1L));
                break;
            }
            case JANUARY: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.JANUARY.getValue()).atEndOfMonth());
                break;
            }
            case FEBRUARY: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.FEBRUARY.getValue()).atEndOfMonth());
                break;
            }
            case MARCH: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.MARCH.getValue()).atEndOfMonth());
                break;
            }
            case APRIL: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.APRIL.getValue()).atEndOfMonth());
                break;
            }
            case MAY: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.MAY.getValue()).atEndOfMonth());
                break;
            }
            case JUNE: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.JUNE.getValue()).atEndOfMonth());
                break;
            }
            case JULY: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.JULY.getValue()).atEndOfMonth());
                break;
            }
            case AUGUST: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.AUGUST.getValue()).atEndOfMonth());
                break;
            }
            case SEPTEMBER: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.SEPTEMBER.getValue()).atEndOfMonth());
                break;
            }
            case OCTOBER: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.OCTOBER.getValue()).atEndOfMonth());
                break;
            }
            case NOVEMBER: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.NOVEMBER.getValue()).atEndOfMonth());
                break;
            }
            case DECEMBER: {
                this.setEndDate(YearMonth.of((int)this.endField.getMonthYear(), Month.DECEMBER.getValue()).atEndOfMonth());
                break;
            }
            case AFTER: {
                int units = this.endField.getAfterUnits();
                if (this.getViewType() == ViewType.DAY_VIEW) {
                    this.setEndDate(this.getStartDate().plusDays(units - 1));
                    break;
                }
                if (this.getViewType() == ViewType.WEEK_VIEW) {
                    this.setEndDate(this.getStartOfWeek(this.getStartDate()).plusWeeks(units).minusDays(1L));
                    break;
                }
                this.setEndDate(this.getStartOfMonth(this.getStartDate()).plusMonths(units).minusDays(1L));
                break;
            }
            default: {
                throw new UnsupportedOperationException("Value not supported!");
            }
        }
    }

    private void fixEndField() {
        LocalDate mStartDate = this.getStartDate();
        LocalDate mEndDate = this.getEndDate();
        if (mStartDate == null || mEndDate == null) {
            return;
        }
        if (mEndDate.isBefore(mStartDate)) {
            this.endField.setValue(this.startField.getValue());
            if (this.startField.getOnDate() != null) {
                this.endField.setOnDate(this.startField.getOnDate());
            } else if (this.startField.getOnWeekNumber() != null) {
                this.endField.setOnWeekNumber(this.startField.getOnWeekNumber());
            } else if (this.startField.getMonthYear() != null) {
                this.endField.setMonthYear(this.startField.getMonthYear());
            } else if (this.startField.getAfterUnits() != null) {
                this.endField.setAfterUnits(this.startField.getAfterUnits());
            }
        }
    }

    private void fixStartField() {
        LocalDate mStartDate = this.getStartDate();
        LocalDate mEndDate = this.getEndDate();
        if (mStartDate == null || mEndDate == null) {
            return;
        }
        if (mEndDate.isBefore(mStartDate)) {
            this.startField.setValue(this.endField.getValue());
            if (this.startField.getOnDate() != null) {
                this.startField.setOnDate(this.endField.getOnDate());
            } else if (this.endField.getOnWeekNumber() != null) {
                this.startField.setOnWeekNumber(this.endField.getOnWeekNumber());
            } else if (this.endField.getMonthYear() != null) {
                this.startField.setMonthYear(this.endField.getMonthYear());
            } else if (this.endField.getAfterUnits() != null) {
                this.startField.setAfterUnits(this.endField.getAfterUnits());
            }
        }
    }

    public final ReadOnlyIntegerProperty unitsToPrintProperty() {
        return this.unitsToPrint.getReadOnlyProperty();
    }

    public final int getUnitsToPrint() {
        return this.unitsToPrint.get();
    }

    private void setUnitsToPrint(int unitsToPrint) {
        this.unitsToPrint.set(unitsToPrint);
    }

    private void updateUnitsToPrint() {
        block7: {
            block6: {
                LocalDate mStartDate = this.getStartDate();
                LocalDate mEndDate = this.getEndDate();
                if (mStartDate == null || mEndDate == null) {
                    return;
                }
                Duration duration = Duration.between(mStartDate.atTime(LocalTime.MIN), mEndDate.atStartOfDay().plusDays(1L));
                long days = duration.toDays();
                if (days <= 0L) break block6;
                switch (this.getViewType()) {
                    case DAY_VIEW: {
                        this.setUnitsToPrint((int)days);
                        break block7;
                    }
                    case WEEK_VIEW: {
                        this.setUnitsToPrint((int)(days / 7L));
                        break block7;
                    }
                    case MONTH_VIEW: {
                        this.setUnitsToPrint((int)days / 30);
                        break block7;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not supported yet!: " + (Object)((Object)this.getViewType()));
                    }
                }
            }
            this.setUnitsToPrint(0);
        }
    }
}

