/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.model.CalendarSource;
import com.calendarfx.util.LoggingDomain;
import com.calendarfx.util.Util;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.SourceView;
import com.calendarfx.view.print.OptionsView;
import com.calendarfx.view.print.PaperView;
import com.calendarfx.view.print.PreviewPane;
import com.calendarfx.view.print.PrintablePage;
import com.calendarfx.view.print.SettingsView;
import com.calendarfx.view.print.TimeRangeView;
import com.calendarfx.view.print.ViewTypeControl;
import impl.com.calendarfx.view.print.PrintViewSkin;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.temporal.WeekFields;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.print.JobSettings;
import javafx.print.PageLayout;
import javafx.print.PageOrientation;
import javafx.print.Paper;
import javafx.print.Printer;
import javafx.print.PrinterJob;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Skin;
import javafx.scene.transform.Scale;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;

public class PrintView
extends ViewTypeControl {
    private static final String DEFAULT_STYLE = "print-view";
    private final PreviewPane previewPane = new PreviewPane();
    private final SettingsView settingsView = new SettingsView();
    private final ObservableList<CalendarSource> calendarSources = FXCollections.observableArrayList();
    private final ObjectProperty<LocalDate> today = new SimpleObjectProperty((Object)this, "today", (Object)LocalDate.now());
    private final ObjectProperty<DateControl.Layout> layout = new SimpleObjectProperty((Object)this, "layout", (Object)DateControl.Layout.STANDARD);
    private final ObjectProperty<WeekFields> weekFields = new SimpleObjectProperty((Object)this, "weekFields", (Object)WeekFields.ISO);
    private final ObjectProperty<EventHandler<ActionEvent>> onContinue = new SimpleObjectProperty((Object)this, "onContinue", evt -> this.doPrint());
    private final ObjectProperty<EventHandler<ActionEvent>> onCancel = new SimpleObjectProperty((Object)this, "onCancel", evt -> this.hide());
    private Stage dialog;
    private static final Util.Converter<Boolean, DateControl.Layout> LAYOUT_BOOLEAN_CONVERTER = new Util.Converter<Boolean, DateControl.Layout>(){

        @Override
        public Boolean toLeft(DateControl.Layout right) {
            return right == DateControl.Layout.SWIMLANE;
        }

        @Override
        public DateControl.Layout toRight(Boolean left) {
            return Boolean.TRUE.equals(left) ? DateControl.Layout.SWIMLANE : DateControl.Layout.STANDARD;
        }
    };

    public PrintView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        PaperView paperView = this.settingsView.getPaperView();
        OptionsView optionsView = this.settingsView.getOptionsView();
        TimeRangeView timeRangeView = this.settingsView.getTimeRangeView();
        SourceView sourceView = this.settingsView.getSourceView();
        PrintablePage printablePage = this.previewPane.getPrintablePage();
        paperView.viewTypeProperty().bindBidirectional(this.viewTypeProperty());
        timeRangeView.weekFieldsProperty().bind(this.weekFieldsProperty());
        timeRangeView.todayProperty().bind(this.todayProperty());
        Util.bindBidirectional(optionsView.showSwimlaneLayoutProperty(), this.layoutProperty(), LAYOUT_BOOLEAN_CONVERTER);
        printablePage.weekFieldsProperty().bind(this.weekFieldsProperty());
        printablePage.viewTypeProperty().bind(paperView.viewTypeProperty());
        printablePage.paperProperty().bind(paperView.paperProperty());
        printablePage.marginTypeProperty().bind(paperView.marginTypeProperty());
        printablePage.bottomMarginProperty().bind((ObservableValue)paperView.bottomMarginProperty());
        printablePage.leftMarginProperty().bind((ObservableValue)paperView.leftMarginProperty());
        printablePage.rightMarginProperty().bind((ObservableValue)paperView.rightMarginProperty());
        printablePage.topMarginProperty().bind((ObservableValue)paperView.topMarginProperty());
        printablePage.printStartDateProperty().bind(timeRangeView.startDateProperty());
        printablePage.printEndDateProperty().bind(timeRangeView.endDateProperty());
        printablePage.showAllDayEntriesProperty().bind((ObservableValue)optionsView.showAllDayEntriesProperty());
        printablePage.showMiniCalendarsProperty().bind((ObservableValue)optionsView.showMiniCalendarsProperty());
        printablePage.showCalendarKeysProperty().bind((ObservableValue)optionsView.showCalendarKeysProperty());
        printablePage.showTimedEntriesProperty().bind((ObservableValue)optionsView.showTimedEntriesProperty());
        printablePage.showEntryDetailsProperty().bind((ObservableValue)optionsView.showEntryDetailsProperty());
        printablePage.layoutProperty().bindBidirectional(this.layoutProperty());
        Bindings.bindContent(sourceView.getCalendarSources(), this.getCalendarSources());
        Bindings.bindContent(sourceView.getCalendarVisibilityMap(), printablePage.getCalendarVisibilityMap());
        Bindings.bindContent(printablePage.getCalendarSources(), this.getCalendarSources());
    }

    public final ObservableList<CalendarSource> getCalendarSources() {
        return this.calendarSources;
    }

    public final ObjectProperty<LocalDate> todayProperty() {
        return this.today;
    }

    public final void setToday(LocalDate date) {
        Objects.requireNonNull(date);
        this.todayProperty().set((Object)date);
    }

    public final LocalDate getToday() {
        return (LocalDate)this.todayProperty().get();
    }

    public final ObjectProperty<DateControl.Layout> layoutProperty() {
        return this.layout;
    }

    public final void setLayout(DateControl.Layout layout) {
        Objects.requireNonNull(layout);
        this.layoutProperty().set((Object)layout);
    }

    public final DateControl.Layout getLayout() {
        return (DateControl.Layout)((Object)this.layoutProperty().get());
    }

    public final ObjectProperty<WeekFields> weekFieldsProperty() {
        return this.weekFields;
    }

    public final void setWeekFields(WeekFields weekFields) {
        Objects.requireNonNull(weekFields);
        this.weekFieldsProperty().set((Object)weekFields);
    }

    public final WeekFields getWeekFields() {
        return (WeekFields)this.weekFieldsProperty().get();
    }

    public final DayOfWeek getFirstDayOfWeek() {
        return this.getWeekFields().getFirstDayOfWeek();
    }

    public final void requestStartDate(LocalDate date) {
        this.settingsView.getTimeRangeView().requestStartDate(date);
    }

    protected Skin<?> createDefaultSkin() {
        return new PrintViewSkin(this);
    }

    public final PreviewPane getPreviewPane() {
        return this.previewPane;
    }

    public final SettingsView getSettingsView() {
        return this.settingsView;
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onContinueProperty() {
        return this.onContinue;
    }

    public final EventHandler<ActionEvent> getOnContinue() {
        return (EventHandler)this.onContinueProperty().get();
    }

    public final void setOnContinue(EventHandler<ActionEvent> handler) {
        this.onContinueProperty().set(handler);
    }

    public final ObjectProperty<EventHandler<ActionEvent>> onCancelProperty() {
        return this.onCancel;
    }

    public final EventHandler<ActionEvent> getOnCancel() {
        return (EventHandler)this.onCancelProperty().get();
    }

    public final void setOnCancel(EventHandler<ActionEvent> handler) {
        this.onCancelProperty().set(handler);
    }

    public final void show(Window owner) {
        if (this.dialog != null) {
            this.dialog.show();
        } else {
            Scene scene = new Scene((Parent)this);
            this.dialog = new Stage();
            this.dialog.initOwner(owner);
            this.dialog.setScene(scene);
            this.dialog.sizeToScene();
            this.dialog.centerOnScreen();
            this.dialog.setTitle(Messages.getString("PrintView.TITLE_LABEL"));
            this.dialog.initModality(Modality.APPLICATION_MODAL);
            this.dialog.show();
        }
    }

    public final void hide() {
        if (this.dialog != null) {
            this.dialog.hide();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPrint() {
        this.hide();
        PrintablePage pageInView = this.previewPane.getPrintablePage();
        PrintablePage pageToPrint = new PrintablePage();
        try {
            pageInView.bindPage(pageToPrint);
            Printer printer = Printer.getDefaultPrinter();
            LoggingDomain.PRINTING.fine("printer = " + printer);
            PageLayout layout = null;
            Paper paper = pageInView.getPaper();
            PageOrientation pageOrientation = pageInView.getViewType().getPageOrientation();
            PaperView.MarginType marginType = pageInView.getMarginType();
            LoggingDomain.PRINTING.fine("paper = " + paper);
            LoggingDomain.PRINTING.fine("pageOrientation = " + pageOrientation);
            LoggingDomain.PRINTING.fine("marginType = " + (Object)((Object)marginType));
            LoggingDomain.PRINTING.fine("custom margins = left: " + pageInView.getLeftMargin() + ", right: " + pageInView.getRightMargin() + ", top: " + pageInView.getTopMargin() + ", bottom: " + pageInView.getBottomMargin());
            switch (marginType) {
                case DEFAULT: {
                    layout = printer.createPageLayout(paper, pageOrientation, Printer.MarginType.DEFAULT);
                    break;
                }
                case MINIMUM: {
                    layout = printer.createPageLayout(paper, pageOrientation, Printer.MarginType.HARDWARE_MINIMUM);
                    break;
                }
                case CUSTOM: {
                    layout = printer.createPageLayout(paper, pageOrientation, pageInView.getLeftMargin(), pageInView.getRightMargin(), pageInView.getTopMargin(), pageInView.getBottomMargin());
                }
            }
            double pageWidth = pageToPrint.prefWidth(-1.0);
            double pageHeight = pageToPrint.prefHeight(-1.0);
            double printableWidth = layout.getPrintableWidth();
            double printableHeight = layout.getPrintableHeight();
            double scaleX = printableWidth / pageWidth;
            double scaleY = printableHeight / pageHeight;
            double scale = Math.min(scaleX, scaleY);
            LoggingDomain.PRINTING.fine("pageWidth / pageHeight = " + pageWidth + " / " + pageHeight);
            LoggingDomain.PRINTING.fine("printableWidth / printableHeight = " + printableWidth + " / " + printableHeight);
            LoggingDomain.PRINTING.fine("scaleX / scaleY = " + scaleX + " / " + scaleY);
            LoggingDomain.PRINTING.fine("scale = " + scale);
            pageToPrint.applyCss();
            pageToPrint.layout();
            pageToPrint.getTransforms().add((Object)new Scale(scale, scale));
            double translateX = (printableWidth - pageWidth * scale) / 2.0;
            double translateY = (printableHeight - pageHeight * scale) / 2.0;
            LoggingDomain.PRINTING.fine("translateX / translateY = " + translateX + " / " + translateY);
            pageToPrint.setTranslateX(translateX);
            pageToPrint.setTranslateY(translateY);
            PrinterJob job = PrinterJob.createPrinterJob((Printer)printer);
            JobSettings settings = job.getJobSettings();
            settings.setJobName(Messages.getString("PrintView.TITLE_LABEL"));
            settings.setPageLayout(layout);
            if (job.showPrintDialog(this.getScene().getWindow())) {
                boolean success;
                while ((success = job.printPage((Node)pageToPrint)) && pageToPrint.next()) {
                }
                job.endJob();
            }
        }
        finally {
            pageInView.unbindPage(pageToPrint);
        }
    }
}

