/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.print;

import com.calendarfx.view.CalendarFXControl;
import com.calendarfx.view.print.PrintablePage;
import com.calendarfx.view.print.ZoomPane;
import impl.com.calendarfx.view.print.PreviewPaneSkin;
import java.time.LocalDate;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.scene.control.Skin;
import javafx.scene.layout.Region;

public class PreviewPane
extends CalendarFXControl {
    public static final String DEFAULT_STYLE = "print-preview";
    private final PrintablePage printablePage = new PrintablePage();
    private final ZoomPane zoomPane = new ZoomPane((Region)this.printablePage);
    private final ObjectProperty<LocalDate> printStartDate = new SimpleObjectProperty((Object)this, "printStartDate");
    private final ObjectProperty<LocalDate> printEndDate = new SimpleObjectProperty((Object)this, "printEndDate");

    public PreviewPane() {
        this.getStyleClass().add((Object)DEFAULT_STYLE);
        InvalidationListener layoutListener = obs -> this.zoomPane.requestLayout();
        this.printablePage.viewTypeProperty().addListener(layoutListener);
        this.printablePage.paperProperty().addListener(layoutListener);
    }

    protected Skin<?> createDefaultSkin() {
        return new PreviewPaneSkin(this);
    }

    public final PrintablePage getPrintablePage() {
        return this.printablePage;
    }

    public final ZoomPane getZoomPane() {
        return this.zoomPane;
    }

    public final ObjectProperty<LocalDate> printStartDateProperty() {
        return this.printStartDate;
    }

    public final LocalDate getPrintStartDate() {
        return (LocalDate)this.printStartDateProperty().get();
    }

    public final void setPrintStartDate(LocalDate date) {
        this.printStartDateProperty().set((Object)date);
    }

    public final ObjectProperty<LocalDate> printEndDateProperty() {
        return this.printEndDate;
    }

    public final LocalDate getPrintEndDate() {
        return (LocalDate)this.printEndDateProperty().get();
    }

    public final void setPrintEndDate(LocalDate date) {
        this.printEndDateProperty().set((Object)date);
    }
}

