/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.CalendarView;
import com.calendarfx.view.DateControl;
import com.calendarfx.view.Messages;
import com.calendarfx.view.popover.EntryDetailsView;
import com.calendarfx.view.popover.EntryHeaderView;
import com.calendarfx.view.popover.EntryPropertiesView;
import com.calendarfx.view.popover.PopOverContentPane;
import com.calendarfx.view.popover.PopOverTitledPane;
import java.util.List;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.util.Duration;
import org.controlsfx.control.PopOver;

public class EntryPopOverContentPane
extends PopOverContentPane {
    private Entry<?> entry;
    private DateControl dateControl;
    private PopOver popOver;

    public EntryPopOverContentPane(PopOver popOver, DateControl dateControl, Entry<?> entry) {
        this.getStylesheets().add((Object)CalendarView.class.getResource("calendar.css").toExternalForm());
        this.popOver = popOver;
        this.dateControl = dateControl;
        this.entry = Objects.requireNonNull(entry);
        EntryDetailsView details = new EntryDetailsView(entry);
        PopOverTitledPane detailsPane = new PopOverTitledPane(Messages.getString("EntryPopOverContentPane.DETAILS"), (Node)details);
        EntryHeaderView header = new EntryHeaderView(entry, (List<Calendar>)dateControl.getCalendars());
        this.setHeader((Node)header);
        if (Boolean.getBoolean("calendarfx.developer")) {
            EntryPropertiesView properties = new EntryPropertiesView(entry);
            PopOverTitledPane propertiesPane = new PopOverTitledPane("Properties", (Node)properties);
            this.getPanes().addAll((Object[])new TitledPane[]{detailsPane, propertiesPane});
        } else {
            this.getPanes().addAll((Object[])new TitledPane[]{detailsPane});
        }
        this.setExpandedPane(detailsPane);
        InvalidationListener listener = obs -> {
            if (entry.isFullDay() && !popOver.isDetached()) {
                popOver.setDetached(true);
            }
        };
        entry.fullDayProperty().addListener(listener);
        popOver.setOnHidden(evt -> entry.fullDayProperty().removeListener(listener));
        entry.calendarProperty().addListener(it -> {
            if (entry.getCalendar() == null) {
                popOver.hide(Duration.ZERO);
            }
        });
    }

    public final PopOver getPopOver() {
        return this.popOver;
    }

    public final DateControl getDateControl() {
        return this.dateControl;
    }

    public final Entry<?> getEntry() {
        return this.entry;
    }
}

