/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Entry;
import com.calendarfx.util.Util;
import com.calendarfx.view.Messages;
import com.calendarfx.view.RecurrenceView;
import com.calendarfx.view.TimeField;
import com.calendarfx.view.popover.EntryPopOverPane;
import com.calendarfx.view.popover.RecurrencePopup;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Comparator;
import java.util.Set;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.HPos;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.DatePicker;
import javafx.scene.control.Label;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.util.StringConverter;

public class EntryDetailsView
extends EntryPopOverPane {
    private final Label summaryLabel;
    private final MenuButton recurrenceButton;

    public EntryDetailsView(Entry<?> entry) {
        this.getStyleClass().add((Object)"entry-details-view");
        Label fullDayLabel = new Label(Messages.getString("EntryDetailsView.FULL_DAY"));
        Label startDateLabel = new Label(Messages.getString("EntryDetailsView.FROM"));
        Label endDateLabel = new Label(Messages.getString("EntryDetailsView.TO"));
        Label recurrentLabel = new Label(Messages.getString("EntryDetailsView.REPEAT"));
        this.summaryLabel = new Label();
        this.summaryLabel.getStyleClass().add((Object)"recurrence-summary-label");
        this.summaryLabel.setWrapText(true);
        this.summaryLabel.setMaxWidth(300.0);
        CheckBox fullDay = new CheckBox();
        fullDay.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        TimeField startTimeField = new TimeField();
        startTimeField.setValue(entry.getStartTime());
        startTimeField.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        TimeField endTimeField = new TimeField();
        endTimeField.setValue(entry.getEndTime());
        endTimeField.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        DatePicker startDatePicker = new DatePicker();
        startDatePicker.setValue((Object)entry.getStartDate());
        startDatePicker.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        DatePicker endDatePicker = new DatePicker();
        endDatePicker.setValue((Object)entry.getEndDate());
        endDatePicker.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        entry.intervalProperty().addListener(it -> {
            startTimeField.setValue(entry.getStartTime());
            endTimeField.setValue(entry.getEndTime());
            startDatePicker.setValue((Object)entry.getStartDate());
            endDatePicker.setValue((Object)entry.getEndDate());
        });
        HBox startDateBox = new HBox(10.0);
        HBox endDateBox = new HBox(10.0);
        startDateBox.setAlignment(Pos.CENTER_LEFT);
        endDateBox.setAlignment(Pos.CENTER_LEFT);
        startDateBox.getChildren().addAll((Object[])new Node[]{startDateLabel, startDatePicker, startTimeField});
        endDateBox.getChildren().addAll((Object[])new Node[]{endDateLabel, endDatePicker, endTimeField});
        fullDay.setSelected(entry.isFullDay());
        startDatePicker.setValue((Object)entry.getStartDate());
        endDatePicker.setValue((Object)entry.getEndDate());
        Set<String> availableZoneIds = ZoneId.getAvailableZoneIds();
        ObservableList zoneIds = FXCollections.observableArrayList();
        for (String id : availableZoneIds) {
            ZoneId zoneId = ZoneId.of(id);
            if (zoneIds.contains((Object)zoneId)) continue;
            zoneIds.add((Object)zoneId);
        }
        zoneIds.sort(Comparator.comparing(ZoneId::getId));
        Label zoneLabel = new Label(Messages.getString("EntryDetailsView.TIMEZONE"));
        ComboBox zoneBox = new ComboBox(zoneIds);
        zoneBox.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        zoneBox.setConverter((StringConverter)new StringConverter<ZoneId>(){

            public String toString(ZoneId object) {
                return object.getId();
            }

            public ZoneId fromString(String string) {
                return null;
            }
        });
        zoneBox.setValue((Object)entry.getZoneId());
        this.recurrenceButton = new MenuButton(Messages.getString("EntryDetailsView.MENU_BUTTON_NONE"));
        MenuItem none = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_NONE"));
        MenuItem everyDay = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_DAY"));
        MenuItem everyWeek = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_WEEK"));
        MenuItem everyMonth = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_MONTH"));
        MenuItem everyYear = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_EVERY_YEAR"));
        MenuItem custom = new MenuItem(Messages.getString("EntryDetailsView.MENU_ITEM_CUSTOM"));
        none.setOnAction(evt -> this.updateRecurrenceRule(entry, null));
        everyDay.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=DAILY"));
        everyWeek.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=WEEKLY"));
        everyMonth.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=MONTHLY"));
        everyYear.setOnAction(evt -> this.updateRecurrenceRule(entry, "RRULE:FREQ=YEARLY"));
        custom.setOnAction(evt -> this.showRecurrenceEditor(entry));
        this.recurrenceButton.getItems().setAll((Object[])new MenuItem[]{none, everyDay, everyWeek, everyMonth, everyYear, new SeparatorMenuItem(), custom});
        this.recurrenceButton.disableProperty().bind((ObservableValue)entry.getCalendar().readOnlyProperty());
        GridPane box = new GridPane();
        box.getStyleClass().add((Object)"content");
        box.add((Node)fullDayLabel, 0, 0);
        box.add((Node)fullDay, 1, 0);
        box.add((Node)startDateLabel, 0, 1);
        box.add((Node)startDateBox, 1, 1);
        box.add((Node)endDateLabel, 0, 2);
        box.add((Node)endDateBox, 1, 2);
        box.add((Node)zoneLabel, 0, 3);
        box.add((Node)zoneBox, 1, 3);
        box.add((Node)recurrentLabel, 0, 4);
        box.add((Node)this.recurrenceButton, 1, 4);
        box.add((Node)this.summaryLabel, 1, 5);
        GridPane.setFillWidth((Node)zoneBox, (Boolean)true);
        GridPane.setHgrow((Node)zoneBox, (Priority)Priority.ALWAYS);
        ColumnConstraints col1 = new ColumnConstraints();
        ColumnConstraints col2 = new ColumnConstraints();
        col1.setHalignment(HPos.RIGHT);
        col2.setHalignment(HPos.LEFT);
        box.getColumnConstraints().addAll((Object[])new ColumnConstraints[]{col1, col2});
        this.getChildren().add((Object)box);
        startTimeField.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)entry.fullDayProperty()));
        endTimeField.visibleProperty().bind((ObservableValue)Bindings.not((ObservableBooleanValue)entry.fullDayProperty()));
        startDatePicker.valueProperty().addListener(evt -> entry.changeStartDate((LocalDate)startDatePicker.getValue(), true));
        startTimeField.valueProperty().addListener(evt -> entry.changeStartTime(startTimeField.getValue(), true));
        endDatePicker.valueProperty().addListener(evt -> entry.changeEndDate((LocalDate)endDatePicker.getValue(), false));
        endTimeField.valueProperty().addListener(evt -> entry.changeEndTime(endTimeField.getValue(), false));
        fullDay.setOnAction(evt -> entry.setFullDay(fullDay.isSelected()));
        zoneBox.setOnAction(evt -> entry.setZoneId((ZoneId)zoneBox.getValue()));
        entry.recurrenceRuleProperty().addListener(it -> this.updateRecurrenceRuleButton(entry));
        this.updateRecurrenceRuleButton(entry);
        entry.recurrenceRuleProperty().addListener(it -> this.updateSummaryLabel(entry));
    }

    private void updateSummaryLabel(Entry<?> entry) {
        String rule = entry.getRecurrenceRule();
        String text = Util.convertRFC2445ToText(rule, entry.getStartDate());
        this.summaryLabel.setText(text);
    }

    private void showRecurrenceEditor(Entry<?> entry) {
        RecurrencePopup popup = new RecurrencePopup();
        RecurrenceView recurrenceView = popup.getRecurrenceView();
        String recurrenceRule = entry.getRecurrenceRule();
        if (recurrenceRule == null || recurrenceRule.trim().equals("")) {
            recurrenceRule = "RRULE:FREQ=DAILY;";
        }
        recurrenceView.setRecurrenceRule(recurrenceRule);
        popup.setOnOkPressed((EventHandler<RecurrencePopup.RecurrencePopupEvent>)((EventHandler)evt -> {
            String rrule = recurrenceView.getRecurrenceRule();
            entry.setRecurrenceRule(rrule);
        }));
        Point2D anchor = this.recurrenceButton.localToScreen(0.0, this.recurrenceButton.getHeight());
        popup.show((Node)this.recurrenceButton, anchor.getX(), anchor.getY());
    }

    private void updateRecurrenceRule(Entry<?> entry, String rule) {
        entry.setRecurrenceRule(rule);
    }

    private void updateRecurrenceRuleButton(Entry<?> entry) {
        String rule = entry.getRecurrenceRule();
        if (rule == null) {
            this.recurrenceButton.setText(Messages.getString("EntryDetailsView.NONE"));
        } else {
            switch (rule.trim().toUpperCase()) {
                case "RRULE:FREQ=DAILY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.DAILY"));
                    break;
                }
                case "RRULE:FREQ=WEEKLY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.WEEKLY"));
                    break;
                }
                case "RRULE:FREQ=MONTHLY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.MONTHLY"));
                    break;
                }
                case "RRULE:FREQ=YEARLY": {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.YEARLY"));
                    break;
                }
                default: {
                    this.recurrenceButton.setText(Messages.getString("EntryDetailsView.CUSTOM"));
                }
            }
        }
    }
}

