/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.popover;

import com.calendarfx.model.Calendar;
import com.calendarfx.model.Entry;
import com.calendarfx.view.Messages;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;

class EntriesPane
extends VBox {
    private final ObservableList<Entry<?>> entries = FXCollections.observableArrayList();

    public EntriesPane() {
        this.setMinSize(0.0, 0.0);
        this.entries.addListener(evt -> this.update());
        this.getStyleClass().add((Object)"entries-pane");
        this.setAlignment(Pos.CENTER);
    }

    public final ObservableList<Entry<?>> getEntries() {
        return this.entries;
    }

    private void update() {
        if (!this.entries.isEmpty()) {
            ArrayList workingList = new ArrayList((Collection<Entry<?>>)this.entries);
            Collections.sort(workingList);
            for (Entry entry : workingList) {
                Calendar calendar = entry.getCalendar();
                BorderPane borderPane = new BorderPane();
                borderPane.getStyleClass().add((Object)"entry");
                Label titleLabel = new Label(entry.getTitle());
                BorderPane.setAlignment((Node)titleLabel, (Pos)Pos.CENTER_LEFT);
                titleLabel.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
                titleLabel.getStyleClass().add((Object)"title");
                borderPane.setCenter((Node)titleLabel);
                Circle colorDot = new Circle();
                colorDot.setRadius(2.5);
                colorDot.getStyleClass().add((Object)(calendar.getStyle() + "-icon-small"));
                titleLabel.setGraphic((Node)colorDot);
                Label timeLabel = new Label();
                if (entry.isFullDay()) {
                    timeLabel.setText(Messages.getString("EntriesPane.FULL_DAY"));
                } else {
                    timeLabel.setText(DateTimeFormatter.ofLocalizedTime(FormatStyle.SHORT).format(entry.getStartTime()));
                }
                borderPane.setRight((Node)timeLabel);
                timeLabel.getStyleClass().add((Object)"time");
                BorderPane.setAlignment((Node)timeLabel, (Pos)Pos.CENTER_RIGHT);
                this.getChildren().add((Object)borderPane);
            }
        }
    }
}

