/*
 * Decompiled with CFR 0.152.
 */
package com.calendarfx.view.page;

import com.calendarfx.view.Messages;
import com.calendarfx.view.MonthSheetView;
import com.calendarfx.view.YearView;
import com.calendarfx.view.page.PageBase;
import com.calendarfx.view.print.ViewType;
import de.jensd.fx.glyphs.GlyphIcons;
import de.jensd.fx.glyphs.fontawesome.FontAwesomeIcon;
import de.jensd.fx.glyphs.fontawesome.utils.FontAwesomeIconFactory;
import impl.com.calendarfx.view.page.YearPageSkin;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.text.Text;
import javafx.util.Callback;
import org.controlsfx.control.PropertySheet;

public class YearPage
extends PageBase {
    private YearView yearView;
    private MonthSheetView monthSheetView;
    private ToggleButton displayModeButton;
    private final ObjectProperty<DisplayMode> displayMode = new SimpleObjectProperty((Object)this, "displayMode", (Object)DisplayMode.GRID);
    private final String YEAR_PAGE_CATEGORY = "Year Page";

    public YearPage() {
        this.getStyleClass().add((Object)"year-page");
        this.yearView = new YearView();
        this.monthSheetView = new MonthSheetView();
        this.monthSheetView.setCellFactory((Callback<MonthSheetView.DateParameter, MonthSheetView.DateCell>)((Callback)param -> new MonthSheetView.DetailedDateCell(param.getView(), param.getDate())));
        this.monthSheetView.setClickBehaviour(MonthSheetView.ClickBehaviour.SHOW_DETAILS);
        this.bind(this.yearView, true);
        this.bind(this.monthSheetView, true);
        Bindings.bindBidirectional((Property)this.monthSheetView.showTodayProperty(), (Property)this.showTodayProperty());
        this.setDateTimeFormatter(DateTimeFormatter.ofPattern(Messages.getString("YearPage.DATE_FORMAT")));
        this.displayModeProperty().addListener(it -> this.updateDisplayModeIcon());
        this.displayModeButton = new ToggleButton();
        this.displayModeButton.setId("display-mode-button");
        this.displayModeButton.setTooltip(new Tooltip(Messages.getString("YearPage.TOOLTIP_DISPLAY_MODE")));
        this.displayModeButton.setSelected(this.getDisplayMode().equals((Object)DisplayMode.COLUMNS));
        this.displayModeButton.selectedProperty().addListener(it -> {
            if (this.displayModeButton.isSelected()) {
                this.setDisplayMode(DisplayMode.COLUMNS);
            } else {
                this.setDisplayMode(DisplayMode.GRID);
            }
        });
        this.displayModeProperty().addListener(it -> this.displayModeButton.setSelected(this.getDisplayMode().equals((Object)DisplayMode.COLUMNS)));
        this.updateDisplayModeIcon();
    }

    protected Skin<?> createDefaultSkin() {
        return new YearPageSkin(this);
    }

    @Override
    public Node getToolBarControls() {
        return this.displayModeButton;
    }

    private void updateDisplayModeIcon() {
        FontAwesomeIcon icon = FontAwesomeIcon.CALENDAR;
        if (this.getDisplayMode().equals((Object)DisplayMode.GRID)) {
            icon = FontAwesomeIcon.CALENDAR_ALT;
        }
        Text graphic = FontAwesomeIconFactory.get().createIcon((GlyphIcons)icon);
        graphic.getStyleClass().addAll((Object[])new String[]{"button-icon", "display-mode-icon"});
        this.displayModeButton.setGraphic((Node)graphic);
    }

    public final ObjectProperty<DisplayMode> displayModeProperty() {
        return this.displayMode;
    }

    public final DisplayMode getDisplayMode() {
        return (DisplayMode)((Object)this.displayMode.get());
    }

    public final void setDisplayMode(DisplayMode mode) {
        this.displayMode.set((Object)mode);
    }

    public final MonthSheetView getMonthSheetView() {
        return this.monthSheetView;
    }

    public final YearView getYearView() {
        return this.yearView;
    }

    @Override
    public final void goForward() {
        this.setDate(this.getDate().plusYears(1L));
    }

    @Override
    public final void goBack() {
        this.setDate(this.getDate().minusYears(1L));
    }

    @Override
    public final ViewType getPrintViewType() {
        return ViewType.MONTH_VIEW;
    }

    @Override
    public ObservableList<PropertySheet.Item> getPropertySheetItems() {
        ObservableList<PropertySheet.Item> items = super.getPropertySheetItems();
        items.add((Object)new PropertySheet.Item(){

            public Optional<ObservableValue<?>> getObservableValue() {
                return Optional.of(YearPage.this.displayModeProperty());
            }

            public void setValue(Object value) {
                YearPage.this.setDisplayMode((DisplayMode)((Object)value));
            }

            public Object getValue() {
                return YearPage.this.getDisplayMode();
            }

            public Class<?> getType() {
                return DisplayMode.class;
            }

            public String getName() {
                return "Display Mode";
            }

            public String getDescription() {
                return "Grid or Column Layout";
            }

            public String getCategory() {
                return "Year Page";
            }
        });
        return items;
    }

    public static enum DisplayMode {
        GRID,
        COLUMNS;

    }
}

